/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatanodeDescriptor
extends DatanodeInfo {
    private volatile SortedMap<Block, Block> blocks = new TreeMap<Block, Block>();
    protected boolean isAlive = false;
    List<Block> replicateBlocks;
    List<DatanodeDescriptor[]> replicateTargetSets;
    List<Block> invalidateBlocks;

    public DatanodeDescriptor() {
        this.initWorkLists();
    }

    public DatanodeDescriptor(DatanodeID nodeID) {
        this(nodeID, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        this(nodeID, networkLocation, null);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName) {
        this(nodeID, networkLocation, hostName, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, long capacity, long remaining, int xceiverCount) {
        super(nodeID);
        this.updateHeartbeat(capacity, remaining, xceiverCount);
        this.initWorkLists();
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName, long capacity, long remaining, int xceiverCount) {
        super(nodeID, networkLocation, hostName);
        this.updateHeartbeat(capacity, remaining, xceiverCount);
        this.initWorkLists();
    }

    private void initWorkLists() {
        this.replicateBlocks = new ArrayList<Block>();
        this.replicateTargetSets = new ArrayList<DatanodeDescriptor[]>();
        this.invalidateBlocks = new ArrayList<Block>();
    }

    void addBlock(Block b) {
        this.blocks.put(b, b);
    }

    void removeBlock(Block b) {
        this.blocks.remove(b);
    }

    void resetBlocks() {
        this.capacity = 0L;
        this.remaining = 0L;
        this.xceiverCount = 0;
        this.blocks.clear();
    }

    int numBlocks() {
        return this.blocks.size();
    }

    void updateHeartbeat(long capacity, long remaining, int xceiverCount) {
        this.capacity = capacity;
        this.remaining = remaining;
        this.lastUpdate = System.currentTimeMillis();
        this.xceiverCount = xceiverCount;
    }

    Block[] getBlocks() {
        return this.blocks.keySet().toArray(new Block[this.blocks.size()]);
    }

    Iterator<Block> getBlockIterator() {
        return this.blocks.keySet().iterator();
    }

    Block getBlock(long blockId) {
        return (Block)this.blocks.get(new Block(blockId, 0L));
    }

    Block getBlock(Block b) {
        return (Block)this.blocks.get(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeReplicated(Block[] blocklist, DatanodeDescriptor[][] targets) {
        assert (blocklist != null && targets != null);
        assert (blocklist.length > 0 && targets.length > 0);
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            assert (blocklist.length == targets.length);
            for (int i = 0; i < blocklist.length; ++i) {
                this.replicateBlocks.add(blocklist[i]);
                this.replicateTargetSets.add(targets[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(Block[] blocklist) {
        assert (blocklist != null && blocklist.length > 0);
        List<Block> list = this.invalidateBlocks;
        synchronized (list) {
            for (int i = 0; i < blocklist.length; ++i) {
                this.invalidateBlocks.add(blocklist[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeReplicated() {
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            return this.replicateBlocks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        List<Block> list = this.invalidateBlocks;
        synchronized (list) {
            return this.invalidateBlocks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getReplicationSets(int maxNumTransfers, Object[] xferResults) {
        assert (xferResults.length == 2);
        assert (xferResults[0] == null && xferResults[1] == null);
        List<Block> list = this.replicateBlocks;
        synchronized (list) {
            int i;
            assert (this.replicateBlocks.size() == this.replicateTargetSets.size());
            if (maxNumTransfers <= 0 || this.replicateBlocks.size() == 0) {
                return;
            }
            int numTransfers = 0;
            int numBlocks = 0;
            for (i = 0; i < this.replicateTargetSets.size() && numTransfers < maxNumTransfers; numTransfers += this.replicateTargetSets.get(i).length, ++i) {
            }
            numBlocks = i;
            Block[] blocklist = new Block[numBlocks];
            DatanodeDescriptor[][] targets = new DatanodeDescriptor[numBlocks][];
            for (i = 0; i < numBlocks; ++i) {
                blocklist[i] = this.replicateBlocks.get(0);
                targets[i] = this.replicateTargetSets.get(0);
                this.replicateBlocks.remove(0);
                this.replicateTargetSets.remove(0);
            }
            xferResults[0] = blocklist;
            xferResults[1] = targets;
            assert (blocklist.length > 0 && targets.length > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getInvalidateBlocks(int maxblocks, Object[] xferResults) {
        assert (xferResults[0] == null);
        List<Block> list = this.invalidateBlocks;
        synchronized (list) {
            if (maxblocks <= 0 || this.invalidateBlocks.size() == 0) {
                return;
            }
            int outnum = Math.min(maxblocks, this.invalidateBlocks.size());
            Block[] blocklist = new Block[outnum];
            for (int i = 0; i < outnum; ++i) {
                blocklist[i] = this.invalidateBlocks.get(0);
                this.invalidateBlocks.remove(0);
            }
            assert (blocklist.length > 0);
            xferResults[0] = blocklist;
        }
    }
}

