/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.AlreadyBeingCreatedException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.NotReplicatedYetException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

class DFSClient
implements FSConstants {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.DFSClient");
    static int MAX_BLOCK_ACQUIRE_FAILURES = 3;
    private static final int TCP_WINDOW_SIZE = 131072;
    private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
    ClientProtocol namenode;
    boolean running = true;
    Random r = new Random();
    String clientName;
    Daemon leaseChecker;
    private Configuration conf;
    private long defaultBlockSize;
    private short defaultReplication;
    private TreeMap<String, OutputStream> pendingCreates = new TreeMap();
    private static ClientFinalizer clientFinalizer = new ClientFinalizer();

    private static ClientProtocol createNamenode(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry(5, 200L, TimeUnit.MILLISECONDS);
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(5, 60000L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException(RetryPolicies.TRY_ONCE_THEN_FAIL, remoteExceptionToPolicyMap));
        exceptionToPolicyMap.put(SocketTimeoutException.class, timeoutPolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("open", methodPolicy);
        methodNameToPolicyMap.put("setReplication", methodPolicy);
        methodNameToPolicyMap.put("abandonBlock", methodPolicy);
        methodNameToPolicyMap.put("abandonFileInProgress", methodPolicy);
        methodNameToPolicyMap.put("reportBadBlocks", methodPolicy);
        methodNameToPolicyMap.put("exists", methodPolicy);
        methodNameToPolicyMap.put("isDir", methodPolicy);
        methodNameToPolicyMap.put("getListing", methodPolicy);
        methodNameToPolicyMap.put("getHints", methodPolicy);
        methodNameToPolicyMap.put("renewLease", methodPolicy);
        methodNameToPolicyMap.put("getStats", methodPolicy);
        methodNameToPolicyMap.put("getDatanodeReport", methodPolicy);
        methodNameToPolicyMap.put("getBlockSize", methodPolicy);
        methodNameToPolicyMap.put("getEditLogSize", methodPolicy);
        methodNameToPolicyMap.put("complete", methodPolicy);
        methodNameToPolicyMap.put("getEditLogSize", methodPolicy);
        methodNameToPolicyMap.put("create", methodPolicy);
        return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (Object)RPC.getProxy(ClientProtocol.class, 11L, nameNodeAddr, conf), methodNameToPolicyMap);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        this.conf = conf;
        this.namenode = DFSClient.createNamenode(nameNodeAddr, conf);
        String taskId = conf.get("mapred.task.id");
        this.clientName = taskId != null ? "DFSClient_" + taskId : "DFSClient_" + this.r.nextInt();
        this.defaultBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        this.leaseChecker = new Daemon(new LeaseChecker());
        this.leaseChecker.start();
    }

    private void checkOpen() throws IOException {
        if (!this.running) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DFSClient dFSClient = this;
        synchronized (dFSClient) {
            this.checkOpen();
            TreeMap<String, OutputStream> treeMap = this.pendingCreates;
            synchronized (treeMap) {
                for (String name : this.pendingCreates.keySet()) {
                    try {
                        this.namenode.abandonFileInProgress(name, this.clientName);
                    }
                    catch (IOException ie) {
                        System.err.println("Exception abandoning create lock on " + name);
                        ie.printStackTrace();
                    }
                }
                this.pendingCreates.clear();
            }
            this.running = false;
            try {
                this.leaseChecker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getBlockSize(UTF8 f) throws IOException {
        try {
            return this.namenode.getBlockSize(f.toString());
        }
        catch (IOException ie) {
            LOG.warn((Object)("Problem getting block size: " + StringUtils.stringifyException(ie)));
            throw ie;
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public String[][] getHints(UTF8 src, long start, long len) throws IOException {
        return this.namenode.getHints(src.toString(), start, len);
    }

    public DFSInputStream open(UTF8 src) throws IOException {
        this.checkOpen();
        return new DFSInputStream(src.toString());
    }

    public OutputStream create(UTF8 src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(UTF8 src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(UTF8 src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream create(UTF8 src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        this.checkOpen();
        DFSOutputStream result = new DFSOutputStream(src, overwrite, replication, blockSize, progress);
        TreeMap<String, OutputStream> treeMap = this.pendingCreates;
        synchronized (treeMap) {
            this.pendingCreates.put(src.toString(), result);
        }
        return result;
    }

    public boolean setReplication(UTF8 src, short replication) throws IOException {
        return this.namenode.setReplication(src.toString(), replication);
    }

    public boolean rename(UTF8 src, UTF8 dst) throws IOException {
        this.checkOpen();
        return this.namenode.rename(src.toString(), dst.toString());
    }

    public boolean delete(UTF8 src) throws IOException {
        this.checkOpen();
        return this.namenode.delete(src.toString());
    }

    public boolean exists(UTF8 src) throws IOException {
        this.checkOpen();
        return this.namenode.exists(src.toString());
    }

    public boolean isDirectory(UTF8 src) throws IOException {
        this.checkOpen();
        return this.namenode.isDir(src.toString());
    }

    public DFSFileInfo[] listPaths(UTF8 src) throws IOException {
        this.checkOpen();
        return this.namenode.getListing(src.toString());
    }

    public long totalRawCapacity() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[0];
    }

    public long totalRawUsed() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[1];
    }

    public DatanodeInfo[] datanodeReport() throws IOException {
        return this.namenode.getDatanodeReport();
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namenode.setSafeMode(action);
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    public boolean mkdirs(UTF8 src) throws IOException {
        this.checkOpen();
        return this.namenode.mkdirs(src.toString());
    }

    public void lock(UTF8 src, boolean exclusive) throws IOException {
        long start = System.currentTimeMillis();
        boolean hasLock = false;
        while (!hasLock) {
            hasLock = this.namenode.obtainLock(src.toString(), this.clientName, exclusive);
            if (hasLock) continue;
            try {
                Thread.sleep(400L);
                if (System.currentTimeMillis() - start <= 5000L) continue;
                LOG.info((Object)("Waiting to retry lock for " + (System.currentTimeMillis() - start) + " ms."));
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {}
        }
    }

    public void release(UTF8 src) throws IOException {
        boolean hasReleased = false;
        while (!hasReleased) {
            hasReleased = this.namenode.releaseLock(src.toString(), this.clientName);
            if (hasReleased) continue;
            LOG.info((Object)"Could not release.  Retrying...");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private DatanodeInfo bestNode(DatanodeInfo[] nodes, TreeSet deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.contains(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    static {
        Runtime.getRuntime().addShutdownHook(clientFinalizer);
    }

    class DFSOutputStream
    extends OutputStream {
        private Socket s;
        boolean closed = false;
        private byte[] outBuf = new byte[FSConstants.BUFFER_SIZE];
        private int pos = 0;
        private UTF8 src;
        private boolean overwrite;
        private short replication;
        private boolean firstTime = true;
        private DataOutputStream blockStream;
        private DataInputStream blockReplyStream;
        private File backupFile;
        private OutputStream backupStream;
        private Block block;
        private long filePos = 0L;
        private int bytesWrittenToBlock = 0;
        private String datanodeName;
        private long blockSize;
        private Progressable progress;

        public DFSOutputStream(UTF8 src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
            this.src = src;
            this.overwrite = overwrite;
            this.replication = replication;
            this.backupFile = this.newBackupFile();
            this.blockSize = blockSize;
            this.backupStream = new FileOutputStream(this.backupFile);
            this.progress = progress;
            if (progress != null) {
                LOG.debug((Object)("Set non-null progress callback on DFSOutputStream " + src));
            }
        }

        private void closeBackupStream() throws IOException {
            if (this.backupStream != null) {
                OutputStream stream = this.backupStream;
                this.backupStream = null;
                stream.close();
            }
        }

        private void deleteBackupFile() {
            if (this.backupFile != null) {
                File file = this.backupFile;
                this.backupFile = null;
                file.delete();
            }
        }

        private File newBackupFile() throws IOException {
            File result = DFSClient.this.conf.getFile("dfs.client.buffer.dir", "tmp" + File.separator + "client-" + Math.abs(DFSClient.this.r.nextLong()));
            result.deleteOnExit();
            return result;
        }

        private synchronized void nextBlockOutputStream() throws IOException {
            boolean retry = false;
            long startTime = System.currentTimeMillis();
            do {
                retry = false;
                LocatedBlock lb = this.firstTime ? this.locateNewBlock() : this.locateFollowingBlock(startTime);
                this.block = lb.getBlock();
                if (this.block.getNumBytes() < (long)this.bytesWrittenToBlock) {
                    this.block.setNumBytes(this.bytesWrittenToBlock);
                }
                DatanodeInfo[] nodes = lb.getLocations();
                InetSocketAddress target = DataNode.createSocketAddr(nodes[0].getName());
                try {
                    this.s = new Socket();
                    this.s.connect(target, 60000);
                    this.s.setSoTimeout(this.replication * 60000);
                    this.datanodeName = nodes[0].getName();
                }
                catch (IOException ie) {
                    try {
                        if (System.currentTimeMillis() - startTime > 5000L) {
                            LOG.info((Object)("Waiting to find target node: " + target));
                        }
                        Thread.sleep(6000L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    if (this.firstTime) {
                        DFSClient.this.namenode.abandonFileInProgress(this.src.toString(), DFSClient.this.clientName);
                    } else {
                        DFSClient.this.namenode.abandonBlock(this.block, this.src.toString());
                    }
                    retry = true;
                    continue;
                }
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.s.getOutputStream()));
                out.write(80);
                out.writeBoolean(true);
                this.block.write(out);
                out.writeInt(nodes.length);
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i].write(out);
                }
                out.write(1);
                this.blockStream = out;
                this.blockReplyStream = new DataInputStream(new BufferedInputStream(this.s.getInputStream()));
            } while (retry);
            this.firstTime = false;
        }

        private LocatedBlock locateNewBlock() throws IOException {
            return DFSClient.this.namenode.create(this.src.toString(), DFSClient.this.clientName.toString(), this.overwrite, this.replication, this.blockSize);
        }

        private LocatedBlock locateFollowingBlock(long start) throws IOException {
            int retries = 5;
            long sleeptime = 400L;
            long localstart = System.currentTimeMillis();
            while (true) {
                try {
                    return DFSClient.this.namenode.addBlock(this.src.toString(), DFSClient.this.clientName.toString());
                }
                catch (RemoteException e) {
                    if (--retries == 0 || !NotReplicatedYetException.class.getName().equals(e.getClassName())) {
                        throw e;
                    }
                    LOG.info((Object)StringUtils.stringifyException(e));
                    if (System.currentTimeMillis() - localstart > 5000L) {
                        LOG.info((Object)("Waiting for replication for " + (System.currentTimeMillis() - localstart) / 1000L + " seconds"));
                    }
                    try {
                        LOG.debug((Object)("NotReplicatedYetException sleeping " + this.src + " retries left " + retries));
                        Thread.sleep(sleeptime);
                    }
                    catch (InterruptedException ie) {
                    }
                    continue;
                }
                break;
            }
        }

        public synchronized long getPos() throws IOException {
            return this.filePos;
        }

        public synchronized void write(int b) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if ((long)(this.bytesWrittenToBlock + this.pos) == this.blockSize || this.pos >= FSConstants.BUFFER_SIZE) {
                this.flush();
            }
            this.outBuf[this.pos++] = (byte)b;
            ++this.filePos;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            while (len > 0) {
                int remaining = Math.min(FSConstants.BUFFER_SIZE - this.pos, (int)(this.blockSize - (long)this.bytesWrittenToBlock - (long)this.pos));
                int toWrite = Math.min(remaining, len);
                System.arraycopy(b, off, this.outBuf, this.pos, toWrite);
                this.pos += toWrite;
                off += toWrite;
                len -= toWrite;
                this.filePos += (long)toWrite;
                if ((long)(this.bytesWrittenToBlock + this.pos) < this.blockSize && this.pos != FSConstants.BUFFER_SIZE) continue;
                this.flush();
            }
        }

        public synchronized void flush() throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if ((long)(this.bytesWrittenToBlock + this.pos) >= this.blockSize) {
                this.flushData((int)this.blockSize - this.bytesWrittenToBlock);
            }
            if ((long)this.bytesWrittenToBlock == this.blockSize) {
                this.endBlock();
            }
            this.flushData(this.pos);
        }

        private synchronized void flushData(int maxPos) throws IOException {
            int workingPos = Math.min(this.pos, maxPos);
            if (workingPos > 0) {
                if (this.backupStream == null) {
                    throw new IOException("Trying to write to backupStream but it already closed or not open");
                }
                this.backupStream.write(this.outBuf, 0, workingPos);
                this.bytesWrittenToBlock += workingPos;
                System.arraycopy(this.outBuf, workingPos, this.outBuf, 0, this.pos - workingPos);
                this.pos -= workingPos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void endBlock() throws IOException {
            long sleeptime = 400L;
            this.closeBackupStream();
            boolean sentOk = false;
            int remainingAttempts = DFSClient.this.conf.getInt("dfs.client.block.write.retries", 3);
            while (!sentOk) {
                this.nextBlockOutputStream();
                FileInputStream in = new FileInputStream(this.backupFile);
                try {
                    byte[] buf = new byte[FSConstants.BUFFER_SIZE];
                    int bytesRead = ((InputStream)in).read(buf);
                    while (bytesRead > 0) {
                        this.blockStream.writeLong(bytesRead);
                        this.blockStream.write(buf, 0, bytesRead);
                        if (this.progress != null) {
                            this.progress.progress();
                        }
                        bytesRead = ((InputStream)in).read(buf);
                    }
                    this.internalClose();
                    sentOk = true;
                }
                catch (IOException ie) {
                    this.handleSocketException(ie);
                    if (--remainingAttempts == 0) {
                        throw ie;
                    }
                    try {
                        Thread.sleep(sleeptime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            this.bytesWrittenToBlock = 0;
            this.deleteBackupFile();
            File tmpFile = this.newBackupFile();
            this.bytesWrittenToBlock = 0;
            this.backupStream = new FileOutputStream(tmpFile);
            this.backupFile = tmpFile;
        }

        private synchronized void internalClose() throws IOException {
            try {
                this.blockStream.writeLong(0L);
                this.blockStream.flush();
                long complete = this.blockReplyStream.readLong();
                if (complete != -889528038L) {
                    LOG.info((Object)("Did not receive WRITE_COMPLETE flag: " + complete));
                    throw new IOException("Did not receive WRITE_COMPLETE_FLAG: " + complete);
                }
            }
            catch (IOException ie) {
                throw (IOException)new IOException("failure closing block of file " + this.src.toString() + " to node " + (this.datanodeName == null ? "?" : this.datanodeName)).initCause(ie);
            }
            LocatedBlock lb = new LocatedBlock();
            lb.readFields(this.blockReplyStream);
            this.s.close();
            this.s = null;
        }

        private void handleSocketException(IOException ie) throws IOException {
            LOG.warn((Object)"Error while writing.", (Throwable)ie);
            try {
                if (this.s != null) {
                    this.s.close();
                    this.s = null;
                }
            }
            catch (IOException ie2) {
                LOG.warn((Object)"Error closing socket.", (Throwable)ie2);
            }
            DFSClient.this.namenode.abandonBlock(this.block, this.src.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            try {
                this.flush();
                if (this.filePos == 0L || this.bytesWrittenToBlock != 0) {
                    try {
                        this.endBlock();
                    }
                    catch (IOException e) {
                        DFSClient.this.namenode.abandonFileInProgress(this.src.toString(), DFSClient.this.clientName);
                        throw e;
                    }
                }
                this.closeBackupStream();
                this.deleteBackupFile();
                if (this.s != null) {
                    this.s.close();
                    this.s = null;
                }
                super.close();
                long localstart = System.currentTimeMillis();
                boolean fileComplete = false;
                while (!fileComplete) {
                    fileComplete = DFSClient.this.namenode.complete(this.src.toString(), DFSClient.this.clientName.toString());
                    if (fileComplete) continue;
                    try {
                        Thread.sleep(400L);
                        if (System.currentTimeMillis() - localstart <= 5000L) continue;
                        LOG.info((Object)"Could not complete file, retrying...");
                    }
                    catch (InterruptedException ie) {}
                }
                this.closed = true;
            }
            finally {
                TreeMap treeMap = DFSClient.this.pendingCreates;
                synchronized (treeMap) {
                    DFSClient.this.pendingCreates.remove(this.src.toString());
                }
            }
        }
    }

    static class DFSDataInputStream
    extends FSDataInputStream {
        DFSDataInputStream(DFSInputStream in, Configuration conf) throws IOException {
            super((FSInputStream)in, conf);
        }

        DFSDataInputStream(DFSInputStream in, int bufferSize) throws IOException {
            super((FSInputStream)in, bufferSize);
        }

        public DatanodeInfo getCurrentDatanode() {
            return ((DFSInputStream)this.inStream).getCurrentDatanode();
        }

        public Block getCurrentBlock() {
            return ((DFSInputStream)this.inStream).getCurrentBlock();
        }

        synchronized DatanodeInfo[][] getDataNodes() {
            return ((DFSInputStream)this.inStream).getDataNodes();
        }
    }

    class DFSInputStream
    extends FSInputStream {
        private Socket s = null;
        boolean closed = false;
        private String src;
        private DataInputStream blockStream;
        private Block[] blocks = null;
        private DatanodeInfo[][] nodes = null;
        private DatanodeInfo currentNode = null;
        private Block currentBlock = null;
        private long pos = 0L;
        private long filelen = 0L;
        private long blockEnd = -1L;
        private TreeSet<DatanodeInfo> deadNodes = new TreeSet();

        public DFSInputStream(String src) throws IOException {
            this.src = src;
            this.openInfo();
            this.blockStream = null;
            for (int i = 0; i < this.blocks.length; ++i) {
                this.filelen += this.blocks[i].getNumBytes();
            }
        }

        synchronized void openInfo() throws IOException {
            Block[] oldBlocks = this.blocks;
            LocatedBlock[] results = DFSClient.this.namenode.open(this.src);
            Vector<Block> blockV = new Vector<Block>();
            Vector<DatanodeInfo[]> nodeV = new Vector<DatanodeInfo[]>();
            for (int i = 0; i < results.length; ++i) {
                blockV.add(results[i].getBlock());
                nodeV.add(results[i].getLocations());
            }
            Block[] newBlocks = blockV.toArray(new Block[blockV.size()]);
            if (oldBlocks != null) {
                for (int i = 0; i < oldBlocks.length; ++i) {
                    if (oldBlocks[i].equals(newBlocks[i])) continue;
                    throw new IOException("Blocklist for " + this.src + " has changed!");
                }
                if (oldBlocks.length != newBlocks.length) {
                    throw new IOException("Blocklist for " + this.src + " now has different length");
                }
            }
            this.blocks = newBlocks;
            this.nodes = (DatanodeInfo[][])nodeV.toArray((T[])new DatanodeInfo[nodeV.size()][]);
            this.currentNode = null;
        }

        public DatanodeInfo getCurrentDatanode() {
            return this.currentNode;
        }

        public Block getCurrentBlock() {
            return this.currentBlock;
        }

        synchronized DatanodeInfo[][] getDataNodes() {
            return this.nodes;
        }

        private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
            if (target >= this.filelen) {
                throw new IOException("Attempted to read past end of file");
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            int targetBlock = -1;
            long targetBlockStart = 0L;
            long targetBlockEnd = 0L;
            for (int i = 0; i < this.blocks.length; ++i) {
                long blocklen = this.blocks[i].getNumBytes();
                targetBlockEnd = targetBlockStart + blocklen - 1L;
                if (target >= targetBlockStart && target <= targetBlockEnd) {
                    targetBlock = i;
                    break;
                }
                targetBlockStart = targetBlockEnd + 1L;
            }
            if (targetBlock < 0) {
                throw new IOException("Impossible situation: could not find target position " + target);
            }
            long offsetIntoBlock = target - targetBlockStart;
            DatanodeInfo chosenNode = null;
            while (this.s == null) {
                DNAddrPair retval = this.chooseDataNode(targetBlock);
                chosenNode = retval.info;
                InetSocketAddress targetAddr = retval.addr;
                try {
                    this.s = new Socket();
                    this.s.connect(targetAddr, 60000);
                    this.s.setSoTimeout(60000);
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.s.getOutputStream()));
                    out.write(82);
                    this.blocks[targetBlock].write(out);
                    out.writeLong(offsetIntoBlock);
                    out.flush();
                    DataInputStream in = new DataInputStream(new BufferedInputStream(this.s.getInputStream()));
                    long curBlockSize = in.readLong();
                    long amtSkipped = in.readLong();
                    if (curBlockSize != this.blocks[targetBlock].len) {
                        throw new IOException("Recorded block size is " + this.blocks[targetBlock].len + ", but datanode reports size of " + curBlockSize);
                    }
                    if (amtSkipped != offsetIntoBlock) {
                        throw new IOException("Asked for offset of " + offsetIntoBlock + ", but only received offset of " + amtSkipped);
                    }
                    this.pos = target;
                    this.blockEnd = targetBlockEnd;
                    this.currentBlock = this.blocks[targetBlock];
                    this.blockStream = in;
                    return chosenNode;
                }
                catch (IOException ex) {
                    LOG.debug((Object)("Failed to connect to " + targetAddr + ":" + StringUtils.stringifyException(ex)));
                    this.deadNodes.add(chosenNode);
                    if (this.s != null) {
                        try {
                            this.s.close();
                        }
                        catch (IOException iex) {
                            // empty catch block
                        }
                    }
                    this.s = null;
                }
            }
            return chosenNode;
        }

        public synchronized void close() throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.s != null) {
                this.blockStream.close();
                this.s.close();
                this.s = null;
            }
            super.close();
            this.closed = true;
        }

        public synchronized int read() throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            int result = -1;
            if (this.pos < this.filelen) {
                if (this.pos > this.blockEnd) {
                    this.currentNode = this.blockSeekTo(this.pos);
                }
                if ((result = this.blockStream.read()) >= 0) {
                    ++this.pos;
                }
            }
            return result;
        }

        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.filelen) {
                int retries = 2;
                while (retries > 0) {
                    try {
                        int realLen;
                        int result;
                        if (this.pos > this.blockEnd) {
                            this.currentNode = this.blockSeekTo(this.pos);
                        }
                        if ((result = this.blockStream.read(buf, off, realLen = Math.min(len, (int)(this.blockEnd - this.pos + 1L)))) >= 0) {
                            this.pos += (long)result;
                        }
                        return result;
                    }
                    catch (IOException e) {
                        if (retries == 1) {
                            LOG.warn((Object)("DFS Read: " + StringUtils.stringifyException(e)));
                        }
                        this.blockEnd = -1L;
                        if (this.currentNode != null) {
                            this.deadNodes.add(this.currentNode);
                        }
                        if (--retries != 0) continue;
                        throw e;
                    }
                }
            }
            return -1;
        }

        private DNAddrPair chooseDataNode(int blockId) throws IOException {
            int failures = 0;
            while (true) {
                try {
                    DatanodeInfo chosenNode = DFSClient.this.bestNode(this.nodes[blockId], this.deadNodes);
                    InetSocketAddress targetAddr = DataNode.createSocketAddr(chosenNode.getName());
                    return new DNAddrPair(chosenNode, targetAddr);
                }
                catch (IOException ie) {
                    String blockInfo = this.blocks[blockId] + " file=" + this.src;
                    if (failures >= MAX_BLOCK_ACQUIRE_FAILURES) {
                        throw new IOException("Could not obtain block: " + blockInfo);
                    }
                    if (this.nodes[blockId] == null || this.nodes[blockId].length == 0) {
                        LOG.info((Object)("No node available for block: " + blockInfo));
                    }
                    LOG.info((Object)("Could not obtain block " + blockId + " from any node:  " + ie));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    this.deadNodes.clear();
                    this.openInfo();
                    ++failures;
                    continue;
                }
                break;
            }
        }

        private void fetchBlockByteRange(int blockId, long start, long end, byte[] buf, int offset) throws IOException {
            Socket dn = null;
            while (dn == null) {
                DNAddrPair retval = this.chooseDataNode(blockId);
                DatanodeInfo chosenNode = retval.info;
                InetSocketAddress targetAddr = retval.addr;
                try {
                    dn = new Socket();
                    dn.connect(targetAddr, 60000);
                    dn.setSoTimeout(60000);
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(dn.getOutputStream()));
                    out.write(83);
                    this.blocks[blockId].write(out);
                    out.writeLong(start);
                    out.writeLong(end);
                    out.flush();
                    DataInputStream in = new DataInputStream(new BufferedInputStream(dn.getInputStream()));
                    long curBlockSize = in.readLong();
                    long actualStart = in.readLong();
                    long actualEnd = in.readLong();
                    if (curBlockSize != this.blocks[blockId].len) {
                        throw new IOException("Recorded block size is " + this.blocks[blockId].len + ", but datanode reports size of " + curBlockSize);
                    }
                    if (actualStart != start || actualEnd != end) {
                        throw new IOException("Asked for byte range  " + start + "-" + end + ", but only received range " + actualStart + "-" + actualEnd);
                    }
                    int nread = in.read(buf, offset, (int)(end - start + 1L));
                }
                catch (IOException ex) {
                    LOG.debug((Object)("Failed to connect to " + targetAddr + ":" + StringUtils.stringifyException(ex)));
                    this.deadNodes.add(chosenNode);
                    if (dn != null) {
                        try {
                            dn.close();
                        }
                        catch (IOException iex) {
                            // empty catch block
                        }
                    }
                    dn = null;
                }
            }
        }

        public int read(long position, byte[] buf, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (position < 0L || position > this.filelen) {
                return -1;
            }
            int realLen = len;
            if (position + (long)len > this.filelen) {
                realLen = (int)(this.filelen - position);
            }
            int targetBlock = -1;
            long targetStart = 0L;
            long targetEnd = 0L;
            for (int idx = 0; idx < this.blocks.length; ++idx) {
                long blocklen = this.blocks[idx].getNumBytes();
                targetEnd = targetStart + blocklen - 1L;
                if (position >= targetStart && position <= targetEnd) {
                    targetBlock = idx;
                    targetStart = position - targetStart;
                    targetEnd = Math.min(blocklen, targetStart + (long)realLen) - 1L;
                    realLen = (int)(targetEnd - targetStart + 1L);
                    break;
                }
                targetStart += blocklen;
            }
            if (targetBlock < 0) {
                throw new IOException("Impossible situation: could not find target position " + position);
            }
            this.fetchBlockByteRange(targetBlock, targetStart, targetEnd, buf, off);
            return realLen;
        }

        public synchronized void seek(long targetPos) throws IOException {
            int diff;
            if (targetPos > this.filelen) {
                throw new IOException("Cannot seek after EOF");
            }
            boolean done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                int adiff = this.blockStream.skipBytes(diff);
                this.pos += (long)adiff;
                if (this.pos == targetPos) {
                    done = true;
                }
            }
            if (!done) {
                this.pos = targetPos;
                this.blockEnd = -1L;
            }
        }

        public synchronized boolean seekToNewSource(long targetPos) throws IOException {
            boolean markedDead = this.deadNodes.contains(this.currentNode);
            this.deadNodes.add(this.currentNode);
            DatanodeInfo oldNode = this.currentNode;
            DatanodeInfo newNode = this.blockSeekTo(targetPos);
            if (!markedDead) {
                this.deadNodes.remove(oldNode);
            }
            if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
                this.currentNode = newNode;
                return true;
            }
            return false;
        }

        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            return (int)(this.filelen - this.pos);
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
        }

        public void reset() throws IOException {
            throw new IOException("Mark not supported");
        }
    }

    private static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }

    class LeaseChecker
    implements Runnable {
        LeaseChecker() {
        }

        public void run() {
            long lastRenewed = 0L;
            while (DFSClient.this.running) {
                if (System.currentTimeMillis() - lastRenewed > 30000L) {
                    try {
                        if (DFSClient.this.pendingCreates.size() > 0) {
                            DFSClient.this.namenode.renewLease(DFSClient.this.clientName);
                        }
                        lastRenewed = System.currentTimeMillis();
                    }
                    catch (IOException ie) {
                        String err = StringUtils.stringifyException(ie);
                        LOG.warn((Object)("Problem renewing lease for " + DFSClient.this.clientName + ": " + err));
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class ClientFinalizer
    extends Thread {
        private List<DFSClient> clients = new ArrayList<DFSClient>();

        private ClientFinalizer() {
        }

        public synchronized void addClient(DFSClient client) {
            this.clients.add(client);
        }

        public synchronized void run() {
            for (DFSClient client : this.clients) {
                if (!client.running) continue;
                try {
                    client.close();
                }
                catch (IOException ie) {
                    System.err.println("Error closing client");
                    ie.printStackTrace();
                }
            }
        }
    }
}

