/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;

public class DFSAdmin
extends FsShell {
    public void report() throws IOException {
        if (this.fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
            long raw = dfs.getRawCapacity();
            long rawUsed = dfs.getRawUsed();
            long used = dfs.getUsed();
            boolean mode = dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET);
            if (mode) {
                System.out.println("Safe mode is ON");
            }
            System.out.println("Total raw bytes: " + raw + " (" + DFSAdmin.byteDesc(raw) + ")");
            System.out.println("Used raw bytes: " + rawUsed + " (" + DFSAdmin.byteDesc(rawUsed) + ")");
            System.out.println("% used: " + DFSAdmin.limitDecimal(1.0 * (double)rawUsed / (double)raw * 100.0, 2) + "%");
            System.out.println();
            System.out.println("Total effective bytes: " + used + " (" + DFSAdmin.byteDesc(used) + ")");
            System.out.println("Effective replication multiplier: " + 1.0 * (double)rawUsed / (double)used);
            System.out.println("-------------------------------------------------");
            DatanodeInfo[] info = dfs.getDataNodeStats();
            System.out.println("Datanodes available: " + info.length);
            System.out.println();
            for (int i = 0; i < info.length; ++i) {
                System.out.println(info[i].getDatanodeReport());
                System.out.println();
            }
        }
    }

    public void setSafeMode(String[] argv, int idx) throws IOException {
        FSConstants.SafeModeAction action;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getName());
            return;
        }
        if (idx != argv.length - 1) {
            this.printUsage("-safemode");
            return;
        }
        Boolean waitExitSafe = false;
        if ("leave".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_LEAVE;
        } else if ("enter".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_ENTER;
        } else if ("get".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
        } else if ("wait".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
            waitExitSafe = true;
        } else {
            this.printUsage("-safemode");
            return;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        boolean inSafeMode = dfs.setSafeMode(action);
        if (waitExitSafe.booleanValue()) {
            while (inSafeMode) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait Interrupted");
                }
                inSafeMode = dfs.setSafeMode(action);
            }
        }
        System.out.println("Safe mode is " + (inSafeMode ? "ON" : "OFF"));
    }

    public int refreshNodes() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getName());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.refreshNodes();
        exitCode = 0;
        return exitCode;
    }

    private void printHelp(String cmd) {
        String summary = "hadoop dfsadmin is the command to execute dfs administrative commands.\nThe full syntax is: \n\nhadoop dfsadmin [-report] [-safemode <enter | leave | get | wait>]\n\t[-refreshNodes] [-help [cmd]]\n";
        String report = "-report: \tReports basic filesystem information and statistics.\n";
        String safemode = "-safemode <enter|leave|get|wait>:  Safemode maintenance command.\n\t\tSafe mode is a name node state when it\n\t\t\t1.  does not accept changes to name space (read-only)\n\t\t\t2.  does not replicate or delete blocks.\n\t\tSafe mode is entered automatically at name node startup, and\n\t\tleaves safe mode automatically when the configured minimum\n\t\tpercentage of blocks satisfies the minimal replication\n\t\tcondition.  Safe mode can also be entered manually, but then\n\t\tcan only be turned off manually as well.\n";
        String refreshNodes = "-refreshNodes: \tReread the hosts and exclude files to update the set\n\t\tof datanodes that are allowed to connect to the namenode\n\t\tand those that should be decommissioned/recommissioned.\n";
        String help = "-help [cmd]: \tDisplays help for given command or all commands if none\n\t\tis specified.\n";
        if ("report".equals(cmd)) {
            System.out.println(report);
        } else if ("safemode".equals(cmd)) {
            System.out.println(safemode);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(report);
            System.out.println(safemode);
            System.out.println(refreshNodes);
            System.out.println(help);
        }
    }

    public int finalizeUpgrade() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.out.println("FileSystem is " + this.fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.finalizeUpgrade();
        exitCode = 0;
        return exitCode;
    }

    public int metaSave(String[] argv, int idx) throws IOException {
        String pathname = argv[idx];
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.metaSave(pathname);
        System.out.println("Created file " + pathname + " on server " + dfs.getUri());
        return 0;
    }

    public void printUsage(String cmd) {
        if ("-report".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-report]");
        } else if ("-safemode".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-safemode enter | leave | get | wait]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshNodes]");
        } else if ("-finalizeUpgrade".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-finalizeUpgrade]");
        } else if ("-metasave".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-metasave filename]");
        } else {
            System.err.println("Usage: java DFSAdmin");
            System.err.println("           [-report]");
            System.err.println("           [-safemode enter | leave | get | wait]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-finalizeUpgrade]");
            System.err.println("           [-metasave filename]");
            System.err.println("           [-help [cmd]]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            this.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-safemode".equals(cmd = argv[i++])) {
            if (argv.length != 2) {
                this.printUsage(cmd);
                return exitCode;
            }
        } else if ("-report".equals(cmd)) {
            if (argv.length != 1) {
                this.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNodes".equals(cmd)) {
            if (argv.length != 1) {
                this.printUsage(cmd);
                return exitCode;
            }
        } else if ("-finalizeUpgrade".equals(cmd)) {
            if (argv.length != 1) {
                this.printUsage(cmd);
                return exitCode;
            }
        } else if ("-metasave".equals(cmd) && argv.length != 2) {
            this.printUsage(cmd);
            return exitCode;
        }
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to DFS... command aborted.");
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-report".equals(cmd)) {
                this.report();
            } else if ("-safemode".equals(cmd)) {
                this.setSafeMode(argv, i);
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-finalizeUpgrade".equals(cmd)) {
                exitCode = this.finalizeUpgrade();
            } else if ("-metasave".equals(cmd)) {
                exitCode = this.metaSave(argv, i);
            } else if ("-help".equals(cmd)) {
                if (i < argv.length) {
                    this.printHelp(argv[i]);
                } else {
                    this.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                this.printUsage("");
            }
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        finally {
            this.fs.close();
        }
        return exitCode;
    }

    public static void main(String[] argv) throws Exception {
        int res = new DFSAdmin().doMain(new Configuration(), argv);
        System.exit(res);
    }
}

