/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlocksMap {
    private Map<Block, BlockInfo> map = new HashMap<Block, BlockInfo>();

    BlocksMap() {
    }

    private BlockInfo checkBlockInfo(Block b) {
        BlockInfo info = this.map.get(b);
        if (info == null) {
            info = new BlockInfo();
            info.block = b;
            this.map.put(b, info);
        }
        return info;
    }

    public FSDirectory.INode getINode(Block b) {
        BlockInfo info = this.map.get(b);
        return info != null ? info.inode : null;
    }

    public void addINode(Block b, FSDirectory.INode iNode) {
        BlockInfo info = this.checkBlockInfo(b);
        info.inode = iNode;
    }

    public void removeINode(Block b) {
        BlockInfo info = this.map.get(b);
        if (info != null) {
            info.inode = null;
            if (info.nodes == null) {
                this.map.remove(b);
            }
        }
    }

    public Block getStoredBlock(Block b) {
        BlockInfo info = this.map.get(b);
        return info != null ? info.block : null;
    }

    public Iterator<DatanodeDescriptor> nodeIterator(Block b) {
        BlockInfo info = this.map.get(b);
        return new NodeIterator(info != null ? info.nodes : null);
    }

    public int numNodes(Block b) {
        int count = 0;
        BlockInfo info = this.map.get(b);
        if (info != null && info.nodes != null) {
            count = info.nodes.length;
            while (info.nodes[count - 1] == null) {
                --count;
            }
        }
        return count;
    }

    public boolean addNode(Block b, DatanodeDescriptor node, int replicationHint) {
        int i;
        BlockInfo info = this.checkBlockInfo(b);
        if (info.nodes == null) {
            BlockInfo.access$202(info, new DatanodeDescriptor[replicationHint]);
        }
        DatanodeDescriptor[] arr = info.nodes;
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] == null) {
                arr[i] = node;
                return true;
            }
            if (arr[i] != node) continue;
            return false;
        }
        BlockInfo.access$202(info, new DatanodeDescriptor[arr.length + 1]);
        for (i = 0; i < arr.length; ++i) {
            ((BlockInfo)info).nodes[i] = arr[i];
        }
        ((BlockInfo)info).nodes[arr.length] = node;
        return true;
    }

    public boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.map.get(b);
        if (info == null || info.nodes == null) {
            return false;
        }
        boolean removed = false;
        DatanodeDescriptor[] arr = info.nodes;
        int lastNode = -1;
        for (int i = arr.length - 1; i >= 0; --i) {
            if (lastNode < 0 && arr[i] != null) {
                lastNode = i;
            }
            if (arr[i] != node) continue;
            arr[i] = arr[lastNode];
            arr[lastNode] = null;
            removed = true;
            break;
        }
        if (arr[0] == null) {
            BlockInfo.access$202(info, null);
            if (info.inode == null) {
                this.map.remove(b);
            }
        }
        return removed;
    }

    public int size() {
        return this.map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeIterator
    implements Iterator<DatanodeDescriptor> {
        private DatanodeDescriptor[] arr;
        private int nextIdx = 0;

        NodeIterator(DatanodeDescriptor[] nodes) {
            this.arr = nodes;
        }

        @Override
        public boolean hasNext() {
            return this.arr != null && this.nextIdx < this.arr.length && this.arr[this.nextIdx] != null;
        }

        @Override
        public DatanodeDescriptor next() {
            return this.arr[this.nextIdx++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }

    class BlockInfo {
        private FSDirectory.INode inode;
        private DatanodeDescriptor[] nodes;
        private Block block;

        BlockInfo() {
        }

        static /* synthetic */ DatanodeDescriptor[] access$202(BlockInfo x0, DatanodeDescriptor[] x1) {
            x0.nodes = x1;
            return x1;
        }
    }
}

