/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class BlockCommand
extends DatanodeCommand {
    Block[] blocks;
    DatanodeInfo[][] targets;

    public BlockCommand() {
    }

    public BlockCommand(Block[] blocks, DatanodeInfo[][] targets) {
        super(DatanodeProtocol.DataNodeAction.DNA_TRANSFER);
        this.blocks = blocks;
        this.targets = targets;
    }

    public BlockCommand(Block[] blocks) {
        super(DatanodeProtocol.DataNodeAction.DNA_INVALIDATE);
        this.blocks = blocks;
        this.targets = new DatanodeInfo[0][];
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public DatanodeInfo[][] getTargets() {
        return this.targets;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeInt(this.blocks.length);
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(out);
        }
        out.writeInt(this.targets.length);
        for (i = 0; i < this.targets.length; ++i) {
            out.writeInt(this.targets[i].length);
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j].write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.blocks = new Block[in.readInt()];
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Block();
            this.blocks[i].readFields(in);
        }
        this.targets = new DatanodeInfo[in.readInt()][];
        for (i = 0; i < this.targets.length; ++i) {
            this.targets[i] = new DatanodeInfo[in.readInt()];
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j] = new DatanodeInfo();
                this.targets[i][j].readFields(in);
            }
        }
    }

    static {
        WritableFactories.setFactory(BlockCommand.class, new WritableFactory(){

            public Writable newInstance() {
                return new BlockCommand();
            }
        });
    }
}

