/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.conf.Configuration");
    private boolean quietmode = true;
    private ArrayList<Object> defaultResources = new ArrayList();
    private ArrayList<Object> finalResources = new ArrayList();
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    private static int MAX_SUBST = 20;

    public Configuration() {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)StringUtils.stringifyException(new IOException("config()")));
        }
        this.defaultResources.add("hadoop-default.xml");
        this.finalResources.add("hadoop-site.xml");
    }

    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)StringUtils.stringifyException(new IOException("config(config)")));
        }
        this.defaultResources = (ArrayList)other.defaultResources.clone();
        this.finalResources = (ArrayList)other.finalResources.clone();
        if (other.properties != null) {
            this.properties = (Properties)other.properties.clone();
        }
        if (other.overlay != null) {
            this.overlay = (Properties)other.overlay.clone();
        }
    }

    public void addDefaultResource(String name) {
        this.addResource(this.defaultResources, name);
    }

    public void addDefaultResource(URL url) {
        this.addResource(this.defaultResources, url);
    }

    public void addDefaultResource(Path file) {
        this.addResource(this.defaultResources, file);
    }

    public void addFinalResource(String name) {
        this.addResource(this.finalResources, name);
    }

    public void addFinalResource(URL url) {
        this.addResource(this.finalResources, url);
    }

    public void addFinalResource(Path file) {
        this.addResource(this.finalResources, file);
    }

    private synchronized void addResource(ArrayList<Object> resources, Object resource) {
        resources.add(resource);
        this.properties = null;
    }

    public Object getObject(String name) {
        return this.getProps().get(name);
    }

    public void setObject(String name, Object value) {
        this.getProps().put(name, value);
    }

    public Object get(String name, Object defaultValue) {
        Object res = this.getObject(name);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            String val = System.getProperty(var = var.substring(2, var.length() - 1));
            if (val == null) {
                val = (String)this.getObject(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        return this.substituteVars(this.getProps().getProperty(name));
    }

    public void set(String name, Object value) {
        this.getOverlay().setProperty(name, value.toString());
        this.getProps().setProperty(name, value.toString());
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.classLoader);
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String propertyName, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(propertyName, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(String propertyName, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(propertyName, theClass.getName());
    }

    public Path getLocalPath(String dirsProp, String path) throws IOException {
        int index;
        int i;
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        LocalFileSystem fs = FileSystem.getLocal(this);
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            Path file = new Path(dirs[index], path);
            Path dir = file.getParent();
            if (!((FileSystem)fs).mkdirs(dir) && !((FileSystem)fs).exists(dir)) continue;
            return file;
        }
        LOG.warn((Object)("Could not make " + path + " in local directories from " + dirsProp));
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            LOG.warn((Object)(dirsProp + "[" + index + "]=" + dirs[index]));
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            Properties newProps = new Properties();
            this.loadResources(newProps, this.defaultResources, false, this.quietmode);
            this.loadResources(newProps, this.finalResources, true, true);
            this.properties = newProps;
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
            }
        }
        return this.properties;
    }

    public Iterator entries() {
        return this.getProps().entrySet().iterator();
    }

    private void loadResources(Properties props, ArrayList resources, boolean reverse, boolean quiet) {
        ListIterator i = resources.listIterator(reverse ? resources.size() : 0);
        while (reverse ? i.hasPrevious() : i.hasNext()) {
            this.loadResource(props, reverse ? i.previous() : i.next(), quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            File file;
            URL url;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof Path && (file = new File(((Path)name).toUri().getPath()).getAbsoluteFile()).exists()) {
                if (!quiet) {
                    LOG.info((Object)("parsing " + file));
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                try {
                    doc = builder.parse(in);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            if (doc == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            Element root = doc.getDocumentElement();
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn((Object)"bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName())) {
                        attr = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"value".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    value = ((Text)field.getFirstChild()).getData();
                }
                if (attr == null || value == null) continue;
                properties.setProperty(attr, value);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
    }

    public void write(OutputStream out) throws IOException {
        Properties properties = this.getProps();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = properties.get(name);
                String value = null;
                if (!(object instanceof String)) continue;
                value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration: ");
        sb.append("defaults: ");
        this.toString(this.defaultResources, sb);
        sb.append("final: ");
        this.toString(this.finalResources, sb);
        return sb.toString();
    }

    private void toString(ArrayList resources, StringBuffer sb) {
        ListIterator i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(" , ");
            }
            sb.append(i.next());
        }
    }

    public void setQuietMode(boolean value) {
        this.quietmode = value;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().write(System.out);
    }
}

