/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.List1DSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryFloatArray;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryList1DSet
implements BinaryObject {
    public static final int computeBytes(float[] list, CoordinateSystem cs, Unit[] units) {
        int unitsLen = BinaryUnit.computeBytes(units);
        return 11 + BinaryFloatArray.computeBytes(list) + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + 1;
    }

    public static final List1DSet read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        MathType mt = (MathType)typeCache.get(typeIndex);
        float[] list = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        boolean reading = true;
        block8: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 4: {
                    list = BinaryFloatArray.read(reader);
                    continue block8;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block8;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block8;
                }
                case 80: {
                    reading = false;
                    continue block8;
                }
            }
            throw new IOException("Unknown List1DSet directive " + directive);
        }
        if (mt == null) {
            throw new IOException("No MathType found for List1DSet");
        }
        if (list == null) {
            throw new IOException("No list found for List1DSet");
        }
        return new List1DSet(list, mt, cs, units);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, CoordinateSystem cs, Unit[] units, List1DSet set, Object token) throws IOException {
        if (!(set.getClass().equals(List1DSet.class) || set instanceof List1DSet && set instanceof Saveable)) {
            return;
        }
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter writer, SetType type, float[] list, CoordinateSystem cs, Unit[] units, List1DSet set, Object token) throws IOException {
        BinaryList1DSet.writeDependentData(writer, type, cs, units, set, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(List1DSet.class) || set instanceof List1DSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        if (list == null) {
            throw new IOException("Null List1DSet list");
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int objLen = BinaryList1DSet.computeBytes(list, cs, units);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(34);
        file.writeInt(typeIndex);
        file.writeByte(4);
        BinaryFloatArray.write(writer, list, token);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        file.writeByte(80);
    }
}

