/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import ucar.grib.GribChecker;
import ucar.grib.GribGridRecord;
import ucar.grib.GribIndexName;
import ucar.grib.GribIndexReader;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.unidata.io.RandomAccessFile;

public class ShowGribIndex {
    private static boolean debugTiming = true;
    private static boolean debugParse = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static String divider = "------------------------------------------------------------------";

    public ShowGribIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final void show(String location) throws IOException {
        try {
            GridIndex index = new GribIndexReader().open(location);
            Map<String, String> attrs = index.getGlobalAttributes();
            System.out.println("index_version = " + attrs.get("index_version"));
            System.out.println("grid_edition = " + attrs.get("grid_edition"));
            System.out.println("location = " + attrs.get("location"));
            System.out.println("length = " + attrs.get("length"));
            System.out.println("created = " + attrs.get("created"));
            System.out.println("center = " + attrs.get("center"));
            System.out.println("sub_center = " + attrs.get("sub_center"));
            System.out.println("table_version = " + attrs.get("table_version"));
            String basetime = attrs.get("basetime");
            System.out.println("basetime = " + basetime);
            System.out.println("ensemble = " + attrs.get("ensemble"));
            System.out.println("-----------------------------------------------------------------");
            List<GridRecord> records = index.getGridRecords();
            for (GridRecord gr : records) {
                GribGridRecord ggr = (GribGridRecord)gr;
            }
            System.out.println("-----------------------------------------------------------------");
            List<GridDefRecord> gdrs = index.getHorizCoordSys();
            for (GridDefRecord gdr : gdrs) {
                System.out.println("GDSkey = " + gdr.getParam("GDSkey"));
                System.out.println("grid_type = " + gdr.getParamInt("grid_type"));
                System.out.println("grid_name = " + gdr.getParam("grid_name"));
                int shape = gdr.getParamInt("grid_shape_code");
                System.out.println("grid_shape_code = " + shape);
                System.out.println("grid_shape = " + gdr.getParam("grid_shape"));
                if (shape < 2 || shape == 6 || shape == 8) {
                    System.out.println("grid_radius_spherical_earth = " + gdr.getParam("grid_radius_spherical_earth"));
                } else if (shape > 1 && shape < 6 || shape == 7) {
                    System.out.println("grid_major_axis_earth = " + gdr.getParam("grid_major_axis_earth"));
                    System.out.println("grid_minor_axis_earth = " + gdr.getParam("grid_minor_axis_earth"));
                }
                System.out.println("Nx = " + gdr.getParam("Nx"));
                System.out.println("Ny = " + gdr.getParam("Ny"));
                System.out.println("La1 = " + gdr.getParam("La1"));
                System.out.println("Lo1 = " + gdr.getParam("Lo1"));
                System.out.println("Dx = " + gdr.getParam("Dx"));
                System.out.println("Dy = " + gdr.getParam("Dy"));
                Set<String> keys = gdr.getKeys();
                ArrayList<String> keylist = new ArrayList<String>(keys);
                Collections.sort(keylist, new CompareKeyAscend());
                for (String key : keylist) {
                    if (key.startsWith("grid") || key.startsWith("Dx") || key.startsWith("Dy") || key.startsWith("La1") || key.startsWith("Lo1") || key.startsWith("GDS") || key.startsWith("Nx") || key.startsWith("Ny")) continue;
                    System.out.println(key + " = " + gdr.getParam(key));
                }
                System.out.println("grid_units = " + gdr.getParam("grid_units"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        File gbx;
        String testName = "C:/data/NDFD.grib2.gbx8";
        debugTiming = false;
        String gbxName = null;
        if (args.length < 1) {
            new ShowGribIndex().show("C:/data/NDFD.grib2.gbx8");
        } else if (args[0].endsWith(".gbx") || args[0].endsWith(".gbx8")) {
            gbx = new File(args[0]);
            if (gbx.exists()) {
                new ShowGribIndex().show(gbx.getPath());
                return;
            }
        } else {
            gbxName = GribIndexName.getCurrentSuffix(args[0]);
            gbx = new File(gbxName);
            if (gbx.exists()) {
                new ShowGribIndex().show(gbx.getPath());
                return;
            }
        }
        String gribName = args[0].replaceAll(".gbx8", "");
        gbxName = GribIndexName.getCurrentSuffix(gribName);
        RandomAccessFile raf = new RandomAccessFile(gribName, "r");
        int edition = GribChecker.getEdition(raf);
        if (edition == 1) {
            Grib1WriteIndex.main(new String[]{gribName, gbxName});
        } else if (edition == 2) {
            Grib2WriteIndex.main(new String[]{gribName, gbxName});
        } else {
            System.out.println("Not a Grib file");
            return;
        }
        new ShowGribIndex().show(gbxName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompareKeyAscend
    implements Comparator<String> {
        protected CompareKeyAscend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

