/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.util.Date;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribPds;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;

public final class GribGridRecord
implements GridRecord {
    private static Logger logger = LoggerFactory.getLogger(GribGridRecord.class);
    int edition;
    int discipline;
    long refTime;
    Date refTimeAsDate;
    int center = -1;
    int subCenter = -1;
    int tableVersion = -1;
    private GribPds pds;
    boolean bmsExists = true;
    int gdsKey;
    long gdsOffset;
    long pdsOffset;
    private String paramDesc;
    private int hashcode = 0;
    private Object belongsTo;

    void setPds(GribPds pds) {
        this.pds = pds;
    }

    public GribPds getPds() {
        return this.pds;
    }

    public int getEdition() {
        return this.edition;
    }

    public int getDiscipline() {
        return this.discipline;
    }

    public int getCenter() {
        return this.center;
    }

    public int getSubCenter() {
        return this.subCenter;
    }

    public int getTableVersion() {
        return this.tableVersion;
    }

    public long getGdsOffset() {
        return this.gdsOffset;
    }

    public long getPdsOffset() {
        return this.pdsOffset;
    }

    public int getGdsKey() {
        return this.gdsKey;
    }

    public boolean isBmsExists() {
        return this.bmsExists;
    }

    public String getGridDefRecordId() {
        return Integer.toString(this.gdsKey);
    }

    public double getLevel1() {
        return this.pds.getLevelValue1();
    }

    public double getLevel2() {
        return this.pds.getLevelValue2();
    }

    public int getLevelType1() {
        return this.pds.getLevelType1();
    }

    public int getLevelType2() {
        return this.pds.getLevelType2();
    }

    public Date getReferenceTime() {
        return this.refTimeAsDate;
    }

    public long getReferenceTimeInMsecs() {
        return this.refTime;
    }

    public Date getValidTime() {
        return this.pds.getForecastDate();
    }

    public int getParameterNumber() {
        return this.pds.getParameterNumber();
    }

    public String getParameterName() {
        return this.getParameterDescription();
    }

    public String getParameterDescription() {
        if (this.paramDesc == null) {
            GridParameter p = this.getParameter();
            this.paramDesc = p.getDescription();
        }
        return this.paramDesc;
    }

    private GridParameter getParameter() {
        GridParameter p = null;
        if (this.edition == 2) {
            Grib2Pds pds2 = (Grib2Pds)this.pds;
            p = ParameterTable.getParameter(this.discipline, pds2.getParameterCategory(), this.pds.getParameterNumber());
        } else {
            GribPDSParamTable pt = null;
            try {
                pt = GribPDSParamTable.getParameterTable(this.center, this.subCenter, this.tableVersion);
            }
            catch (NotSupportedException e) {
                logger.error("Failed to get Parameter name for " + this);
            }
            p = pt.getParameter(this.pds.getParameterNumber());
        }
        return p;
    }

    public int getDecimalScale() {
        if (this.edition == 1) {
            Grib1Pds pds1 = (Grib1Pds)this.pds;
            return pds1.getDecimalScale();
        }
        return -9999;
    }

    public String getTimeUdunitName() {
        if (this.edition == 2) {
            return Grib2Tables.getUdunitTimeUnitFromTable4_4(this.getTimeUnit());
        }
        return Grib1Tables.getTimeUnit(this.getTimeUnit(), true);
    }

    public String getTimeUnitName() {
        if (this.edition == 2) {
            return Grib2Tables.codeTable4_4(this.getTimeUnit());
        }
        return Grib1Tables.getTimeUnit(this.getTimeUnit(), false);
    }

    public int getTimeUnit() {
        return this.pds.getTimeUnit();
    }

    public int cdmVariableHash() {
        if (this.hashcode == 0) {
            int result = 17;
            if (this.edition == 1) {
                result += result * 37 + this.getLevelType1();
                result += result * 37 + this.getParameterName().hashCode();
                String statName = this.getStatisticalProcessTypeNameShort();
                if (statName != null) {
                    result += result * 37 + statName.hashCode();
                }
            } else {
                Grib2Pds pds2 = (Grib2Pds)this.pds;
                int productTemplate = pds2.getProductDefinitionTemplate();
                result += result * 37 + this.discipline;
                result += result * 37 + this.getLevelType1();
                result += result * 37 + pds2.getParameterCategory();
                result += result * 37 + productTemplate;
                String statName = this.getStatisticalProcessTypeNameShort();
                if (statName != null) {
                    result += result * 37 + statName.hashCode();
                }
                result += result * 37 + this.getLevelType2();
                result += result * 37 + pds2.getParameterNumber();
                String useGenType = pds2.getUseGenProcessType();
                if (useGenType != null) {
                    result += result * 37 + useGenType.hashCode();
                }
                if (pds2.isEnsembleDerived()) {
                    Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
                    result += result * 37 + pdsDerived.getDerivedForecastType();
                } else if (pds2.isEnsemble()) {
                    result += result * 37 + 1;
                }
                if (pds2.isProbability()) {
                    Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
                    String name = GribGridRecord.getProbabilityVariableNameSuffix(pdsProb.getProbabilityLowerLimit(), pdsProb.getProbabilityUpperLimit(), pdsProb.getProbabilityType());
                    result += result * 37 + name.hashCode();
                }
            }
            this.hashcode = result;
        }
        return this.hashcode;
    }

    public String cdmVariableName(GridTableLookup lookup, boolean useLevel, boolean useStat) {
        String levelName;
        Grib2Pds pds2;
        String useGenType;
        Formatter f = new Formatter();
        String desc = this.getParameterDescription();
        f.format("%s", desc);
        if (this.edition == 2 && (useGenType = (pds2 = (Grib2Pds)this.pds).getUseGenProcessType()) != null) {
            f.format("_%s", useGenType);
        }
        if (useLevel && (levelName = lookup.getLevelName(this)).length() != 0) {
            boolean hasLayerInName = levelName.indexOf("layer") >= 0;
            boolean isLayer = lookup.isLayer(this);
            if (isLayer && !hasLayerInName) {
                f.format("_%s_layer", levelName);
            } else {
                f.format("_%s", levelName);
            }
        }
        if (useStat) {
            f.format("%s", this.makeSuffix());
        }
        return f.toString();
    }

    public String makeSuffix() {
        Formatter f = new Formatter();
        boolean disambig = false;
        String statName = this.getStatisticalProcessTypeNameShort();
        if (statName != null) {
            f.format("_%s", statName);
            disambig = true;
        }
        if (this.edition == 2) {
            Grib2Pds pds2 = (Grib2Pds)this.pds;
            if (pds2.isEnsembleDerived()) {
                Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
                int type = pdsDerived.getDerivedForecastType();
                f.format("_%s", Grib2Tables.codeTable4_7short(type));
                disambig = true;
            } else if (pds2.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
                String name = GribGridRecord.getProbabilityVariableNameSuffix(pdsProb.getProbabilityLowerLimit(), pdsProb.getProbabilityUpperLimit(), pdsProb.getProbabilityType());
                f.format("_%s", name);
                disambig = true;
            }
        }
        return f.toString();
    }

    public static String getProbabilityVariableNameSuffix(double lowerLimit, double upperLimit, int type) {
        String ll = Double.toString(lowerLimit).replace('.', 'p').replaceFirst("p0$", "");
        String ul = Double.toString(upperLimit).replace('.', 'p').replaceFirst("p0$", "");
        if (type == 0) {
            return "probability_below_" + ll;
        }
        if (type == 1) {
            return "probability_above_" + ul;
        }
        if (type == 2) {
            return "probability_between_" + ll + "_" + ul;
        }
        if (type == 3) {
            return "probability_above_" + ll;
        }
        if (type == 4) {
            return "probability_below_" + ul;
        }
        return "unknownProbability";
    }

    public boolean isInterval() {
        return this.pds.isInterval();
    }

    public int getTimeInterval() {
        if (!this.isInterval()) {
            return -1;
        }
        int[] intv = this.pds.getForecastTimeInterval();
        return intv[1] - intv[0];
    }

    public String getStatisticalProcessTypeName() {
        return Grib2Tables.codeTable4_10(this.getStatisticalProcessType());
    }

    public String getStatisticalProcessTypeNameShort() {
        return Grib2Tables.codeTable4_10short(this.getStatisticalProcessType());
    }

    public int getStatisticalProcessType() {
        return this.pds.getStatisticalProcessType();
    }

    public String toString2() {
        return "GribGridRecord{edition=" + this.edition + ", discipline=" + this.discipline + ", refTime=" + this.refTime + ", center=" + this.center + ", subCenter=" + this.subCenter + ", table=" + this.tableVersion + ", bmsExists=" + this.bmsExists + ", gdsKey=" + this.gdsKey + ", offset1=" + this.gdsOffset + ", offset2=" + this.pdsOffset + ", paramDesc='" + this.getParameterDescription() + '\'' + ", pds=" + this.pds + '}';
    }

    public String toString() {
        return "GribGridRecord{, param=" + this.getParameterDescription() + ", levelType1=" + this.pds.getLevelType1() + ", levelValue1=" + this.pds.getLevelType2() + ", forecastDate=" + this.pds.getForecastDate() + '}';
    }

    public Object getBelongs() {
        return this.belongsTo;
    }

    public void setBelongs(Object gv) {
        this.belongsTo = gv;
    }
}

