/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.test;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import junit.framework.Assert;
import opendap.dap.DAS;
import opendap.dap.DConnect2;
import opendap.dap.DDS;
import opendap.dap.DataDDS;
import opendap.dap.test.Diff;
import opendap.dap.test.TestSources;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

public class TestDConnect2
extends TestSources {
    static boolean debug = false;
    static boolean createbaseline = true;
    final String TITLE = "DAP DConnect2 Tests";
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    String test = null;
    String testname = null;
    String testno = null;
    String ce = null;
    String testdataname = null;
    String url = null;
    boolean pass = false;
    TestSources.TestSet currentTestSet = null;
    TestSources.TestSetEnum[] whichtests = new TestSources.TestSetEnum[]{TestSources.TestSetEnum.Standard1, TestSources.TestSetEnum.Constrained1, TestSources.TestSetEnum.Constrained2};
    final String[] XFAIL = new String[]{"test.01.das", "test.07.das"};

    boolean isxfail(String testname, String extension) {
        for (String s : this.XFAIL) {
            if (!s.endsWith(extension) || !s.startsWith(testname)) continue;
            return true;
        }
        return false;
    }

    public TestDConnect2(String name, String testdir) {
        super(name, testdir);
    }

    public TestDConnect2(String name) {
        this(name, null);
    }

    protected void setUp() {
        this.passcount = 0;
        this.xfailcount = 0;
        this.failcount = 0;
    }

    void test1(String test) throws Exception {
        this.test = test;
        this.testname = test;
        if (this.currentTestSet.constrained) {
            String[] pieces = test.split(";");
            this.testname = pieces[0];
            this.testno = pieces[1];
            this.ce = pieces[2];
            try {
                Integer.decode(this.testno);
            }
            catch (NumberFormatException nfe) {
                System.err.printf("Illegal constrained test testno: %s\n", test);
                return;
            }
        }
        if (this.currentTestSet.constrained) {
            this.testdataname = "ce." + this.testname + "." + this.testno;
            this.url = this.currentTestSet.url + "/" + this.testname;
        } else {
            this.testdataname = this.testname;
            this.url = this.currentTestSet.url + "/" + this.testname;
        }
        if (this.verbose) {
            System.err.println("*** Testing: " + this.testdataname);
        }
        if (this.verbose) {
            System.err.println("*** URL: " + this.url);
        }
        if (!this.currentTestSet.constrained) {
            this.testpart(TestSources.TestPart.DAS);
        }
        if (this.currentTestSet.constrained) {
            this.testpart(TestSources.TestPart.DATADDS);
        }
        Assert.assertTrue((String)this.testname, (boolean)this.pass);
    }

    void testpart(TestSources.TestPart part) {
        ByteArrayOutputStream bytes = null;
        PrintStream output = null;
        bytes = new ByteArrayOutputStream();
        output = new PrintStream(bytes);
        try {
            String testdata;
            DConnect2 dc2 = new DConnect2(this.url);
            switch (part) {
                case DAS: {
                    DAS das = dc2.getDAS();
                    bytes.reset();
                    das.print(output);
                    break;
                }
                case DDS: {
                    DDS dds = dc2.getDDS(this.ce);
                    bytes.reset();
                    dds.print(output);
                    break;
                }
                case DATADDS: {
                    DataDDS datadds = dc2.getData(this.ce);
                    bytes.reset();
                    datadds.print(output);
                    datadds.printVal(output);
                    break;
                }
            }
            String result = new String(bytes.toByteArray());
            if (debug) {
                System.err.println("DEBUG: result: " + this.testname + TestDConnect2.partext(part) + ":");
                System.err.println(result);
            }
            if ((testdata = TestDConnect2.accessTestData(this.testprefix, this.testdataname, part)) == null) {
                System.err.println("No comparison testdata found: " + this.testdataname + TestDConnect2.partext(part));
                System.err.println(result);
                if (createbaseline) {
                    String fname = this.testprefix + "/" + this.testdataname + TestDConnect2.partext(part);
                    System.err.println("Creating: " + fname);
                    FileWriter fw = new FileWriter(fname);
                    fw.write(result);
                    fw.close();
                }
                this.pass = createbaseline;
            } else {
                Diff diff;
                if (debug) {
                    System.err.println("DEBUG: testdata: " + this.testname + "." + part.toString() + ":");
                    System.err.println(testdata);
                }
                boolean bl = this.pass = !(diff = new Diff(this.test)).doDiff(result, testdata);
            }
            if (this.isxfail(this.testname, TestDConnect2.partext(part))) {
                System.err.println("XFail: " + this.test);
                ++this.xfailcount;
                this.pass = true;
            } else if (!this.pass) {
                System.err.println("Fail: " + this.test);
                ++this.failcount;
            } else {
                System.err.println("Pass: " + this.test);
                ++this.passcount;
            }
        }
        catch (Exception hwe) {
            hwe.printStackTrace();
            return;
        }
    }

    public void test() throws Exception {
        System.out.printf("*** Testing %s\n", "DAP DConnect2 Tests");
        System.out.println("    Note: The remote tests may be slow or even fail if the server is overloaded");
        for (TestSources.TestSetEnum e : this.whichtests) {
            this.currentTestSet = (TestSources.TestSet)TestSets.get((Object)e);
            System.out.printf("Base URL: %s\n", this.currentTestSet.url);
            for (String test : this.currentTestSet.tests) {
                this.test1(test);
            }
        }
        int totalcount = this.passcount + this.failcount;
        int okcount = this.passcount;
        System.out.printf("*** PASSED: %d/%d; %d expected failures; %d unexpected failures\n", okcount, totalcount, this.xfailcount, this.failcount);
    }

    public static void main(String[] args) throws Exception {
        Getopts opts = null;
        try {
            opts = new Getopts("d", args);
            if (opts.getSwitch((Character)Character.valueOf((char)'d')).set) {
                debug = true;
            }
        }
        catch (InvalidSwitch is) {
            throw new Exception(is);
        }
        String testdir = null;
        testdir = opts.argList().length > 0 ? opts.argList()[0] : ".";
        new TestDConnect2("TestDConnect2", testdir).test();
    }
}

