/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.Matcher;
import abbot.finder.matchers.ClassMatcher;
import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import abbot.tester.JTextComponentTester;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JFileChooserTester
extends JComponentTester {
    private JTextComponentTester tester = new JTextComponentTester();
    private ComponentFinder finder = BasicFinder.getDefault();
    static /* synthetic */ Class class$javax$swing$JButton;
    static /* synthetic */ Class class$javax$swing$JTextField;

    private Component find(Container chooser, Matcher m) {
        try {
            return this.finder.find(chooser, m);
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    private JButton findButton(Container chooser, final String text) {
        JButton button = (JButton)this.find(chooser, new ClassMatcher(class$javax$swing$JButton == null ? (class$javax$swing$JButton = JFileChooserTester.class$("javax.swing.JButton")) : class$javax$swing$JButton){

            public boolean matches(Component c) {
                return super.matches(c) && text.equals(((JButton)c).getText());
            }
        });
        return button;
    }

    public void actionSetSelectedFile(Component c, final File file) {
        final JFileChooser chooser = (JFileChooser)c;
        int mode = chooser.getFileSelectionMode();
        if (mode == 0 && file.isDirectory()) {
            String msg = Strings.get("tester.JFileChooser.files_only");
            throw new ActionFailedException(msg);
        }
        if (mode == 1 && !file.isDirectory()) {
            String msg = Strings.get("tester.JFileChooser.dirs_only");
            throw new ActionFailedException(msg);
        }
        this.invokeAndWait(new Runnable(){

            public void run() {
                chooser.setSelectedFile(file);
            }
        });
    }

    public void actionSetFilename(Component c, String filename) {
        JTextField tf = (JTextField)this.find((JFileChooser)c, new ClassMatcher(class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = JFileChooserTester.class$("javax.swing.JTextField")) : class$javax$swing$JTextField));
        if (tf == null) {
            String msg = Strings.get("tester.JFileChooser.filename_not_found");
            throw new ActionFailedException(msg);
        }
        this.tester.actionEnterText(tf, filename);
    }

    public void actionSetDirectory(Component c, final String path) {
        final JFileChooser chooser = (JFileChooser)c;
        this.invokeAndWait(new Runnable(){

            public void run() {
                chooser.setCurrentDirectory(new File(path));
            }
        });
        this.waitForIdle();
    }

    public void actionApprove(Component c) {
        JButton approve;
        JFileChooser chooser = (JFileChooser)c;
        String text = chooser.getApproveButtonText();
        if (text == null) {
            text = chooser.getUI().getApproveButtonText(chooser);
        }
        if ((approve = this.findButton(chooser, text)) == null) {
            String msg = Strings.get("tester.JFileChooser.approve_not_found");
            throw new ActionFailedException(msg);
        }
        if (!approve.isEnabled()) {
            String msg = Strings.get("tester.JFileChooser.approve_not_enabled");
            throw new ActionFailedException(msg);
        }
        this.actionClick(approve);
    }

    public void actionCancel(Component c) {
        JFileChooser chooser = (JFileChooser)c;
        JButton cancel = this.findButton(chooser, UIManager.getString("FileChooser.cancelButtonText"));
        if (cancel == null) {
            String msg = Strings.get("tester.JFileChooser.cancel_not_found");
            throw new ActionFailedException(msg);
        }
        if (!cancel.isEnabled()) {
            String msg = Strings.get("tester.JFileChooser.cancel_not_enabled");
            throw new ActionFailedException(msg);
        }
        this.actionClick(cancel);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

