/*
 * Decompiled with CFR 0.152.
 */
package org.chm4j;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.chm4j.ChmFile;

public final class ChmEntry {
    private ChmFile chmFile;
    private long start;
    private long length;
    private int space;
    private int flags;
    private String path;
    private Attribute[] attributes;

    ChmEntry(ChmFile chmFile, long start, long length, int space, int flags, String path) {
        if (chmFile == null) {
            throw new NullPointerException("chm file is null");
        }
        this.chmFile = chmFile;
        this.start = start;
        this.length = length;
        this.space = space;
        this.flags = flags;
        this.path = path;
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute attribute : Attribute.values()) {
            if ((flags & attribute.value) != attribute.value) continue;
            list.add(attribute);
        }
        this.attributes = list.toArray(new Attribute[0]);
    }

    public InputStream getInputStream() throws IOException {
        byte[] data = this.readContent(this.getChmFile().getFile().getCanonicalPath(), this.path);
        return new ByteArrayInputStream(data);
    }

    public ChmFile getChmFile() {
        return this.chmFile;
    }

    public long getLength() {
        return this.length;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasAttribute(Attribute attribute) {
        return (this.flags & attribute.value) == attribute.value;
    }

    public Attribute[] getAttributes() {
        return (Attribute[])this.attributes.clone();
    }

    public ChmEntry[] entries(Attribute ... attributes) throws IOException {
        return this.chmFile.entries(this, attributes);
    }

    public String toString() {
        return this.path;
    }

    private native byte[] readContent(String var1, String var2);

    public static enum Attribute {
        ALL(31),
        DIRECTORY(16),
        FILE(8),
        META(2),
        NORMAL(1),
        SPECIAL(4);

        private int value;

        private Attribute(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

