/*
 * Decompiled with CFR 0.152.
 */
package Common;

public class CRC {
    public static int[] Table = new int[256];
    int _value = -1;

    public void Init() {
        this._value = -1;
    }

    public void UpdateByte(int n) {
        this._value = Table[(this._value ^ n) & 0xFF] ^ this._value >>> 8;
    }

    public void UpdateUInt32(int n) {
        for (int i = 0; i < 4; ++i) {
            this.UpdateByte(n >> 8 * i & 0xFF);
        }
    }

    public void UpdateUInt64(long l) {
        for (int i = 0; i < 8; ++i) {
            this.UpdateByte((int)(l >> 8 * i) & 0xFF);
        }
    }

    public int GetDigest() {
        return ~this._value;
    }

    public void Update(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            this._value = Table[(this._value ^ byArray[i]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public void Update(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this._value = Table[(this._value ^ byArray[i]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public void Update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this._value = Table[(this._value ^ byArray[n + i]) & 0xFF] ^ this._value >>> 8;
        }
    }

    public static int CalculateDigest(byte[] byArray, int n) {
        CRC cRC = new CRC();
        cRC.Update(byArray, n);
        return cRC.GetDigest();
    }

    public static boolean VerifyDigest(int n, byte[] byArray, int n2) {
        return CRC.CalculateDigest(byArray, n2) == n;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            CRC.Table[i] = n;
        }
    }
}

