/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    long shellHandle;
    long tooltipsHandle;
    long tooltipWindow;
    long group;
    long modalGroup;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean showWithParent;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int minWidth;
    int minHeight;
    Control lastActive;
    ToolTip[] toolTips;
    static final int MAXIMUM_TRIM = 128;
    static final int BORDER = 3;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0L, false);
    }

    Shell(Display display, Shell shell, int n, long l, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.center = shell != null && (n & 0x10000000) != 0;
        this.style = Shell.checkStyle(shell, n);
        this.parent = shell;
        this.display = display;
        if (l != 0L) {
            if (bl) {
                this.handle = l;
            } else {
                this.shellHandle = l;
                this.state |= 0x400000;
            }
        }
        this.reskinWidget();
        this.createWidget(0);
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0L, false);
    }

    public static Shell gtk_new(Display display, long l) {
        return new Shell(display, null, 8, l, true);
    }

    public static Shell internal_new(Display display, long l) {
        return new Shell(display, null, 8, l, false);
    }

    static int checkStyle(Shell shell, int n) {
        n = Decorations.checkStyle(n);
        if (((n &= 0xBFFFFFFF) & 0x4000) != 0) {
            n &= 0xFFFFFB1F;
        }
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            n &= 0xEFFFFFFF;
            if (((n |= shell == null ? 1264 : 2144) & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void addToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != null) continue;
            this.toolTips[i] = toolTip;
            return;
        }
        ToolTip[] toolTipArray = new ToolTip[this.toolTips.length + 4];
        toolTipArray[this.toolTips.length] = toolTip;
        System.arraycopy(this.toolTips, 0, toolTipArray, 0, this.toolTips.length);
        this.toolTips = toolTipArray;
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        long l = this.gtk_widget_get_window(this.shellHandle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_window_get_frame_extents(l, gdkRectangle);
        int n3 = Math.max(0, gdkRectangle.width - n);
        int n4 = Math.max(0, gdkRectangle.height - n2);
        if (n3 > 128 || n4 > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((this.style & 8) == 0) {
            bl = (this.style & 0x4E0) != 0;
            bl2 = (this.style & 0x10) != 0;
            boolean bl4 = bl3 = (this.style & 0x800) != 0;
        }
        if (bl) {
            if (bl2) {
                this.display.titleResizeTrimWidth = n3;
                this.display.titleResizeTrimHeight = n4;
                return;
            }
            if (bl3) {
                this.display.titleBorderTrimWidth = n3;
                this.display.titleBorderTrimHeight = n4;
                return;
            }
            this.display.titleTrimWidth = n3;
            this.display.titleTrimHeight = n4;
            return;
        }
        if (bl2) {
            this.display.resizeTrimWidth = n3;
            this.display.resizeTrimHeight = n4;
            return;
        }
        if (bl3) {
            this.display.borderTrimWidth = n3;
            this.display.borderTrimHeight = n4;
            return;
        }
    }

    void bringToTop(boolean bl) {
        if (!this.gtk_widget_get_visible(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell shell = display.activeShell;
        if (shell == this) {
            return;
        }
        if (!bl) {
            long l;
            if (shell == null) {
                return;
            }
            if (!display.activePending && (l = OS.gtk_window_get_focus(shell.shellHandle)) != 0L && !this.gtk_widget_has_focus(l)) {
                return;
            }
        }
        boolean bl2 = false;
        if (shell != null) {
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 8)) {
                bl2 = shell.isUndecorated();
            }
            display.activeShell = null;
            display.activePending = true;
        }
        long l = this.gtk_widget_get_window(this.shellHandle);
        if ((bl2 || (this.style & 0x4000) != 0) && OS.GDK_WINDOWING_X11()) {
            long l2 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_display_get_xdisplay(OS.gdk_window_get_display(l)) : OS.gdk_x11_drawable_get_xdisplay(l);
            long l3 = OS.GTK3 ? OS.gdk_x11_window_get_xid(l) : OS.gdk_x11_drawable_get_xid(l);
            OS.gdk_error_trap_push();
            OS.XSetInputFocus(l2, l3, 2, 0);
            OS.gdk_error_trap_pop();
        } else if (display.windowManager.toLowerCase().equals("metacity")) {
            OS.gdk_window_focus(l, display.lastUserEventTime);
        } else {
            OS.gdk_window_focus(l, 0);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int n = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n2 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = this.parent.getMonitor().getClientArea();
        n = n + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n, rectangle3.x);
        n2 = n2 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n2, rectangle3.y);
        this.setLocation(n, n2);
    }

    void checkBorder() {
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    long childStyle() {
        return 0L;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        if ((this.style & 0xCF8) == 0) {
            n5 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        if (this.isCustomResize()) {
            n5 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        int n6 = this.trimWidth();
        int n7 = this.trimHeight();
        rectangle.x -= n6 / 2 + n5;
        rectangle.y -= n7 - n6 / 2 + n5;
        rectangle.width += n6 + n5 * 2;
        rectangle.height += n7 + n5 * 2;
        if (this.menuBar != null) {
            this.forceResize();
            GtkAllocation gtkAllocation = new GtkAllocation();
            this.gtk_widget_get_allocation(this.menuBar.handle, gtkAllocation);
            int n8 = gtkAllocation.height;
            rectangle.y -= n8;
            rectangle.height += n8;
        }
        return rectangle;
    }

    void createHandle(int n) {
        this.state |= 0xA;
        if (this.shellHandle == 0L) {
            if (this.handle == 0L) {
                int n2 = 0;
                if ((this.style & 0x4000) != 0) {
                    n2 = 1;
                }
                this.shellHandle = OS.gtk_window_new(n2);
            } else {
                this.shellHandle = OS.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0L) {
                this.error(2);
            }
            if (this.parent != null) {
                OS.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                OS.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                if (!this.isUndecorated()) {
                    OS.gtk_window_set_type_hint(this.shellHandle, 1);
                } else {
                    OS.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
                }
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_widget_set_size_request(this.shellHandle, 0, 0);
                OS.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                OS.gtk_window_set_resizable(this.shellHandle, false);
            }
            OS.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0xCF8) == 0) {
                OS.gtk_container_set_border_width(this.shellHandle, 1);
                if (OS.GTK3) {
                    OS.gtk_widget_override_background_color(this.shellHandle, 0, new GdkRGBA());
                } else {
                    GdkColor gdkColor = new GdkColor();
                    OS.gtk_style_get_black(OS.gtk_widget_get_style(this.shellHandle), gdkColor);
                    OS.gtk_widget_modify_bg(this.shellHandle, 0, gdkColor);
                }
            }
            if (this.isCustomResize()) {
                OS.gtk_container_set_border_width(this.shellHandle, 3);
            }
        }
        this.vboxHandle = this.gtk_box_new(1, false, 0);
        if (this.vboxHandle == 0L) {
            this.error(2);
        }
        this.createHandle(n, false, true);
        OS.gtk_container_add(this.vboxHandle, this.scrolledHandle);
        OS.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
        this.group = OS.gtk_window_group_new();
        if (this.group == 0L) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long filterProc(long l, long l2, long l3) {
        int n = OS.X_EVENT_TYPE(l);
        if (n != 10 && n != 9) {
            return 0L;
        }
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, l, (long)XFocusChangeEvent.sizeof);
        switch (n) {
            case 9: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L && OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
                            OS.gtk_tooltips_enable(this.tooltipsHandle);
                        }
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        OS.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
                return 0L;
            }
            case 10: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        if (this.tooltipsHandle != 0L && OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
                            OS.gtk_tooltips_disable(this.tooltipsHandle);
                        }
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell == this) {
                            display.activeShell = null;
                            display.activePending = false;
                        }
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        OS.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
            }
        }
        return 0L;
    }

    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.closures[27], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[59], 0, this.display.closures[59], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[47], 0, this.display.closures[47], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.closures[10], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.closures[11], false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.closures[35], false);
        if (!OS.GTK3) {
            long l = this.gtk_widget_get_window(this.shellHandle);
            OS.gdk_window_add_filter(l, this.display.filterProc, this.shellHandle);
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[21], 0, this.display.closures[21], false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[22], 0, this.display.closures[22], false);
        }
        if (this.isCustomResize()) {
            int n = 13060;
            OS.gtk_widget_add_events(this.shellHandle, n);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[18], 0, this.display.closures[18], false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[29], 0, this.display.closures[29], false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[33], 0, this.display.closures[33], false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[2], 0, this.display.closures[2], false);
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    boolean isCustomResize() {
        return (this.style & 8) == 0 && (this.style & 0x4010) == 16400;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseParent() {
    }

    long topHandle() {
        return this.shellHandle;
    }

    void fixActiveShell() {
        if (this.display.activeShell == this) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shellArray = this.display.getShells();
                for (int i = 0; i < shellArray.length; ++i) {
                    if (shellArray[i] == null || !shellArray[i].isVisible()) continue;
                    shell = shellArray[i];
                    break;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell shell, Control control) {
        String string;
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((string = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(shell, string);
        }
    }

    long fixedSizeAllocateProc(long l, long l2) {
        int n = 0;
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth();
        }
        long l3 = super.fixedSizeAllocateProc(l, l2);
        if ((this.style & 0x8000000) != 0) {
            this.moveChildren(n);
        }
        return l3;
    }

    void fixStyle(long l) {
    }

    void forceResize() {
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        this.forceResize(gtkAllocation.width, gtkAllocation.height);
    }

    void forceResize(int n, int n2) {
        int n3;
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.vboxHandle, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        gtkAllocation.x = n3 = OS.gtk_container_get_border_width(this.shellHandle);
        gtkAllocation.y = n3;
        gtkAllocation.width = n;
        gtkAllocation.height = n2;
        OS.gtk_widget_size_allocate(this.vboxHandle, gtkAllocation);
    }

    public int getAlpha() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_widget_is_composited(this.shellHandle)) {
            return (int)(OS.gtk_window_get_opacity(this.shellHandle) * 255.0);
        }
        return 255;
    }

    int getResizeMode(double d, double d2) {
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = OS.gtk_container_get_border_width(this.shellHandle);
        int n4 = 0;
        if (d2 >= (double)(n2 - n3)) {
            n4 = 16;
            if (d >= (double)(n - n3 - 16)) {
                n4 = 14;
            } else if (d <= (double)(n3 + 16)) {
                n4 = 12;
            }
        } else if (d >= (double)(n - n3)) {
            n4 = 96;
            if (d2 >= (double)(n2 - n3 - 16)) {
                n4 = 14;
            } else if (d2 <= (double)(n3 + 16)) {
                n4 = 136;
            }
        } else if (d2 <= (double)n3) {
            n4 = 138;
            if (d <= (double)(n3 + 16)) {
                n4 = 134;
            } else if (d >= (double)(n - n3 - 16)) {
                n4 = 136;
            }
        } else if (d <= (double)n3) {
            n4 = 70;
            if (d2 <= (double)(n3 + 16)) {
                n4 = 134;
            } else if (d2 >= (double)(n2 - n3 - 16)) {
                n4 = 12;
            }
        }
        return n4;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public Point getLocation() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int n = Math.max(1, this.minWidth + this.trimWidth());
        int n2 = Math.max(1, this.minHeight + this.trimHeight());
        return new Point(n, n2);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell2 = shellArray[n2];
                if (shell2 == null) continue;
                if ((shell2.style & n) != 0) {
                    Composite composite = this;
                    while (composite != null && composite != shell2) {
                        composite = composite.parent;
                    }
                    if (composite == shell2) break;
                    return shell2;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return shell2;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Point getSize() {
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = 0;
        if ((this.style & 0xCF8) == 0) {
            n3 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Point(n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.gtk_widget_get_visible(this.shellHandle);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        int n;
        this.checkWidget();
        int n2 = 0;
        Shell[] shellArray2 = this.display.getShells();
        for (n = 0; n < shellArray2.length; ++n) {
            shellArray = shellArray2[n];
            while ((shellArray = shellArray.getParent()) != null && shellArray != this) {
            }
            if (shellArray != this) continue;
            ++n2;
        }
        n = 0;
        shellArray = new Shell[n2];
        for (int i = 0; i < shellArray2.length; ++i) {
            Composite composite = shellArray2[i];
            while ((composite = composite.getParent()) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray[n++] = shellArray2[i];
        }
        return shellArray;
    }

    long gtk_button_press_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                if ((this.style & 0x4000) != 0 && (this.style & 0x80000) == 0) {
                    this.forceActive();
                }
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button == 1) {
                    this.display.resizeLocationX = gdkEventButton.x_root;
                    this.display.resizeLocationY = gdkEventButton.y_root;
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
                    this.display.resizeBoundsX = nArray[0];
                    this.display.resizeBoundsY = nArray2[0];
                    GtkAllocation gtkAllocation = new GtkAllocation();
                    this.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
                    this.display.resizeBoundsWidth = gtkAllocation.width;
                    this.display.resizeBoundsHeight = gtkAllocation.height;
                }
            }
            return 0L;
        }
        return super.gtk_button_press_event(l, l2);
    }

    long gtk_configure_event(long l, long l2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        if (!this.moved || this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            this.moved = true;
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
            this.sendEvent(10);
        }
        return 0L;
    }

    long gtk_delete_event(long l, long l2) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    long gtk_enter_notify_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_enter_notify_event(l, l2);
        }
        return 0L;
    }

    long gtk_draw(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                long l3 = this.gtk_widget_get_window(l);
                this.gdk_window_get_size(l3, nArray, nArray2);
                int n = OS.gtk_container_get_border_width(l);
                long l4 = OS.gtk_widget_get_style_context(this.shellHandle);
                OS.gtk_style_context_save(l4);
                OS.gtk_render_frame(l4, l2, 0.0, 0.0, nArray[0], n);
                OS.gtk_render_frame(l4, l2, 0.0, nArray2[0] - n, nArray[0], n);
                OS.gtk_render_frame(l4, l2, 0.0, n, n, nArray2[0] - n - n);
                OS.gtk_render_frame(l4, l2, nArray[0] - n, n, n, nArray2[0] - n - n);
                OS.gtk_render_frame(l4, l2, 10.0, 10.0, nArray[0] - 20, nArray2[0] - 20);
                OS.gtk_style_context_restore(l4);
                return 1L;
            }
            return 0L;
        }
        return super.gtk_draw(l, l2);
    }

    long gtk_expose_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
                long l3 = OS.gtk_widget_get_style(l);
                long l4 = this.gtk_widget_get_window(l);
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.gdk_window_get_size(l4, nArray, nArray2);
                GdkRectangle gdkRectangle = new GdkRectangle();
                gdkRectangle.x = gdkEventExpose.area_x;
                gdkRectangle.y = gdkEventExpose.area_y;
                gdkRectangle.width = gdkEventExpose.area_width;
                gdkRectangle.height = gdkEventExpose.area_height;
                byte[] byArray = Converter.wcsToMbcs(null, "base", true);
                int n = OS.gtk_container_get_border_width(l);
                int n2 = this.display.activeShell == this ? 3 : 2;
                OS.gtk_paint_flat_box(l3, l4, n2, 0, gdkRectangle, l, byArray, 0, 0, nArray[0], n);
                OS.gtk_paint_flat_box(l3, l4, n2, 0, gdkRectangle, l, byArray, 0, nArray2[0] - n, nArray[0], n);
                OS.gtk_paint_flat_box(l3, l4, n2, 0, gdkRectangle, l, byArray, 0, n, n, nArray2[0] - n - n);
                OS.gtk_paint_flat_box(l3, l4, n2, 0, gdkRectangle, l, byArray, nArray[0] - n, n, n, nArray2[0] - n - n);
                OS.gtk_paint_box(l3, l4, n2, 2, gdkRectangle, l, byArray, 0, 0, nArray[0], nArray2[0]);
                return 1L;
            }
            return 0L;
        }
        return super.gtk_expose_event(l, l2);
    }

    long gtk_focus(long l, long l2) {
        switch ((int)l2) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0 || control.getShell() != this) break;
                int n = l2 == 0L ? 16 : 8;
                control.traverse(n);
                return 1L;
            }
        }
        return super.gtk_focus(l, l2);
    }

    long gtk_focus_in_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_focus_in_event(l, l2);
        }
        this.display.activeShell = this;
        this.display.activePending = false;
        this.sendEvent(26);
        return 0L;
    }

    long gtk_focus_out_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_focus_out_event(l, l2);
        }
        Display display = this.display;
        this.sendEvent(27);
        this.setActiveControl(null);
        if (display.activeShell == this) {
            display.activeShell = null;
            display.activePending = false;
        }
        return 0L;
    }

    long gtk_leave_notify_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
                OS.memmove(gdkEventCrossing, l2, (long)GdkEventCrossing.sizeof);
                if ((gdkEventCrossing.state & 0x100) == 0) {
                    long l3 = this.gtk_widget_get_window(this.shellHandle);
                    OS.gdk_window_set_cursor(l3, 0L);
                    this.display.resizeMode = 0;
                }
            }
            return 0L;
        }
        return super.gtk_leave_notify_event(l, l2);
    }

    long gtk_move_focus(long l, long l2) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            long l3 = control.focusHandle();
            OS.gtk_widget_child_focus(l3, (int)l2);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1L;
    }

    long gtk_motion_notify_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventMotion gdkEventMotion = new GdkEventMotion();
                OS.memmove(gdkEventMotion, l2, (long)GdkEventMotion.sizeof);
                if ((gdkEventMotion.state & 0x100) != 0) {
                    int n = OS.gtk_container_get_border_width(this.shellHandle);
                    int n2 = (int)(gdkEventMotion.x_root - this.display.resizeLocationX);
                    int n3 = (int)(gdkEventMotion.y_root - this.display.resizeLocationY);
                    int n4 = this.display.resizeBoundsX;
                    int n5 = this.display.resizeBoundsY;
                    int n6 = this.display.resizeBoundsWidth;
                    int n7 = this.display.resizeBoundsHeight;
                    int n8 = Math.max(n6 - n2, Math.max(this.minWidth, n + n));
                    int n9 = Math.max(n7 - n3, Math.max(this.minHeight, n + n));
                    switch (this.display.resizeMode) {
                        case 70: {
                            n4 += n6 - n8;
                            n6 = n8;
                            break;
                        }
                        case 134: {
                            n4 += n6 - n8;
                            n6 = n8;
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 138: {
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 136: {
                            n6 = Math.max(n6 + n2, Math.max(this.minWidth, n + n));
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 96: {
                            n6 = Math.max(n6 + n2, Math.max(this.minWidth, n + n));
                            break;
                        }
                        case 14: {
                            n6 = Math.max(n6 + n2, Math.max(this.minWidth, n + n));
                            n7 = Math.max(n7 + n3, Math.max(this.minHeight, n + n));
                            break;
                        }
                        case 16: {
                            n7 = Math.max(n7 + n3, Math.max(this.minHeight, n + n));
                            break;
                        }
                        case 12: {
                            n4 += n6 - n8;
                            n6 = n8;
                            n7 = Math.max(n7 + n3, Math.max(this.minHeight, n + n));
                        }
                    }
                    if (n4 != this.display.resizeBoundsX || n5 != this.display.resizeBoundsY) {
                        OS.gdk_window_move_resize(this.gtk_widget_get_window(this.shellHandle), n4, n5, n6, n7);
                    } else {
                        OS.gtk_window_resize(this.shellHandle, n6, n7);
                    }
                } else {
                    int n = this.getResizeMode(gdkEventMotion.x, gdkEventMotion.y);
                    if (n != this.display.resizeMode) {
                        long l3 = this.gtk_widget_get_window(this.shellHandle);
                        long l4 = OS.gdk_cursor_new(n);
                        OS.gdk_window_set_cursor(l3, l4);
                        this.gdk_cursor_unref(l4);
                        this.display.resizeMode = n;
                    }
                }
            }
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    long gtk_key_press_event(long l, long l2) {
        if (l == this.shellHandle) {
            Control control;
            if ((this.state & 0x10) != 0) {
                return 1L;
            }
            if (this.menuBar != null && !this.menuBar.isDisposed() && (control = this.display.getFocusControl()) != null && (control.hooks(1) || control.filters(1))) {
                long[] lArray = new long[1];
                long l3 = OS.gtk_settings_get_default();
                OS.g_object_get(l3, OS.gtk_menu_bar_accel, lArray, 0L);
                if (lArray[0] != 0L) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gtk_accelerator_parse(lArray[0], nArray, nArray2);
                    OS.g_free(lArray[0]);
                    if (nArray[0] != 0) {
                        GdkEventKey gdkEventKey = new GdkEventKey();
                        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
                        int n = OS.gtk_accelerator_get_default_mod_mask();
                        if (gdkEventKey.keyval == nArray[0] && (gdkEventKey.state & n) == (nArray2[0] & n)) {
                            return control.gtk_key_press_event(control.focusHandle(), l2);
                        }
                    }
                }
            }
            return 0L;
        }
        return super.gtk_key_press_event(l, l2);
    }

    long gtk_size_allocate(long l, long l2) {
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        if (!this.resized || this.oldWidth != n || this.oldHeight != n2) {
            this.oldWidth = n;
            this.oldHeight = n2;
            this.resizeBounds(n, n2, true);
        }
        return 0L;
    }

    long gtk_realize(long l) {
        long l2 = super.gtk_realize(l);
        long l3 = this.gtk_widget_get_window(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            int n = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    n |= 0x20;
                }
                if ((this.style & 0x400) != 0) {
                    n |= 0x40;
                }
                if ((this.style & 0x10) != 0) {
                    n |= 4;
                }
                if ((this.style & 0x800) != 0) {
                    n |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    n |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    n |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    n |= 2;
                }
            }
            OS.gdk_window_set_decorations(l3, n);
        }
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect(l3, true);
        }
        return l2;
    }

    long gtk_window_state_event(long l, long l2) {
        GdkEventWindowState gdkEventWindowState = new GdkEventWindowState();
        OS.memmove(gdkEventWindowState, l2, (long)GdkEventWindowState.sizeof);
        this.minimized = (gdkEventWindowState.new_window_state & 2) != 0;
        this.maximized = (gdkEventWindowState.new_window_state & 4) != 0;
        boolean bl = this.fullScreen = (gdkEventWindowState.new_window_state & 0x10) != 0;
        if ((gdkEventWindowState.changed_mask & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    void removeTooTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != toolTip) continue;
            this.toolTips[i] = null;
            return;
        }
    }

    void reskinChildren(int n) {
        Widget widget;
        int n2;
        Shell[] shellArray = this.getShells();
        for (n2 = 0; n2 < shellArray.length; ++n2) {
            widget = shellArray[n2];
            if (widget == null) continue;
            widget.reskin(n);
        }
        if (this.toolTips != null) {
            for (n2 = 0; n2 < this.toolTips.length; ++n2) {
                widget = this.toolTips[n2];
                if (widget == null) continue;
                widget.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int n) {
        int n2;
        int n3;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n4 = Math.min(controlArray.length, controlArray2.length);
        for (n3 = 0; n3 < n4 && controlArray[n3] == controlArray2[n3]; ++n3) {
        }
        for (n2 = controlArray2.length - 1; n2 >= n3; --n2) {
            if (controlArray2[n2].isDisposed()) continue;
            controlArray2[n2].sendEvent(27);
        }
        for (n2 = controlArray.length - 1; n2 >= n3; --n2) {
            if (controlArray[n2].isDisposed()) continue;
            Event event = new Event();
            event.detail = n;
            controlArray[n2].sendEvent(26, event);
        }
    }

    public void setAlpha(int n) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_widget_is_composited(this.shellHandle)) {
            OS.gtk_window_set_opacity(this.shellHandle, (float)(n &= 0xFF) / 255.0f);
        }
    }

    void resizeBounds(int n, int n2, boolean bl) {
        if (this.redrawWindow != 0L) {
            OS.gdk_window_resize(this.redrawWindow, n, n2);
        }
        if (this.enableWindow != 0L) {
            OS.gdk_window_resize(this.enableWindow, n, n2);
        }
        int n3 = OS.gtk_container_get_border_width(this.shellHandle);
        int n4 = n - 2 * n3;
        int n5 = n2 - 2 * n3;
        if (!OS.GTK3 || (this.style & 0x10) == 0) {
            OS.gtk_widget_set_size_request(this.vboxHandle, n4, n5);
        }
        this.forceResize(n4, n5);
        if (bl) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (this.getMaximized()) {
            boolean bl4;
            Rectangle rectangle = this.getBounds();
            bl3 = !bl || rectangle.x == n && rectangle.y == n2;
            boolean bl5 = bl4 = !bl2 || rectangle.width == n3 && rectangle.height == n4;
            if (bl3 && bl4) {
                return 0;
            }
            this.setMaximized(false);
        }
        int n5 = 0;
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
            OS.gtk_window_move(this.shellHandle, n, n2);
            if (nArray[0] != n || nArray2[0] != n2) {
                this.moved = true;
                this.oldX = n;
                this.oldY = n2;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                n5 |= 0x80;
            }
        }
        if (bl2) {
            n3 = Math.max(1, Math.max(this.minWidth, n3 - this.trimWidth()));
            n4 = Math.max(1, Math.max(this.minHeight, n4 - this.trimHeight()));
            if ((this.style & 0x10) != 0 || this.minHeight != 0 || this.minWidth != 0) {
                OS.gtk_window_resize(this.shellHandle, n3, n4);
            }
            boolean bl6 = bl3 = n3 != this.oldWidth || n4 != this.oldHeight;
            if (bl3) {
                this.oldWidth = n3;
                this.oldHeight = n4;
                n5 |= 0x100;
            }
            this.resizeBounds(n3, n4, bl3);
        }
        return n5;
    }

    void setCursor(long l) {
        if (this.enableWindow != 0L) {
            OS.gdk_window_set_cursor(this.enableWindow, l);
            if (!OS.GDK_WINDOWING_X11()) {
                OS.gdk_flush();
            } else {
                long l2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                OS.XFlush(l2);
            }
        }
        super.setCursor(l);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean bl2 = false;
        if (!bl && display.focusEvent != 16) {
            control = display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (bl) {
            if (this.enableWindow != 0L) {
                OS.gdk_window_set_user_data(this.enableWindow, 0L);
                OS.gdk_window_destroy(this.enableWindow);
                this.enableWindow = 0L;
            }
        } else {
            long l = this.shellHandle;
            OS.gtk_widget_realize(l);
            long l2 = this.gtk_widget_get_window(l);
            Rectangle rectangle = this.getBounds();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            gdkWindowAttr.width = rectangle.width;
            gdkWindowAttr.height = rectangle.height;
            gdkWindowAttr.event_mask = -32769;
            gdkWindowAttr.wclass = 1;
            gdkWindowAttr.window_type = 2;
            this.enableWindow = OS.gdk_window_new(l2, gdkWindowAttr, 0);
            if (this.enableWindow != 0L) {
                if (this.cursor != null) {
                    OS.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                    if (!OS.GDK_WINDOWING_X11()) {
                        OS.gdk_flush();
                    } else {
                        long l3 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                        OS.XFlush(l3);
                    }
                }
                OS.gdk_window_set_user_data(this.enableWindow, l);
                OS.gdk_window_show(this.enableWindow);
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
        if (bl && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.gtk_window_fullscreen(this.shellHandle);
        } else {
            OS.gtk_window_unfullscreen(this.shellHandle);
            if (this.maximized) {
                this.setMaximized(true);
            }
        }
        this.fullScreen = bl;
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    void setInitialBounds() {
        int n;
        int n2;
        if ((this.state & 0x400000) != 0) {
            GtkAllocation gtkAllocation = new GtkAllocation();
            this.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
            n2 = gtkAllocation.width;
            n = gtkAllocation.height;
        } else {
            n2 = OS.gdk_screen_width() * 5 / 8;
            n = OS.gdk_screen_height() * 5 / 8;
            long l = OS.gdk_screen_get_default();
            if (l != 0L && OS.gdk_screen_get_n_monitors(l) > 1) {
                int n3 = OS.gdk_screen_get_monitor_at_window(l, this.paintWindow());
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gdk_screen_get_monitor_geometry(l, n3, gdkRectangle);
                n2 = gdkRectangle.width * 5 / 8;
                n = gdkRectangle.height * 5 / 8;
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_window_resize(this.shellHandle, n2, n);
            }
        }
        this.resizeBounds(n2, n, false);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        if (bl) {
            OS.gtk_window_maximize(this.shellHandle);
        } else {
            OS.gtk_window_unmaximize(this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        long l;
        boolean bl;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl2 = bl = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            l = this.menuBar.handle;
            OS.gtk_widget_hide(l);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            l = menu.handle;
            OS.gtk_widget_show(l);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        this.resizeBounds(n, n2, !bl);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        super.setMinimized(bl);
        if (bl) {
            OS.gtk_window_iconify(this.shellHandle);
        } else {
            OS.gtk_window_deiconify(this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        GdkGeometry gdkGeometry = new GdkGeometry();
        this.minWidth = gdkGeometry.min_width = Math.max(n, this.trimWidth()) - this.trimWidth();
        this.minHeight = gdkGeometry.min_height = Math.max(n2, this.trimHeight()) - this.trimHeight();
        OS.gtk_window_set_geometry_hints(this.shellHandle, 0L, gdkGeometry, 2);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setModified(boolean bl) {
        this.checkWidget();
        this.modified = bl;
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        super.setRegion(region);
    }

    void setRelations() {
    }

    public void setText(String string) {
        super.setText(string);
        int n = string.length();
        char[] cArray = new char[Math.max(6, n) + 1];
        string.getChars(0, n, cArray, 0);
        for (int i = n; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_window_set_title(this.shellHandle, byArray);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        int n = 229376;
        if ((this.style & n) != 0) {
            if (bl) {
                this.display.setModalShell(this);
                OS.gtk_window_set_modal(this.shellHandle, true);
            } else {
                this.display.clearModal(this);
                OS.gtk_window_set_modal(this.shellHandle, false);
            }
        } else {
            this.updateModal();
        }
        this.showWithParent = bl;
        if (this.gtk_widget_get_mapped(this.shellHandle) == bl) {
            return;
        }
        if (bl) {
            Object object;
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            OS.gtk_widget_show(this.shellHandle);
            if (this.enableWindow != 0L) {
                OS.gdk_window_raise(this.enableWindow);
            }
            if (this.isDisposed()) {
                return;
            }
            if (!OS.GTK_IS_PLUG(this.shellHandle)) {
                this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30, 29, 32};
                object = this.display;
                ((Display)object).putGdkEvents();
                boolean bl2 = false;
                Shell shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    OS.gdk_threads_leave();
                    OS.g_main_context_iteration(0L, false);
                    if (this.isDisposed()) break;
                    boolean bl3 = bl2 = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !bl2);
                ((Display)object).dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!bl2) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            if ((this.style & n) != 0) {
                this.gdk_pointer_ungrab(OS.gtk_widget_get_window(this.shellHandle), 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                object = this.getLocation();
                this.oldX = ((Point)object).x;
                this.oldY = ((Point)object).y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                object = this.getSize();
                this.oldWidth = ((Point)object).x - this.trimWidth();
                this.oldHeight = ((Point)object).y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            OS.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        if (this.mapped) {
            this.setZOrder(control, bl, false, false);
        }
    }

    long shellMapProc(long l, long l2, long l3) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0L;
    }

    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            long l;
            if (OS.gtk_window_is_active(this.shellHandle)) {
                this.display.activeShell = this;
                this.display.activePending = true;
            }
            long l2 = l = OS.gtk_container_get_children(this.shellHandle);
            while (l2 != 0L) {
                OS.gtk_container_remove(this.shellHandle, OS.g_list_data(l2));
                l2 = OS.g_list_next(l2);
            }
            OS.g_list_free(l2);
        }
        OS.gtk_container_add(this.shellHandle, this.vboxHandle);
        if (this.scrolledHandle != 0L) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0L) {
            OS.gtk_widget_show(this.vboxHandle);
        }
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        int n = 16;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_device_position(0L, nArray, nArray2, null);
        nArray2[0] = nArray2[0] + n;
        long l4 = OS.gdk_screen_get_default();
        if (l4 != 0L) {
            int n2 = OS.gdk_screen_get_monitor_at_point(l4, nArray[0], nArray2[0]);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(l4, n2, gdkRectangle);
            GtkAllocation gtkAllocation = new GtkAllocation();
            this.gtk_widget_get_allocation(l, gtkAllocation);
            int n3 = gtkAllocation.width;
            int n4 = gtkAllocation.height;
            if (nArray[0] + n3 > gdkRectangle.x + gdkRectangle.width) {
                nArray[0] = gdkRectangle.x + gdkRectangle.width - n3;
            }
            if (nArray2[0] + n4 > gdkRectangle.y + gdkRectangle.height) {
                nArray2[0] = gdkRectangle.y + gdkRectangle.height - n4;
            }
        }
        OS.gtk_window_move(l, nArray[0], nArray2[0]);
        return 0L;
    }

    long sizeRequestProc(long l, long l2, long l3) {
        OS.gtk_widget_hide(l);
        return 0L;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.titleResizeTrimHeight;
            }
            if (bl3) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (bl2) {
            return this.display.resizeTrimHeight;
        }
        if (bl3) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.titleResizeTrimWidth;
            }
            if (bl3) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (bl2) {
            return this.display.resizeTrimWidth;
        }
        if (bl3) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void updateModal() {
        if (OS.GTK_IS_PLUG(this.shellHandle)) {
            return;
        }
        long l = 0L;
        boolean bl = false;
        if (this.display.getModalDialog() == null) {
            Shell shell = this.getModalShell();
            int n = 229376;
            Composite composite = null;
            if (shell == null) {
                if ((this.style & n) != 0) {
                    composite = this;
                    bl = OS.gtk_window_get_modal(this.shellHandle);
                    if (bl) {
                        OS.gtk_window_set_modal(this.shellHandle, false);
                    }
                }
            } else {
                composite = shell;
            }
            Shell shell2 = composite;
            while (composite != null) {
                if ((composite.style & n) == 0) {
                    l = composite.getShell().group;
                    break;
                }
                shell2 = composite;
                composite = composite.parent;
            }
            if (l == 0L && shell2 != null) {
                l = shell2.getShell().group;
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0) && l == 0L) {
            l = OS.gtk_window_get_group(0L);
        }
        if (l != 0L) {
            OS.gtk_window_group_add_window(l, this.shellHandle);
            if (bl) {
                OS.gtk_window_set_modal(this.shellHandle, true);
            }
        } else if (this.modalGroup != 0L) {
            OS.gtk_window_group_remove_window(this.modalGroup, this.shellHandle);
        }
        this.modalGroup = l;
    }

    void updateMinimized(boolean bl) {
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell;
            boolean bl2 = false;
            for (shell = shellArray[i]; shell != null && shell != this && !shell.isUndecorated(); shell = (Shell)shell.getParent()) {
            }
            if (shell != null && shell != this) {
                bl2 = true;
            }
            if (!bl2) continue;
            if (bl) {
                if (!shellArray[i].isVisible()) continue;
                shellArray[i].showWithParent = true;
                OS.gtk_widget_hide(shellArray[i].shellHandle);
                continue;
            }
            if (!shellArray[i].showWithParent) continue;
            shellArray[i].showWithParent = false;
            OS.gtk_widget_show(shellArray[i].shellHandle);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        OS.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = 0;
        if ((this.style & 0xCF8) == 0) {
            n3 = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Rectangle(nArray[0], nArray2[0], n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0L;
    }

    void releaseChildren(boolean bl) {
        Widget widget;
        int n;
        Shell[] shellArray = this.getShells();
        for (n = 0; n < shellArray.length; ++n) {
            widget = shellArray[n];
            if (widget == null || widget.isDisposed()) continue;
            ((Control)widget).release(false);
        }
        if (this.toolTips != null) {
            for (n = 0; n < this.toolTips.length; ++n) {
                widget = this.toolTips[n];
                if (widget == null || widget.isDisposed()) continue;
                widget.dispose();
            }
            this.toolTips = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.destroyAccelGroup();
        this.display.clearModal(this);
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.group != 0L) {
            OS.g_object_unref(this.group);
        }
        this.modalGroup = 0L;
        this.group = 0L;
        if (!OS.GTK3) {
            long l = this.gtk_widget_get_window(this.shellHandle);
            OS.gdk_window_remove_filter(l, this.display.filterProc, this.shellHandle);
        }
        this.lastActive = null;
    }

    void setToolTipText(long l, String string) {
        this.setToolTipText(l, l, string);
    }

    void setToolTipText(long l, long l2, String string) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            byte[] byArray = null;
            if (string != null && string.length() > 0) {
                char[] cArray = this.fixMnemonic(string, false);
                byArray = Converter.wcsToMbcs(null, cArray, true);
            }
            long l3 = OS.gtk_widget_get_tooltip_text(l);
            boolean bl = false;
            if (byArray == null && l3 == 0L) {
                bl = true;
            } else if (byArray != null && l3 != 0L) {
                boolean bl2 = bl = OS.strcmp(l3, byArray) == 0;
            }
            if (l3 != 0L) {
                OS.g_free(l3);
            }
            if (bl) {
                return;
            }
            long l4 = 0L;
            if (OS.GTK_VERSION < OS.VERSION(2, 18, 0)) {
                OS.gtk_widget_set_tooltip_text(l, null);
                long l5 = this.gtk_widget_get_window(l);
                if (l5 != 0L) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    long l6 = OS.gdk_window_at_pointer(nArray, nArray2);
                    long[] lArray = new long[1];
                    if (l6 != 0L) {
                        OS.gdk_window_get_user_data(l6, lArray);
                    }
                    if (l2 == lArray[0]) {
                        l4 = OS.gdk_event_new(3);
                        GdkEventMotion gdkEventMotion = new GdkEventMotion();
                        gdkEventMotion.type = 3;
                        gdkEventMotion.window = OS.g_object_ref(l5);
                        gdkEventMotion.x = nArray[0];
                        gdkEventMotion.y = nArray2[0];
                        OS.gdk_window_get_origin(l6, nArray, nArray2);
                        gdkEventMotion.x_root = gdkEventMotion.x + (double)nArray[0];
                        gdkEventMotion.y_root = gdkEventMotion.y + (double)nArray2[0];
                        OS.memmove(l4, gdkEventMotion, (long)GdkEventMotion.sizeof);
                        OS.gtk_main_do_event(l4);
                    }
                }
            }
            OS.gtk_widget_set_tooltip_text(l, byArray);
            if (l4 != 0L) {
                OS.gtk_main_do_event(l4);
                OS.gdk_event_free(l4);
            }
        } else {
            int[] nArray;
            int[] nArray3;
            long l7;
            long l8;
            long l9;
            byte[] byArray = null;
            if (string != null && string.length() > 0) {
                char[] cArray = this.fixMnemonic(string, false);
                byArray = Converter.wcsToMbcs(null, cArray, true);
            }
            if ((l9 = OS.gtk_tooltips_data_get(l2)) != 0L) {
                l8 = OS.GTK_TOOLTIPS_GET_TIP_TEXT(l9);
                if (string == null && l8 == 0L) {
                    return;
                }
                if (string != null && l8 != 0L && byArray != null && OS.strcmp(l8, byArray) == 0) {
                    return;
                }
            }
            if (this.tooltipsHandle == 0L) {
                this.tooltipsHandle = OS.gtk_tooltips_new();
                if (this.tooltipsHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.tooltipsHandle);
                this.g_object_ref_sink(this.tooltipsHandle);
            }
            OS.gtk_tooltips_force_window(this.tooltipsHandle);
            l8 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.tooltipsHandle);
            if (l8 != 0L && l8 != this.tooltipWindow) {
                OS.g_signal_connect(l8, OS.size_allocate, this.display.sizeAllocateProc, this.shellHandle);
                this.tooltipWindow = l8;
            }
            boolean bl = true;
            if (l8 != 0L && (this.gtk_widget_get_visible(l2) || this.gtk_widget_get_realized(l2)) && (l7 = OS.gdk_window_at_pointer(nArray3 = new int[1], nArray = new int[1])) != 0L) {
                long[] lArray = new long[1];
                OS.gdk_window_get_user_data(l7, lArray);
                if (l2 == lArray[0]) {
                    bl = false;
                    int n = OS.g_signal_connect(l8, OS.size_request, this.display.sizeRequestProc, this.shellHandle);
                    OS.gtk_tooltips_set_tip(this.tooltipsHandle, l2, byArray, null);
                    OS.gtk_widget_hide(l8);
                    long l10 = OS.gtk_tooltips_data_get(l2);
                    OS.GTK_TOOLTIPS_SET_ACTIVE(this.tooltipsHandle, l10);
                    OS.gtk_tooltips_set_tip(this.tooltipsHandle, l2, byArray, null);
                    if (n != 0) {
                        OS.g_signal_handler_disconnect(l8, n);
                    }
                }
            }
            if (bl) {
                OS.gtk_tooltips_set_tip(this.tooltipsHandle, l2, byArray, null);
            }
        }
    }
}

