/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String JDK16_FRAME = "apple.awt.CEmbeddedFrame";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", classArray);
            if (method != null) {
                method.invoke(clazz, objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        String string;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long l = composite.view.id;
        Class<?> clazz = null;
        try {
            String string2 = string = embeddedFrameClass != null ? embeddedFrameClass : JDK16_FRAME;
            clazz = embeddedFrameClass == null ? Class.forName(string, true, ClassLoader.getSystemClassLoader()) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(JDK17_FRAME);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                SWT.error(20, classNotFoundException2);
            }
        }
        catch (Throwable throwable) {
            SWT.error(1, throwable, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        string = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Long.TYPE);
            string = constructor.newInstance(new Long(l));
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        final Frame frame = (Frame)((Object)string);
        final boolean bl = JDK17_FRAME.equals(frame.getClass().getName());
        frame.addNotify();
        composite.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, listener);
        shell.addListener(19, listener);
        final Display display = composite.getDisplay();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                while (frame.isDisplayable() && !display.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (!display.isDisposed()) {
                    display.removeListener(12, this);
                }
            }
        });
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, listener);
                        shell.removeListener(19, listener);
                        if (bl) {
                            shell.removeListener(26, this);
                            shell.removeListener(27, this);
                        }
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    frame.dispose();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 26: {
                        if (!composite.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                if (frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)frame, new Boolean(true));
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                if (!frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)frame, new Boolean(false));
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(15, listener2);
        if (bl) {
            composite.addListener(16, listener2);
            shell.addListener(26, listener2);
            shell.addListener(27, listener2);
        } else {
            composite.addListener(27, listener2);
        }
        composite.addListener(12, listener2);
        display.asyncExec(new Runnable(){

            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                final Rectangle rectangle = composite.getClientArea();
                if (bl) {
                    try {
                        Method method = frame.getClass().getMethod("validateWithBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        if (method != null) {
                            method.invoke((Object)frame, new Integer(rectangle.x), new Integer(rectangle.y), new Integer(rectangle.width), new Integer(rectangle.height));
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            frame.setSize(rectangle.width, rectangle.height);
                            frame.validate();
                            frame.setVisible(false);
                            frame.setVisible(true);
                        }
                    });
                }
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, l);
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (shell.isDisposed()) {
                            return;
                        }
                        Dimension dimension = canvas.getSize();
                        shell.setSize(dimension.width, dimension.height);
                    }
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                canvas.removeComponentListener(componentAdapter);
            }
        });
        shell.setVisible(true);
        return shell;
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
        System.setProperty("apple.awt.usingSWT", "true");
    }
}

