/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    int layoutText = 0;
    int layoutMessage = 0;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget(0);
        shell.addToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        int n;
        int n2 = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(this.handle);
        int n3 = OS.gdk_screen_get_monitor_at_window(n2, this.gtk_widget_get_window(this.handle));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(n2, n3, gdkRectangle);
        Point point = this.getSize(gdkRectangle.width / 4);
        int n4 = point.x;
        int n5 = point.y;
        point = this.getLocation();
        int n6 = point.x;
        int n7 = point.y;
        OS.gtk_window_resize(this.handle, n4, n5 + 20);
        boolean bl = this.spikeAbove = gdkRectangle.height >= n7 + n5 + 20;
        if (gdkRectangle.width >= n6 + n4) {
            if (gdkRectangle.height >= n7 + n5 + 20) {
                n = 20;
                nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, 16, n, 16, 0, 35, n, n4 - 5, n, n4 - 5, 1 + n, n4 - 3, 1 + n, n4 - 1, 3 + n, n4 - 1, 5 + n, n4, 5 + n, n4, n5 - 5 + n, n4 - 1, n5 - 5 + n, n4 - 1, n5 - 3 + n, n4 - 2, n5 - 3 + n, n4 - 2, n5 - 2 + n, n4 - 3, n5 - 2 + n, n4 - 3, n5 - 1 + n, n4 - 5, n5 - 1 + n, n4 - 5, n5 + n, 5, n5 + n, 5, n5 - 1 + n, 3, n5 - 1 + n, 3, n5 - 2 + n, 2, n5 - 2 + n, 2, n5 - 3 + n, 1, n5 - 3 + n, 1, n5 - 5 + n, 0, n5 - 5 + n, 0, 5 + n};
                this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, 16, n, 16, 1, 35, n, n4 - 6, 0 + n, n4 - 5, 1 + n, n4 - 4, 1 + n, n4 - 2, 3 + n, n4 - 2, 4 + n, n4 - 1, 5 + n, n4 - 1, n5 - 6 + n, n4 - 2, n5 - 5 + n, n4 - 2, n5 - 4 + n, n4 - 4, n5 - 2 + n, n4 - 5, n5 - 2 + n, n4 - 6, n5 - 1 + n, 5, n5 - 1 + n, 4, n5 - 2 + n, 3, n5 - 2 + n, 1, n5 - 4 + n, 1, n5 - 5 + n, 0, n5 - 6 + n, 0, 5 + n};
                if ((this.parent.style & 0x8000000) != 0) {
                    n6 -= n4 - 36;
                    nArray[12] = n4 - 36;
                    nArray[14] = n4 - 16;
                    nArray[16] = n4 - 15;
                    this.borderPolygon[12] = n4 - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = n4 - 16;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n6 - 17), n7);
            } else {
                nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n4 - 5, 0, n4 - 5, 1, n4 - 3, 1, n4 - 1, 3, n4 - 1, 5, n4, 5, n4, n5 - 5, n4 - 1, n5 - 5, n4 - 1, n5 - 3, n4 - 2, n5 - 3, n4 - 2, n5 - 2, n4 - 3, n5 - 2, n4 - 3, n5 - 1, n4 - 5, n5 - 1, n4 - 5, n5, 35, n5, 16, n5 + 20, 16, n5, 5, n5, 5, n5 - 1, 3, n5 - 1, 3, n5 - 2, 2, n5 - 2, 2, n5 - 3, 1, n5 - 3, 1, n5 - 5, 0, n5 - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n4 - 6, 0, n4 - 5, 1, n4 - 4, 1, n4 - 2, 3, n4 - 2, 4, n4 - 1, 5, n4 - 1, n5 - 6, n4 - 2, n5 - 5, n4 - 2, n5 - 4, n4 - 4, n5 - 2, n4 - 5, n5 - 2, n4 - 6, n5 - 1, 35, n5 - 1, 17, n5 + 20 - 2, 17, n5 - 1, 5, n5 - 1, 4, n5 - 2, 3, n5 - 2, 1, n5 - 4, 1, n5 - 5, 0, n5 - 6, 0, 5};
                if ((this.parent.style & 0x8000000) != 0) {
                    n6 -= n4 - 36;
                    nArray[42] = nArray[44] = n4 - 16;
                    nArray[46] = n4 - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = n4 - 17;
                    this.borderPolygon[40] = n4 - 35;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n6 - 17), n7 - n5 - 20);
            }
        } else if (gdkRectangle.height >= n7 + n5 + 20) {
            n = 20;
            nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, n4 - 35, n, n4 - 16, 0, n4 - 16, n, n4 - 5, n, n4 - 5, 1 + n, n4 - 3, 1 + n, n4 - 1, 3 + n, n4 - 1, 5 + n, n4, 5 + n, n4, n5 - 5 + n, n4 - 1, n5 - 5 + n, n4 - 1, n5 - 3 + n, n4 - 2, n5 - 3 + n, n4 - 2, n5 - 2 + n, n4 - 3, n5 - 2 + n, n4 - 3, n5 - 1 + n, n4 - 5, n5 - 1 + n, n4 - 5, n5 + n, 5, n5 + n, 5, n5 - 1 + n, 3, n5 - 1 + n, 3, n5 - 2 + n, 2, n5 - 2 + n, 2, n5 - 3 + n, 1, n5 - 3 + n, 1, n5 - 5 + n, 0, n5 - 5 + n, 0, 5 + n};
            this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, n4 - 35, n, n4 - 17, 2, n4 - 17, n, n4 - 6, n, n4 - 5, 1 + n, n4 - 4, 1 + n, n4 - 2, 3 + n, n4 - 2, 4 + n, n4 - 1, 5 + n, n4 - 1, n5 - 6 + n, n4 - 2, n5 - 5 + n, n4 - 2, n5 - 4 + n, n4 - 4, n5 - 2 + n, n4 - 5, n5 - 2 + n, n4 - 6, n5 - 1 + n, 5, n5 - 1 + n, 4, n5 - 2 + n, 3, n5 - 2 + n, 1, n5 - 4 + n, 1, n5 - 5 + n, 0, n5 - 6 + n, 0, 5 + n};
            if ((this.parent.style & 0x8000000) != 0) {
                n6 += n4 - 35;
                nArray[14] = 16;
                nArray[12] = 16;
                nArray[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n4, n6 - n4 + 17), n7);
        } else {
            nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n4 - 5, 0, n4 - 5, 1, n4 - 3, 1, n4 - 1, 3, n4 - 1, 5, n4, 5, n4, n5 - 5, n4 - 1, n5 - 5, n4 - 1, n5 - 3, n4 - 2, n5 - 3, n4 - 2, n5 - 2, n4 - 3, n5 - 2, n4 - 3, n5 - 1, n4 - 5, n5 - 1, n4 - 5, n5, n4 - 16, n5, n4 - 16, n5 + 20, n4 - 35, n5, 5, n5, 5, n5 - 1, 3, n5 - 1, 3, n5 - 2, 2, n5 - 2, 2, n5 - 3, 1, n5 - 3, 1, n5 - 5, 0, n5 - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n4 - 6, 0, n4 - 5, 1, n4 - 4, 1, n4 - 2, 3, n4 - 2, 4, n4 - 1, 5, n4 - 1, n5 - 6, n4 - 2, n5 - 5, n4 - 2, n5 - 4, n4 - 4, n5 - 2, n4 - 5, n5 - 2, n4 - 6, n5 - 1, n4 - 17, n5 - 1, n4 - 17, n5 + 20 - 2, n4 - 36, n5 - 1, 5, n5 - 1, 4, n5 - 2, 3, n5 - 2, 1, n5 - 4, 1, n5 - 5, 0, n5 - 6, 0, 5};
            if ((this.parent.style & 0x8000000) != 0) {
                n6 += n4 - 35;
                nArray[42] = 35;
                nArray[46] = 16;
                nArray[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n4, n6 - n4 + 17), n7 - n5 - 20);
        }
        OS.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(nArray);
        if (OS.GTK3) {
            OS.gtk_widget_shape_combine_region(this.handle, region.handle);
        } else {
            int n8 = this.gtk_widget_get_window(this.handle);
            OS.gdk_window_shape_combine_region(n8, region.handle, 0, 0);
        }
        region.dispose();
    }

    void createHandle(int n) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            this.handle = OS.gtk_window_new(1);
            Color color = this.display.getSystemColor(29);
            if (OS.GTK3) {
                GdkColor gdkColor = color.handle;
                GdkRGBA gdkRGBA = new GdkRGBA();
                gdkRGBA.alpha = 1.0;
                gdkRGBA.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
                gdkRGBA.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
                gdkRGBA.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
                OS.gtk_widget_override_background_color(this.handle, 0, gdkRGBA);
            } else {
                OS.gtk_widget_modify_bg(this.handle, 0, color.handle);
            }
            OS.gtk_widget_set_app_paintable(this.handle, true);
            OS.gtk_window_set_type_hint(this.handle, 10);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            this.state |= 8;
            this.handle = OS.gtk_tooltips_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_tooltips_force_window(this.handle);
            OS.g_object_ref(this.handle);
            this.g_object_ref_sink(this.handle);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    void deregister() {
        int n;
        super.deregister();
        if ((this.style & 0x1000) == 0 && OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0) {
            this.display.removeWidget(n);
        }
    }

    void destroyWidget() {
        int n = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (n != 0 && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                OS.gtk_widget_destroy(n);
            } else {
                OS.g_object_unref(n);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        Object object;
        int n = this.x;
        int n2 = this.y;
        if (this.item != null) {
            int n3 = this.item.handle;
            if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
                object = new GdkRectangle();
                OS.gtk_status_icon_get_geometry(n3, 0, (GdkRectangle)object, 0);
                n = object.x + object.width / 2;
                n2 = object.y + object.height / 2;
            } else {
                OS.gtk_widget_realize(n3);
                int n4 = this.gtk_widget_get_window(n3);
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gdk_window_get_origin(n4, nArray, nArray2);
                GtkAllocation gtkAllocation = new GtkAllocation();
                this.gtk_widget_get_allocation(n3, gtkAllocation);
                n = nArray[0] + gtkAllocation.width / 2;
                n2 = nArray2[0] + gtkAllocation.height / 2;
            }
        }
        if (n == -1 || n2 == -1) {
            int[] nArray = new int[1];
            object = new int[1];
            this.gdk_window_get_device_position(0, nArray, (int[])object, null);
            n = nArray[0];
            n2 = object[0];
        }
        return new Point(n, n2);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.layoutText != 0) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n2 = nArray[0];
        }
        if (this.layoutMessage != 0) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n3 = nArray[0];
        }
        int n4 = 28;
        boolean bl = this.layoutText != 0 && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != 0) {
            OS.pango_layout_set_width(this.layoutText, (n - n5) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n7 = nArray2[0];
        }
        if (this.layoutMessage != 0) {
            OS.pango_layout_set_width(this.layoutMessage, (n - n4) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n8 = nArray2[0];
        }
        int n9 = 20 + n8;
        if (this.layoutText != 0) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return this.gtk_widget_get_visible(this.handle);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            int n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            return OS.GTK_WIDGET_VISIBLE(n);
        }
        return false;
    }

    int gtk_button_press_event(int n, int n2) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0;
    }

    void drawTooltip(int n) {
        Object object;
        int n2 = this.gtk_widget_get_window(this.handle);
        int n3 = 10;
        int n4 = 10;
        if (OS.USE_CAIRO) {
            int n5;
            int n6;
            int n7;
            int n8 = n7 = n != 0 ? n : OS.gdk_cairo_create(n2);
            if (n7 == 0) {
                this.error(2);
            }
            if ((n6 = this.borderPolygon.length / 2) != 0) {
                Cairo.cairo_set_line_width(n7, 1.0);
                Cairo.cairo_move_to(n7, this.borderPolygon[0], this.borderPolygon[1]);
                int n9 = 1;
                n5 = 2;
                while (n9 < n6) {
                    Cairo.cairo_line_to(n7, (double)this.borderPolygon[n5] + 0.5, (double)this.borderPolygon[n5 + 1] + 0.5);
                    ++n9;
                    n5 += 2;
                }
                Cairo.cairo_close_path(n7);
                Cairo.cairo_stroke(n7);
            }
            if (this.spikeAbove) {
                n4 += 20;
            }
            if (this.layoutText != 0) {
                byte[] byArray = null;
                n5 = this.style & 0xB;
                switch (n5) {
                    case 1: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                        break;
                    }
                    case 2: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                        break;
                    }
                    case 8: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                    }
                }
                if (byArray != null) {
                    int n10;
                    int n11 = OS.gtk_icon_factory_lookup_default(byArray);
                    if (OS.GTK3) {
                        n10 = OS.gtk_icon_set_render_icon_pixbuf(n11, OS.gtk_widget_get_style_context(this.handle), 1);
                    } else {
                        int n12 = OS.gtk_widget_get_default_style();
                        n10 = OS.gtk_icon_set_render_icon(n11, n12, 0, 0, 1, 0, 0);
                    }
                    OS.gdk_cairo_set_source_pixbuf(n7, n10, n3, n4);
                    Cairo.cairo_paint(n7);
                    OS.g_object_unref(n10);
                    n3 += 16;
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                Color color = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(n7, color.handle);
                Cairo.cairo_move_to(n7, n3 += 4, n4);
                OS.pango_cairo_show_layout(n7, this.layoutText);
                OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
                n4 += 10 + Math.max(16, nArray2[0]);
            }
            if (this.layoutMessage != 0) {
                n3 = 14;
                Color color = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(n7, color.handle);
                Cairo.cairo_move_to(n7, n3, n4);
                OS.pango_cairo_show_layout(n7, this.layoutMessage);
            }
            if (n7 != n) {
                Cairo.cairo_destroy(n7);
            }
            return;
        }
        int n13 = OS.gdk_gc_new(n2);
        OS.gdk_draw_polygon(n2, n13, 0, this.borderPolygon, this.borderPolygon.length / 2);
        if (this.spikeAbove) {
            n4 += 20;
        }
        if (this.layoutText != 0) {
            object = null;
            int n14 = this.style & 0xB;
            switch (n14) {
                case 1: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                    break;
                }
                case 2: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                    break;
                }
                case 8: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                }
            }
            if (object != null) {
                int n15 = OS.gtk_widget_get_default_style();
                int n16 = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default((byte[])object), n15, 0, 0, 1, 0, 0);
                OS.gdk_draw_pixbuf(n2, n13, n16, 0, 0, n3, n4, 16, 16, 1, 0, 0);
                OS.g_object_unref(n16);
                n3 += 16;
            }
            Color color = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(n13, color.handle);
            OS.gdk_draw_layout(n2, n13, n3 += 4, n4, this.layoutText);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray3);
            n4 += 10 + Math.max(16, nArray3[0]);
        }
        if (this.layoutMessage != 0) {
            n3 = 14;
            object = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(n13, ((Color)object).handle);
            OS.gdk_draw_layout(n2, n13, n3, n4, this.layoutMessage);
        }
        OS.g_object_unref(n13);
    }

    int gtk_draw(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawTooltip(n2);
        return 0;
    }

    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawTooltip(0);
        return 0;
    }

    int gtk_size_allocate(int n, int n2) {
        Point point = this.getLocation();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(n);
        int n6 = OS.gdk_screen_get_monitor_at_window(n5, this.gtk_widget_get_window(n));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(n5, n6, gdkRectangle);
        GtkAllocation gtkAllocation = new GtkAllocation();
        this.gtk_widget_get_allocation(n, gtkAllocation);
        int n7 = gtkAllocation.width;
        int n8 = gtkAllocation.height;
        if (gdkRectangle.height < n4 + n8) {
            n4 -= n8;
        }
        if (gdkRectangle.width < n3 + n7) {
            n3 -= n7;
        }
        OS.gtk_window_move(n, n3, n4);
        return 0;
    }

    void hookEvents() {
        int n;
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.closures[18], true);
            OS.gtk_widget_add_events(this.handle, 256);
            OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.closures[2], false);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0) {
            OS.g_signal_connect_closure(n, OS.size_allocate, this.display.closures[47], false);
            OS.gtk_widget_add_events(n, 256);
            OS.g_signal_connect_closure(n, OS.button_press_event, this.display.closures[2], false);
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        int n;
        super.register();
        if ((this.style & 0x1000) == 0 && OS.GTK_VERSION < OS.VERSION(2, 12, 0) && (n = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle)) != 0) {
            this.display.addWidget(n, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0;
        if (this.layoutMessage != 0) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        int n3;
        this.checkWidget();
        this.x = n;
        this.y = n2;
        if ((this.style & 0x1000) != 0) {
            if (this.gtk_widget_get_visible(this.handle)) {
                this.configure();
            }
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0) && this.gtk_widget_get_visible(n3 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle))) {
            OS.gtk_window_move(n3, n, n2);
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0;
        if (this.message.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
            this.layoutMessage = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (this.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0;
        if (this.text.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.text, true);
            this.layoutText = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            int n = OS.pango_attr_weight_new(700);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, n, PangoAttribute.sizeof);
            pangoAttribute.start_index = 0;
            pangoAttribute.end_index = byArray.length;
            OS.memmove(n, pangoAttribute, PangoAttribute.sizeof);
            int n2 = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(n2, n);
            OS.pango_layout_set_attributes(this.layoutText, n2);
            OS.pango_attr_list_unref(n2);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (this.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (bl) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                OS.gtk_widget_show(this.handle);
            } else {
                int n = this.parent.vboxHandle;
                StringBuffer stringBuffer = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append(this.message);
                byte[] byArray = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
                if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                    OS.gtk_widget_set_tooltip_text(n, byArray);
                } else {
                    OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
                    int n2 = OS.gtk_tooltips_data_get(n);
                    OS.GTK_TOOLTIPS_SET_ACTIVE(this.handle, n2);
                    OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
                }
            }
            if (this.autohide) {
                this.timerId = OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else {
            int n = this.parent.vboxHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "", true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_widget_set_tooltip_text(n, byArray);
            } else {
                OS.gtk_tooltips_set_tip(this.handle, n, byArray, null);
            }
        }
    }

    int timerProc(int n) {
        if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else if (OS.GTK_VERSION < OS.VERSION(2, 12, 0)) {
            int n2 = OS.GTK_TOOLTIPS_TIP_WINDOW(this.handle);
            OS.gtk_widget_hide(n2);
        }
        return 0;
    }
}

