/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int handle;
    int index;
    byte[] settingsData;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyleBit(shell, n));
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyleBit(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        if ((n & n2) == 0) {
            n |= 0x10000;
        }
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    public PrinterData open() {
        int n;
        byte[] byArray;
        int n2;
        String string;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] byArray2 = Converter.wcsToMbcs(null, this.getText(), true);
        int n3 = this.getParent().handle;
        while (n3 != 0 && !OS.GTK_IS_WINDOW(n3)) {
            n3 = OS.gtk_widget_get_parent(n3);
        }
        this.handle = OS.gtk_print_unix_dialog_new(byArray2, n3);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7);
        int n4 = OS.gtk_print_settings_new();
        int n5 = OS.gtk_page_setup_new();
        if (this.printerData.otherData != null) {
            Printer.restore(this.printerData.otherData, n4, n5);
        }
        if ((string = this.printerData.name) == null && this.printerData.printToFile && (n2 = Printer.gtkPrinterFromPrinterData(this.printerData)) != 0) {
            PrinterData printerData = Printer.printerDataFromGtkPrinter(n2);
            string = printerData.name;
            OS.g_object_unref(n2);
        }
        if (string != null) {
            byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
            OS.gtk_print_settings_set_printer(n4, byArray3);
        }
        switch (this.printerData.scope) {
            case 0: {
                OS.gtk_print_settings_set_print_pages(n4, 0);
                break;
            }
            case 1: {
                OS.gtk_print_settings_set_print_pages(n4, 2);
                int[] nArray = new int[]{this.printerData.startPage - 1, this.printerData.endPage - 1};
                OS.gtk_print_settings_set_page_ranges(n4, nArray, 1);
                break;
            }
            case 2: {
                OS.gtk_print_settings_set_print_pages(n4, 0);
            }
        }
        if ((this.printerData.printToFile || "GtkPrintBackendFile".equals(this.printerData.driver)) && this.printerData.fileName != null && (byArray = Printer.uriFromFilename(this.printerData.fileName)) != null) {
            OS.gtk_print_settings_set(n4, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, byArray);
        }
        OS.gtk_print_settings_set_n_copies(n4, this.printerData.copyCount);
        OS.gtk_print_settings_set_collate(n4, this.printerData.collate);
        byte[] byArray4 = Converter.wcsToMbcs(null, "cups-Duplex", true);
        OS.gtk_print_settings_set(n4, byArray4, null);
        if (this.printerData.duplex != -1) {
            int n6 = this.printerData.duplex == 1 ? 1 : (this.printerData.duplex == 2 ? 2 : 0);
            OS.gtk_print_settings_set_duplex(n4, n6);
        }
        int n7 = this.printerData.orientation == 2 ? 1 : 0;
        OS.gtk_print_settings_set_orientation(n4, n7);
        OS.gtk_page_setup_set_orientation(n5, n7);
        OS.gtk_print_unix_dialog_set_settings(this.handle, n4);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, n5);
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_print_unix_dialog_set_embed_page_setup(this.handle, true);
        }
        OS.g_object_unref(n4);
        OS.g_object_unref(n5);
        int n8 = OS.gtk_window_get_group(0);
        OS.gtk_window_group_add_window(n8, this.handle);
        OS.gtk_window_set_modal(this.handle, true);
        PrinterData printerData = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        int n9 = 0;
        int n10 = 0;
        if ((this.getStyle() & 0x4000000) != 0) {
            n9 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n10 = OS.g_signal_add_emission_hook(n9, 0, ((LONG)display.getData((String)GET_EMISSION_PROC_KEY)).value, this.handle, 0);
        }
        display.setData(ADD_IDLE_PROC_KEY, null);
        Object object = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            object = display.getData(GET_MODAL_DIALOG);
            display.setData(SET_MODAL_DIALOG, this);
        }
        int n11 = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setData(SET_MODAL_DIALOG, object);
        }
        if ((this.getStyle() & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n9, n10);
        }
        if (n11 == -5 && (n = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0) {
            int n12;
            Object[] objectArray;
            int n13;
            n4 = OS.gtk_print_unix_dialog_get_settings(this.handle);
            n5 = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            printerData = Printer.printerDataFromGtkPrinter(n);
            int n14 = OS.gtk_print_settings_get_print_pages(n4);
            switch (n14) {
                case 0: {
                    printerData.scope = 0;
                    break;
                }
                case 2: {
                    printerData.scope = 1;
                    int[] nArray = new int[1];
                    n13 = OS.gtk_print_settings_get_page_ranges(n4, nArray);
                    objectArray = new int[2];
                    n12 = nArray[0];
                    int n15 = Integer.MAX_VALUE;
                    int n16 = 0;
                    for (int i = 0; i < n12; ++i) {
                        OS.memmove(objectArray, n13 + i * objectArray.length * 4, objectArray.length * 4);
                        n15 = Math.min(n15, objectArray[0] + 1);
                        n16 = Math.max(n16, objectArray[1] + 1);
                    }
                    OS.g_free(n13);
                    printerData.startPage = n15 == Integer.MAX_VALUE ? 1 : n15;
                    printerData.endPage = n16 == 0 ? 1 : n16;
                    break;
                }
                case 1: {
                    printerData.scope = 2;
                    printerData.startPage = printerData.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            printerData.printToFile = "GtkPrintBackendFile".equals(printerData.driver);
            if (printerData.printToFile) {
                int n17 = OS.gtk_print_settings_get(n4, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                n13 = OS.strlen(n17);
                objectArray = new byte[n13];
                OS.memmove((byte[])objectArray, n17, n13);
                printerData.fileName = new String(Converter.mbcsToWcs(null, (byte[])objectArray));
            }
            printerData.copyCount = OS.gtk_print_settings_get_n_copies(n4);
            printerData.collate = OS.gtk_print_settings_get_collate(n4);
            int n18 = OS.gtk_print_settings_get_duplex(n4);
            printerData.duplex = n18 == 1 ? 1 : (n18 == 2 ? 2 : 0);
            printerData.orientation = OS.gtk_page_setup_get_orientation(n5) == 1 ? 2 : 1;
            Callback callback = new Callback(this, "GtkPrintSettingsFunc", 3);
            int n19 = callback.getAddress();
            if (n19 == 0) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(n4, n19, 0);
            callback.dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(n5));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(n5, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(n5, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(n5, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(n5, 3));
            n12 = OS.gtk_page_setup_get_paper_size(n5);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(n12));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(n12));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(n12));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(n12, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(n12, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(n12));
            printerData.otherData = this.settingsData;
            OS.g_object_unref(n4);
            this.printerData = printerData;
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return printerData;
    }

    int GtkPrintSettingsFunc(int n, int n2, int n3) {
        int n4 = OS.strlen(n);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n, n4);
        n4 = OS.strlen(n2);
        byte[] byArray2 = new byte[n4];
        OS.memmove(byArray2, n2, n4);
        this.store(byArray, byArray2);
        return 0;
    }

    void store(String string, int n) {
        this.store(string, String.valueOf(n));
    }

    void store(String string, double d) {
        this.store(string, String.valueOf(d));
    }

    void store(String string, boolean bl) {
        this.store(string, String.valueOf(bl));
    }

    void storeBytes(String string, int n) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        this.store(string.getBytes(), byArray);
    }

    void store(String string, String string2) {
        this.store(string.getBytes(), string2.getBytes());
    }

    void store(byte[] byArray, byte[] byArray2) {
        int n = byArray.length + 1 + byArray2.length + 1;
        if (this.index + n + 1 > this.settingsData.length) {
            byte[] byArray3 = new byte[this.settingsData.length + Math.max(n + 1, 1024)];
            System.arraycopy(this.settingsData, 0, byArray3, 0, this.settingsData.length);
            this.settingsData = byArray3;
        }
        System.arraycopy(byArray, 0, this.settingsData, this.index, byArray.length);
        this.index += byArray.length + 1;
        System.arraycopy(byArray2, 0, this.settingsData, this.index, byArray2.length);
        this.index += byArray2.length + 1;
    }
}

