/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_font_extents_t;
import org.eclipse.swt.internal.cairo.cairo_text_extents_t;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.XRenderPictureAttributes;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, n2);
        this.init();
    }

    static void addCairoString(int n, String string, float f, float f2, Font font) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            int n2 = OS.pango_cairo_create_layout(n);
            if (n2 == 0) {
                SWT.error(2);
            }
            OS.pango_layout_set_text(n2, byArray, -1);
            OS.pango_layout_set_font_description(n2, font.handle);
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            Cairo.cairo_get_current_point(n, dArray, dArray2);
            if (dArray[0] != (double)f || dArray2[0] != (double)f2) {
                Cairo.cairo_move_to(n, f, f2);
            }
            OS.pango_cairo_layout_path(n, n2);
            OS.g_object_unref(n2);
        } else {
            GC.setCairoFont(n, font);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n, cairo_font_extents_t2);
            double d = (double)f2 + cairo_font_extents_t2.ascent;
            Cairo.cairo_move_to(n, f, d);
            Cairo.cairo_text_path(n, byArray);
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    public static GC gtk_new(int n, GCData gCData) {
        GC gC = new GC();
        gC.device = gCData.device;
        gC.init(null, gCData, n);
        return gC;
    }

    public static GC gtk_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, n);
        return gC;
    }

    void checkGC(int n) {
        Object object;
        int n2 = this.data.state;
        if ((n2 & n) == n) {
            return;
        }
        n2 = (n2 ^ n) & n;
        this.data.state |= n;
        int n3 = this.data.cairo;
        if (n3 != 0) {
            double[] dArray;
            Object object2;
            Object object3;
            if ((n2 & 3) != 0) {
                if ((n2 & 1) != 0) {
                    object3 = this.data.foreground;
                    object2 = this.data.foregroundPattern;
                    this.data.state &= 0xFFFFFFFD;
                } else {
                    object3 = this.data.background;
                    object2 = this.data.backgroundPattern;
                    this.data.state &= 0xFFFFFFFE;
                }
                if (object2 != null) {
                    if ((this.data.style & 0x8000000) != 0 && ((Pattern)object2).surface != 0) {
                        int n4 = Cairo.cairo_pattern_create_for_surface(((Pattern)object2).surface);
                        if (n4 == 0) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_set_extend(n4, 1);
                        dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                        Cairo.cairo_pattern_set_matrix(n4, dArray);
                        Cairo.cairo_set_source(n3, n4);
                        Cairo.cairo_pattern_destroy(n4);
                    } else {
                        Cairo.cairo_set_source(n3, ((Pattern)object2).handle);
                    }
                } else {
                    Cairo.cairo_set_source_rgba(n3, (float)(((GdkColor)object3).red & 0xFFFF) / 65535.0f, (float)(((GdkColor)object3).green & 0xFFFF) / 65535.0f, (float)(((GdkColor)object3).blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
                }
            }
            if ((n2 & 4) != 0) {
                if (this.data.layout != 0) {
                    object3 = this.data.font;
                    OS.pango_layout_set_font_description(this.data.layout, ((Font)object3).handle);
                }
                if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
                    GC.setCairoFont(n3, this.data.font);
                }
            }
            if ((n2 & 0x10) != 0) {
                int n5 = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        n5 = 1;
                        break;
                    }
                    case 1: {
                        n5 = 0;
                        break;
                    }
                    case 3: {
                        n5 = 2;
                    }
                }
                Cairo.cairo_set_line_cap(n3, n5);
            }
            if ((n2 & 0x20) != 0) {
                int n6 = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        n6 = 0;
                        break;
                    }
                    case 2: {
                        n6 = 1;
                        break;
                    }
                    case 3: {
                        n6 = 2;
                    }
                }
                Cairo.cairo_set_line_join(n3, n6);
            }
            if ((n2 & 0x40) != 0) {
                Cairo.cairo_set_line_width(n3, this.data.lineWidth == 0.0f ? 1.0 : (double)this.data.lineWidth);
                switch (this.data.lineStyle) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 |= 8;
                    }
                }
            }
            if ((n2 & 8) != 0) {
                float f = 0.0f;
                object2 = null;
                float f2 = this.data.lineWidth;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        object2 = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                        break;
                    }
                    case 3: {
                        object2 = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                        break;
                    }
                    case 4: {
                        object2 = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        object2 = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        object2 = this.data.lineDashes;
                    }
                }
                if (object2 != null) {
                    f = this.data.lineDashesOffset;
                    dArray = new double[((Object)object2).length];
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = f2 == 0.0f || this.data.lineStyle == 6 ? (double)object2[i] : (double)(object2[i] * f2);
                    }
                    Cairo.cairo_set_dash(n3, dArray, dArray.length, f);
                } else {
                    Cairo.cairo_set_dash(n3, null, 0, 0.0);
                }
            }
            if ((n2 & 0x80) != 0) {
                Cairo.cairo_set_miter_limit(n3, this.data.lineMiterLimit);
            }
            if ((n2 & 0x200) != 0) {
                double d;
                this.data.cairoYoffset = 0.0;
                this.data.cairoXoffset = 0.0;
                double[] dArray2 = new double[6];
                Cairo.cairo_get_matrix(n3, dArray2);
                object2 = new double[]{1.0};
                double[] dArray3 = new double[]{1.0};
                Cairo.cairo_user_to_device_distance(n3, (double[])object2, dArray3);
                Object object4 = object2[0];
                if (object4 < 0.0) {
                    object4 = -object4;
                }
                if ((d = (double)this.data.lineWidth * object4) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoXoffset = 0.5 / object4;
                }
                if ((object4 = (Object)dArray3[0]) < 0.0) {
                    object4 = -object4;
                }
                if ((d = (double)this.data.lineWidth * object4) == 0.0 || (int)d % 2 == 1) {
                    this.data.cairoYoffset = 0.5 / object4;
                }
            }
            return;
        }
        if ((n2 & 3) != 0) {
            if ((n2 & 1) != 0) {
                object = this.data.foreground;
                this.data.state &= 0xFFFFFFFD;
            } else {
                object = this.data.background;
                this.data.state &= 0xFFFFFFFE;
            }
            OS.gdk_gc_set_foreground(this.handle, (GdkColor)object);
        }
        if ((n2 & 0x100) != 0) {
            object = this.data.background;
            OS.gdk_gc_set_background(this.handle, (GdkColor)object);
        }
        if ((n2 & 4) != 0 && this.data.layout != 0) {
            object = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, ((Font)object).handle);
        }
        if ((n2 & 0x78) != 0) {
            int n7 = 0;
            int n8 = 0;
            int n9 = (int)this.data.lineWidth;
            int n10 = 0;
            float[] fArray = null;
            switch (this.data.lineCap) {
                case 2: {
                    n7 = 2;
                    break;
                }
                case 1: {
                    n7 = 1;
                    break;
                }
                case 3: {
                    n7 = 3;
                }
            }
            switch (this.data.lineJoin) {
                case 2: {
                    n8 = 1;
                    break;
                }
                case 1: {
                    n8 = 0;
                    break;
                }
                case 3: {
                    n8 = 2;
                }
            }
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    fArray = n9 != 0 ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    fArray = n9 != 0 ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    fArray = n9 != 0 ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    fArray = n9 != 0 ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    fArray = this.data.lineDashes;
                }
            }
            if (fArray != null) {
                if ((n2 & 8) != 0) {
                    byte[] byArray = new byte[fArray.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)(n9 == 0 || this.data.lineStyle == 6 ? fArray[i] : fArray[i] * (float)n9);
                    }
                    OS.gdk_gc_set_dashes(this.handle, 0, byArray, byArray.length);
                }
                n10 = 1;
            } else {
                n10 = 0;
            }
            OS.gdk_gc_set_line_attributes(this.handle, n9, n10, n7, n8);
        }
    }

    int convertRgn(int n, double[] dArray) {
        int n2 = OS.gdk_region_new();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Region.gdk_region_get_rectangles(n, nArray2, nArray);
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray3 = new int[8];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        for (int i = 0; i < nArray[0]; ++i) {
            OS.memmove(gdkRectangle, nArray2[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
            dArray2[0] = gdkRectangle.x;
            dArray3[0] = gdkRectangle.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray3[0] = (int)dArray2[0];
            nArray3[1] = (int)dArray3[0];
            dArray2[0] = gdkRectangle.x + gdkRectangle.width;
            dArray3[0] = gdkRectangle.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray3[2] = (int)Math.round(dArray2[0]);
            nArray3[3] = (int)dArray3[0];
            dArray2[0] = gdkRectangle.x + gdkRectangle.width;
            dArray3[0] = gdkRectangle.y + gdkRectangle.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray3[4] = (int)Math.round(dArray2[0]);
            nArray3[5] = (int)Math.round(dArray3[0]);
            dArray2[0] = gdkRectangle.x;
            dArray3[0] = gdkRectangle.y + gdkRectangle.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray3[6] = (int)dArray2[0];
            nArray3[7] = (int)Math.round(dArray3[0]);
            int n3 = Region.gdk_region_polygon(nArray3, nArray3.length / 2, 0);
            OS.gdk_region_union(n2, n3);
            OS.gdk_region_destroy(n3);
        }
        if (nArray2[0] != 0) {
            OS.g_free(nArray2[0]);
        }
        return n2;
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (OS.USE_CAIRO) {
            int n3 = Cairo.cairo_create(image.surface);
            if (n3 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_translate(n3, -n, -n2);
            Cairo.cairo_push_group(n3);
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(n3, this.data.image.surface, 0.0, 0.0);
            } else if (this.data.drawable != 0) {
                if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_cairo_set_source_window(n3, this.data.drawable, 0, 0);
                } else {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gdk_drawable_get_size(this.data.drawable, nArray, nArray2);
                    int n4 = nArray[0];
                    int n5 = nArray2[0];
                    int n6 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                    int n7 = OS.gdk_x11_drawable_get_xid(this.data.drawable);
                    int n8 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
                    int n9 = Cairo.cairo_xlib_surface_create(n6, n7, n8, n4, n5);
                    Cairo.cairo_set_source_surface(n3, n9, 0.0, 0.0);
                }
            } else {
                Cairo.cairo_destroy(n3);
                return;
            }
            Cairo.cairo_set_operator(n3, 1);
            Cairo.cairo_paint(n3);
            Cairo.cairo_pop_group_to_source(n3);
            Cairo.cairo_paint(n3);
            Cairo.cairo_destroy(n3);
            return;
        }
        Rectangle rectangle = image.getBounds();
        int n10 = OS.gdk_gc_new(image.pixmap);
        if (n10 == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow(n10, 1);
        OS.gdk_draw_drawable(image.pixmap, n10, this.data.drawable, n, n2, 0, 0, rectangle.width, rectangle.height);
        OS.g_object_unref(n10);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        GdkRectangle gdkRectangle;
        int n8;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n9 = n5 - n;
        int n10 = n6 - n2;
        if (n9 == 0 && n10 == 0) {
            return;
        }
        int n11 = this.data.drawable;
        if (OS.USE_CAIRO) {
            if (this.data.image != null) {
                Cairo.cairo_set_source_surface(this.handle, this.data.image.surface, n9, n10);
                Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_fill(this.handle);
            } else if (n11 != 0) {
                Cairo.cairo_save(this.handle);
                Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_translate(this.handle, n9, n10);
                Cairo.cairo_set_operator(this.handle, 1);
                Cairo.cairo_push_group(this.handle);
                OS.gdk_cairo_set_source_window(this.handle, n11, 0, 0);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_pop_group_to_source(this.handle);
                Cairo.cairo_rectangle(this.handle, n5 - n9, n6 - n10, n3, n4);
                Cairo.cairo_clip(this.handle);
                Cairo.cairo_paint(this.handle);
                Cairo.cairo_restore(this.handle);
                if (bl) {
                    n8 = OS.GTK3 ? OS.gdk_window_get_visible_region(n11) : OS.gdk_drawable_get_visible_region(n11);
                    gdkRectangle = new GdkRectangle();
                    gdkRectangle.x = n;
                    gdkRectangle.y = n2;
                    gdkRectangle.width = n3;
                    gdkRectangle.height = n4;
                    n7 = OS.gdk_region_rectangle(gdkRectangle);
                    OS.gdk_region_intersect(n7, n8);
                    int n12 = OS.gdk_region_rectangle(gdkRectangle);
                    OS.gdk_region_subtract(n12, n8);
                    OS.gdk_region_offset(n12, n9, n10);
                    OS.gdk_window_invalidate_region(n11, n12, false);
                    OS.gdk_region_destroy(n8);
                    OS.gdk_region_destroy(n7);
                    OS.gdk_region_destroy(n12);
                }
            }
        } else {
            if (this.data.image == null && bl) {
                OS.gdk_gc_set_exposures(this.handle, true);
            }
            OS.gdk_draw_drawable(n11, this.handle, n11, n, n2, n5, n6, n3, n4);
        }
        if (this.data.image == null & bl) {
            if (!OS.USE_CAIRO) {
                OS.gdk_gc_set_exposures(this.handle, false);
            }
            n8 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6 ? 1 : 0;
            gdkRectangle = new GdkRectangle();
            if (n8 != 0) {
                gdkRectangle.x = n;
                gdkRectangle.y = n2;
                gdkRectangle.width = n3;
                gdkRectangle.height = n4;
                OS.gdk_window_invalidate_rect(n11, gdkRectangle, false);
            } else {
                if (n9 != 0) {
                    n7 = n5 - n9;
                    if (n9 < 0) {
                        n7 = n5 + n3;
                    }
                    gdkRectangle.x = n7;
                    gdkRectangle.y = n2;
                    gdkRectangle.width = Math.abs(n9);
                    gdkRectangle.height = n4;
                    OS.gdk_window_invalidate_rect(n11, gdkRectangle, false);
                }
                if (n10 != 0) {
                    n7 = n6 - n10;
                    if (n10 < 0) {
                        n7 = n6 + n4;
                    }
                    gdkRectangle.x = n;
                    gdkRectangle.y = n7;
                    gdkRectangle.width = n3;
                    gdkRectangle.height = Math.abs(n10);
                    OS.gdk_window_invalidate_rect(n11, gdkRectangle, false);
                }
            }
        }
    }

    void createLayout() {
        int n = OS.gdk_pango_context_get();
        if (n == 0) {
            SWT.error(2);
        }
        this.data.context = n;
        int n2 = OS.pango_layout_new(n);
        if (n2 == 0) {
            SWT.error(2);
        }
        this.data.layout = n2;
        OS.pango_context_set_language(n, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(n, (this.data.style & 0x8000000) != 0 ? 1 : 0);
        OS.pango_layout_set_auto_dir(n2, false);
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0;
        this.data.layout = 0;
    }

    void destroy() {
        Image image;
        int n;
        if (this.data.disposeCairo && (n = this.data.cairo) != 0) {
            Cairo.cairo_destroy(n);
        }
        this.data.cairo = 0;
        n = this.data.clipRgn;
        if (n != 0) {
            OS.gdk_region_destroy(n);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0;
        this.data.drawable = 0;
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.cairo;
        if (n7 != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
            } else {
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(n7, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_stroke(n7);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n5 = this.data.cairo) != 0) {
            this.checkGC(1);
            if (OS.GTK3) {
                int n6 = OS.gtk_widget_get_style_context(this.data.device.shellHandle);
                OS.gtk_render_focus(n6, n5, n, n2, n3, n4);
            } else {
                double d;
                int[] nArray = new int[1];
                OS.gtk_widget_style_get(this.data.device.shellHandle, OS.focus_line_width, nArray, 0);
                Cairo.cairo_save(n5);
                Cairo.cairo_set_line_width(n5, nArray[0]);
                double[] dArray = new double[]{1.0, 1.0};
                for (d = (double)((float)(-nArray[0]) / 2.0f); d < 0.0; d += 2.0) {
                }
                Cairo.cairo_set_dash(n5, dArray, dArray.length, d);
                Cairo.cairo_rectangle(n5, (float)n + (float)nArray[0] / 2.0f, (float)n2 + (float)nArray[0] / 2.0f, n3, n4);
                Cairo.cairo_stroke(n5);
                Cairo.cairo_restore(n5);
            }
            return;
        }
        int n7 = OS.gtk_widget_get_style(this.data.device.shellHandle);
        OS.gtk_paint_focus(n7, this.data.drawable, 0, null, this.data.device.shellHandle, new byte[1], n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        if (OS.USE_CAIRO) {
            n10 = image.width;
            n9 = image.height;
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                OS.gdk_pixmap_get_size(image.pixmap, nArray, nArray2);
            } else {
                OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
            }
            n10 = nArray[0];
            n9 = nArray2[0];
        }
        if (bl) {
            n3 = n7 = n10;
            n4 = n8 = n9;
        } else {
            boolean bl2 = bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n10 && n4 == n8 && n8 == n9;
            if (n + n3 > n10 || n2 + n4 > n9) {
                SWT.error(5);
            }
        }
        int n11 = this.data.cairo;
        if (n11 != 0) {
            if (this.data.alpha != 0) {
                image.createSurface();
                Cairo.cairo_save(n11);
                if ((this.data.style & 0x8000000) != 0) {
                    Cairo.cairo_scale(n11, -1.0, 1.0);
                    Cairo.cairo_translate(n11, -2 * n5 - n7, 0.0);
                }
                Cairo.cairo_rectangle(n11, n5, n6, n7, n8);
                Cairo.cairo_clip(n11);
                Cairo.cairo_translate(n11, n5 - n, n6 - n2);
                if (n3 != n7 || n4 != n8) {
                    Cairo.cairo_scale(n11, (float)n7 / (float)n3, (float)n8 / (float)n4);
                }
                int n12 = 1;
                switch (this.data.interpolation) {
                    case -1: {
                        n12 = 1;
                        break;
                    }
                    case 0: {
                        n12 = 3;
                        break;
                    }
                    case 1: {
                        n12 = 0;
                        break;
                    }
                    case 2: {
                        n12 = 2;
                    }
                }
                int n13 = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (n13 == 0) {
                    SWT.error(2);
                }
                if (n3 != n7 || n4 != n8) {
                    int n14 = Cairo.cairo_version();
                    if (n14 >= Cairo.CAIRO_VERSION_ENCODE(1, 4, 0) && n14 < Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        int n15 = Cairo.cairo_image_surface_create(0, n10 * 3, n9 * 3);
                        int n16 = Cairo.cairo_create(n15);
                        Cairo.cairo_set_source_surface(n16, image.surface, n10, n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_scale(n16, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10, -n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10 * 3, -n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10, -n9 * 3);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10 * 3, -n9 * 3);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_scale(n16, 1.0, -1.0);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10, n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_set_source_surface(n16, image.surface, -n10 * 3, n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_scale(n16, -1.0, -1.0);
                        Cairo.cairo_set_source_surface(n16, image.surface, n10, -n9);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_set_source_surface(n16, image.surface, n10, -n9 * 3);
                        Cairo.cairo_paint(n16);
                        Cairo.cairo_destroy(n16);
                        int n17 = Cairo.cairo_pattern_create_for_surface(n15);
                        Cairo.cairo_surface_destroy(n15);
                        if (n17 == 0) {
                            SWT.error(2);
                        }
                        Cairo.cairo_pattern_destroy(n13);
                        n13 = n17;
                        Cairo.cairo_pattern_set_extend(n13, 3);
                        double[] dArray = new double[6];
                        Cairo.cairo_matrix_init_translate(dArray, n10, n9);
                        Cairo.cairo_pattern_set_matrix(n13, dArray);
                    } else if (n14 >= Cairo.CAIRO_VERSION_ENCODE(1, 8, 0)) {
                        Cairo.cairo_pattern_set_extend(n13, 3);
                    }
                }
                Cairo.cairo_pattern_set_filter(n13, n12);
                Cairo.cairo_set_source(n11, n13);
                if (this.data.alpha != 255) {
                    Cairo.cairo_paint_with_alpha(n11, (float)this.data.alpha / 255.0f);
                } else {
                    Cairo.cairo_paint(n11);
                }
                Cairo.cairo_restore(n11);
                Cairo.cairo_pattern_destroy(n13);
            }
            return;
        }
        if (image.alpha != -1 || image.alphaData != null) {
            this.drawImageAlpha(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        } else if (image.transparentPixel != -1 || image.mask != 0) {
            this.drawImageMask(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        } else {
            this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n10, n9);
        }
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        if (n3 == n7 && n4 == n8) {
            OS.gdk_draw_drawable(this.data.drawable, this.handle, image.pixmap, n, n2, n5, n6, n7, n8);
        } else {
            if (this.device.useXRender) {
                this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, 0, -1);
                return;
            }
            int n11 = this.scale(image.pixmap, n, n2, n3, n4, n7, n8);
            if (n11 != 0) {
                OS.gdk_pixbuf_render_to_drawable(n11, this.data.drawable, this.handle, 0, 0, n5, n6, n7, n8, 1, 0, 0);
                OS.g_object_unref(n11);
            }
        }
    }

    void drawImageAlpha(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        int n11;
        if (image.alpha == 0) {
            return;
        }
        if (image.alpha == 255) {
            this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10);
            return;
        }
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, image.mask, 2);
            return;
        }
        int n12 = OS.gdk_pixbuf_new(0, true, 8, n3, n4);
        if (n12 == 0) {
            return;
        }
        int n13 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n12, image.pixmap, n13, n, n2, 0, 0, n3, n4);
        int n14 = OS.gdk_pixbuf_get_rowstride(n12);
        int n15 = OS.gdk_pixbuf_get_pixels(n12);
        byte[] byArray = new byte[n14];
        byte by = (byte)image.alpha;
        byte[] byArray2 = image.alphaData;
        for (n11 = 0; n11 < n4; ++n11) {
            int n16 = (n11 + n2) * n9 + n;
            OS.memmove(byArray, n15 + n11 * n14, n14);
            for (int i = 3; i < n14; i += 4) {
                byArray[i] = byArray2 == null ? by : byArray2[n16++];
            }
            OS.memmove(n15 + n11 * n14, byArray, n14);
        }
        if (n3 != n7 || n4 != n8) {
            n11 = OS.gdk_pixbuf_scale_simple(n12, n7, n8, 2);
            OS.g_object_unref(n12);
            if (n11 == 0) {
                return;
            }
            n12 = n11;
        }
        OS.gdk_draw_pixbuf(this.data.drawable, this.handle, n12, 0, 0, n5, n6, n7, n8, 1, 0, 0);
        OS.g_object_unref(n12);
    }

    void drawImageMask(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10) {
        int n11 = this.data.drawable;
        int n12 = image.pixmap;
        if (image.transparentPixel != -1) {
            image.createMask();
        }
        int n13 = image.mask;
        if (this.device.useXRender) {
            this.drawImageXRender(image, n, n2, n3, n4, n5, n6, n7, n8, bl, n9, n10, n13, 4);
        } else {
            byte[] byArray;
            int n14;
            int n15;
            int n16;
            int n17;
            if (n3 != n7 || n4 != n8) {
                n17 = OS.gdk_pixbuf_new(0, true, 8, n3, n4);
                if (n17 != 0) {
                    n16 = OS.gdk_colormap_get_system();
                    OS.gdk_pixbuf_get_from_drawable(n17, n12, n16, n, n2, 0, 0, n3, n4);
                    n15 = OS.gdk_pixbuf_new(0, false, 8, n3, n4);
                    if (n15 != 0) {
                        int n18;
                        OS.gdk_pixbuf_get_from_drawable(n15, n13, 0, n, n2, 0, 0, n3, n4);
                        int n19 = OS.gdk_pixbuf_get_rowstride(n17);
                        n14 = OS.gdk_pixbuf_get_pixels(n17);
                        byte[] byArray2 = new byte[n19];
                        int n20 = OS.gdk_pixbuf_get_rowstride(n15);
                        int n21 = OS.gdk_pixbuf_get_pixels(n15);
                        byte[] byArray3 = new byte[n20];
                        for (n18 = 0; n18 < n4; ++n18) {
                            int n22 = n14 + n18 * n19;
                            OS.memmove(byArray2, n22, n19);
                            int n23 = n21 + n18 * n20;
                            OS.memmove(byArray3, n23, n20);
                            for (int i = 0; i < n3; ++i) {
                                if (byArray3[i * 3] != 0) continue;
                                byArray2[i * 4 + 3] = 0;
                            }
                            OS.memmove(n22, byArray2, n19);
                        }
                        OS.g_object_unref(n15);
                        n18 = OS.gdk_pixbuf_scale_simple(n17, n7, n8, 2);
                        if (n18 != 0) {
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            OS.gdk_pixbuf_render_pixmap_and_mask(n18, nArray, nArray2, 128);
                            n12 = nArray[0];
                            n13 = nArray2[0];
                            OS.g_object_unref(n18);
                        }
                    }
                    OS.g_object_unref(n17);
                }
                n = 0;
                n2 = 0;
                n3 = n7;
                n4 = n8;
            }
            if (this.data.clipRgn != 0 && (n14 = OS.gdk_bitmap_create_from_data(0, byArray = new byte[(n15 = ((n17 = n + n3) + 7) / 8) * (n16 = n2 + n4)], n17, n16)) != 0) {
                int n24 = OS.gdk_gc_new(n14);
                OS.gdk_region_offset(this.data.clipRgn, -n5 + n, -n6 + n2);
                OS.gdk_gc_set_clip_region(n24, this.data.clipRgn);
                OS.gdk_region_offset(this.data.clipRgn, n5 - n, n6 - n2);
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = 1;
                OS.gdk_gc_set_foreground(n24, gdkColor);
                OS.gdk_draw_rectangle(n14, n24, 1, 0, 0, n17, n16);
                OS.gdk_gc_set_function(n24, 4);
                OS.gdk_draw_drawable(n14, n24, n13, 0, 0, 0, 0, n17, n16);
                OS.g_object_unref(n24);
                if (n13 != 0 && image.mask != n13) {
                    OS.g_object_unref(n13);
                }
                n13 = n14;
            }
            GdkGCValues gdkGCValues = new GdkGCValues();
            OS.gdk_gc_get_values(this.handle, gdkGCValues);
            OS.gdk_gc_set_clip_mask(this.handle, n13);
            OS.gdk_gc_set_clip_origin(this.handle, n5 - n, n6 - n2);
            OS.gdk_draw_drawable(n11, this.handle, n12, n, n2, n5, n6, n3, n4);
            OS.gdk_gc_set_values(this.handle, gdkGCValues, 6272);
            if (this.data.clipRgn != 0) {
                OS.gdk_gc_set_clip_region(this.handle, this.data.clipRgn);
            }
        }
        if (n12 != 0 && image.pixmap != n12) {
            OS.g_object_unref(n12);
        }
        if (n13 != 0 && image.mask != n13) {
            OS.g_object_unref(n13);
        }
        if (image.transparentPixel != -1 && image.memGC != null) {
            image.destroyMask();
        }
    }

    void drawImageXRender(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, int n10, int n11, int n12) {
        int n13;
        int n14 = 0;
        int n15 = 0;
        int n16 = this.data.drawable;
        if (this.data.image == null && !this.data.realDrawable) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gdk_window_get_internal_paint_info(n16, nArray3, nArray, nArray2);
            n16 = nArray3[0];
            n14 = -nArray[0];
            n15 = -nArray2[0];
        }
        int n17 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        int n18 = 0;
        if (n11 != 0) {
            int n19 = 0;
            XRenderPictureAttributes xRenderPictureAttributes = null;
            if (image.alpha != -1) {
                n19 = 1;
                xRenderPictureAttributes = new XRenderPictureAttributes();
                xRenderPictureAttributes.repeat = true;
            }
            if ((n18 = OS.XRenderCreatePicture(n17, OS.gdk_x11_drawable_get_xid(n11), OS.XRenderFindStandardFormat(n17, n12), n19, xRenderPictureAttributes)) == 0) {
                SWT.error(2);
            }
        }
        int n20 = OS.XRenderFindVisualFormat(n17, OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()));
        int n21 = OS.XRenderCreatePicture(n17, OS.gdk_x11_drawable_get_xid(n16), n20, 0, null);
        if (n21 == 0) {
            SWT.error(2);
        }
        if ((n13 = OS.XRenderCreatePicture(n17, OS.gdk_x11_drawable_get_xid(image.pixmap), n20, 0, null)) == 0) {
            SWT.error(2);
        }
        if (n3 != n7 || n4 != n8) {
            int[] nArray = new int[]{(int)((float)n3 / (float)n7 * 65536.0f), 0, 0, 0, (int)((float)n4 / (float)n8 * 65536.0f), 0, 0, 0, 65536};
            OS.XRenderSetPictureTransform(n17, n13, nArray);
            if (n18 != 0) {
                OS.XRenderSetPictureTransform(n17, n18, nArray);
            }
            n = (int)((float)n * ((float)n7 / (float)n3));
            n2 = (int)((float)n2 * ((float)n8 / (float)n4));
        }
        int n22 = this.data.clipRgn;
        if (this.data.damageRgn != 0) {
            if (n22 == 0) {
                n22 = this.data.damageRgn;
            } else {
                n22 = OS.gdk_region_new();
                OS.gdk_region_union(n22, this.data.clipRgn);
                OS.gdk_region_intersect(n22, this.data.damageRgn);
            }
        }
        if (n22 != 0) {
            int[] nArray = new int[1];
            int[] nArray4 = new int[1];
            OS.gdk_region_get_rectangles(n22, nArray4, nArray);
            GdkRectangle gdkRectangle = new GdkRectangle();
            short[] sArray = new short[nArray[0] * 4];
            int n23 = 0;
            int n24 = 0;
            while (n23 < nArray[0]) {
                OS.memmove(gdkRectangle, nArray4[0] + n23 * GdkRectangle.sizeof, GdkRectangle.sizeof);
                sArray[n24] = (short)(n14 + gdkRectangle.x);
                sArray[n24 + 1] = (short)(n15 + gdkRectangle.y);
                sArray[n24 + 2] = (short)gdkRectangle.width;
                sArray[n24 + 3] = (short)gdkRectangle.height;
                ++n23;
                n24 += 4;
            }
            OS.XRenderSetPictureClipRectangles(n17, n21, 0, 0, sArray, nArray[0]);
            if (n22 != this.data.clipRgn && n22 != this.data.damageRgn) {
                OS.gdk_region_destroy(n22);
            }
            if (nArray4[0] != 0) {
                OS.g_free(nArray4[0]);
            }
        }
        OS.XRenderComposite(n17, n18 != 0 ? 3 : 1, n13, n18, n21, n, n2, n, n2, n5 + n14, n6 + n15, n7, n8);
        OS.XRenderFreePicture(n17, n21);
        OS.XRenderFreePicture(n17, n13);
        if (n18 != 0) {
            OS.XRenderFreePicture(n17, n18);
        }
    }

    int scale(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = OS.gdk_pixbuf_new(0, false, 8, n4, n5);
        if (n8 == 0) {
            return 0;
        }
        int n9 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n8, n, n9, n2, n3, 0, 0, n4, n5);
        int n10 = OS.gdk_pixbuf_scale_simple(n8, n6, n7, 2);
        OS.g_object_unref(n8);
        return n10;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int n5 = this.data.cairo;
        if (n5 != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_move_to(n5, (double)n + d, (double)n2 + d2);
            Cairo.cairo_line_to(n5, (double)n3 + d, (double)n4 + d2);
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.gdk_draw_line(this.data.drawable, this.handle, n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n3 == n4) {
                Cairo.cairo_arc_negative(n5, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, 0.0, -2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(n5);
                Cairo.cairo_translate(n5, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
                Cairo.cairo_scale(n5, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(n5, 0.0, 0.0, 1.0, 0.0, -2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(n5);
            }
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 0, n, n2, n3, n4, 0, 23040);
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(761);
        int n = this.data.cairo;
        Cairo.cairo_save(n);
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_translate(n, d, d2);
        int n2 = Cairo.cairo_copy_path(path.handle);
        if (n2 == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(n, n2);
        Cairo.cairo_path_destroy(n2);
        Cairo.cairo_stroke(n);
        Cairo.cairo_restore(n);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int n3 = this.data.cairo;
        if (n3 != 0) {
            Cairo.cairo_rectangle(n3, n, n2, 1.0, 1.0);
            Cairo.cairo_fill(n3);
            return;
        }
        OS.gdk_draw_point(this.data.drawable, this.handle, n, n2);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, true);
            Cairo.cairo_stroke(n);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 0, nArray, nArray.length / 2);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, false);
            Cairo.cairo_stroke(n);
            return;
        }
        OS.gdk_draw_lines(this.data.drawable, this.handle, nArray, nArray.length / 2);
    }

    void drawPolyline(int n, int[] nArray, boolean bl) {
        int n2 = nArray.length / 2;
        if (n2 == 0) {
            return;
        }
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_move_to(n, (double)nArray[0] + d, (double)nArray[1] + d2);
        int n3 = 1;
        int n4 = 2;
        while (n3 < n2) {
            Cairo.cairo_line_to(n, (double)nArray[n4] + d, (double)nArray[n4 + 1] + d2);
            ++n3;
            n4 += 2;
        }
        if (bl) {
            Cairo.cairo_close_path(n);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            Cairo.cairo_rectangle(n5, (double)n + d, (double)n2 + d2, n3, n4);
            Cairo.cairo_stroke(n5);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 0, n, n2, n3, n4);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if ((n7 = this.data.cairo) != 0) {
            double d = this.data.cairoXoffset;
            double d2 = this.data.cairoYoffset;
            if (n12 == 0 || n13 == 0) {
                Cairo.cairo_rectangle(n7, (double)n + d, (double)n2 + d2, n3, n4);
            } else {
                float f = (float)n12 / 2.0f;
                float f2 = (float)n13 / 2.0f;
                float f3 = (float)n10 / f;
                float f4 = (float)n11 / f2;
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (double)n8 + d, (double)n9 + d2);
                Cairo.cairo_scale(n7, f, f2);
                Cairo.cairo_move_to(n7, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(n7, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(n7, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(n7);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_stroke(n7);
            return;
        }
        int n14 = n12 / 2;
        int n15 = n13 / 2;
        int n16 = this.data.drawable;
        if (n10 > n12) {
            if (n11 > n13) {
                OS.gdk_draw_arc(n16, this.handle, 0, n8, n9, n12, n13, 5760, 5760);
                OS.gdk_draw_line(n16, this.handle, n8 + n14, n9, n8 + n10 - n14, n9);
                OS.gdk_draw_arc(n16, this.handle, 0, n8 + n10 - n12, n9, n12, n13, 0, 5760);
                OS.gdk_draw_line(n16, this.handle, n8 + n10, n9 + n15, n8 + n10, n9 + n11 - n15);
                OS.gdk_draw_arc(n16, this.handle, 0, n8 + n10 - n12, n9 + n11 - n13, n12, n13, 17280, 5760);
                OS.gdk_draw_line(n16, this.handle, n8 + n14, n9 + n11, n8 + n10 - n14, n9 + n11);
                OS.gdk_draw_arc(n16, this.handle, 0, n8, n9 + n11 - n13, n12, n13, 11520, 5760);
                OS.gdk_draw_line(n16, this.handle, n8, n9 + n15, n8, n9 + n11 - n15);
            } else {
                OS.gdk_draw_arc(n16, this.handle, 0, n8, n9, n12, n11, 5760, 11520);
                OS.gdk_draw_line(n16, this.handle, n8 + n14, n9, n8 + n10 - n14, n9);
                OS.gdk_draw_arc(n16, this.handle, 0, n8 + n10 - n12, n9, n12, n11, 17280, 11520);
                OS.gdk_draw_line(n16, this.handle, n8 + n14, n9 + n11, n8 + n10 - n14, n9 + n11);
            }
        } else if (n11 > n13) {
            OS.gdk_draw_arc(n16, this.handle, 0, n8, n9, n10, n13, 0, 11520);
            OS.gdk_draw_line(n16, this.handle, n8 + n10, n9 + n15, n8 + n10, n9 + n11 - n15);
            OS.gdk_draw_arc(n16, this.handle, 0, n8, n9 + n11 - n13, n10, n13, 11520, 11520);
            OS.gdk_draw_line(n16, this.handle, n8, n9 + n15, n8, n9 + n11 - n15);
        } else {
            OS.gdk_draw_arc(n16, this.handle, 0, n8, n9, n10, n11, 0, 23040);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        this.drawText(string, n, n2, bl ? 1 : 0);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawText(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        int n4 = this.data.cairo;
        if (n4 != 0 && OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.checkGC(5);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n4, cairo_font_extents_t2);
            double d = (double)n2 + cairo_font_extents_t2.ascent;
            Cairo.cairo_move_to(n4, n, d);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            Cairo.cairo_show_text(n4, byArray);
            Cairo.cairo_new_path(n4);
            return;
        }
        this.setString(string, n3);
        if (n4 != 0) {
            this.checkGC(4);
            if ((n3 & 1) == 0) {
                this.checkGC(2);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_rectangle(n4, n, n2, this.data.stringWidth, this.data.stringHeight);
                Cairo.cairo_fill(n4);
            }
            this.checkGC(1);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_save(n4);
                if (this.data.stringWidth == -1) {
                    this.computeStringSize();
                }
                Cairo.cairo_scale(n4, -1.0, 1.0);
                Cairo.cairo_translate(n4, -2 * n - this.data.stringWidth, 0.0);
            }
            Cairo.cairo_move_to(n4, n, n2);
            OS.pango_cairo_show_layout(n4, this.data.layout);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_restore(n4);
            }
            Cairo.cairo_new_path(n4);
            return;
        }
        this.checkGC(261);
        GdkColor gdkColor = null;
        if ((n3 & 1) == 0) {
            gdkColor = this.data.background;
        }
        if (!this.data.xorMode) {
            OS.gdk_draw_layout_with_colors(this.data.drawable, this.handle, n, n2, this.data.layout, null, gdkColor);
        } else {
            int n5;
            int n6;
            int n7 = this.data.layout;
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            if ((n6 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), this.data.stringWidth, this.data.stringHeight, -1)) == 0) {
                SWT.error(2);
            }
            if ((n5 = OS.gdk_gc_new(n6)) == 0) {
                SWT.error(2);
            }
            GdkColor gdkColor2 = new GdkColor();
            OS.gdk_gc_set_foreground(n5, gdkColor2);
            OS.gdk_draw_rectangle(n6, n5, 1, 0, 0, this.data.stringWidth, this.data.stringHeight);
            OS.gdk_gc_set_foreground(n5, this.data.foreground);
            OS.gdk_draw_layout_with_colors(n6, n5, 0, 0, n7, null, gdkColor);
            OS.g_object_unref(n5);
            OS.gdk_draw_drawable(this.data.drawable, this.handle, n6, 0, 0, n, n2, this.data.stringWidth, this.data.stringHeight);
            OS.g_object_unref(n6);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        int n7 = this.data.cairo;
        if (n7 != 0) {
            if (n3 == n4) {
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
            } else {
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(n7, (float)n3 / 2.0f, (float)n4 / 2.0f);
                if (n6 >= 0) {
                    Cairo.cairo_arc_negative(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                } else {
                    Cairo.cairo_arc(n7, 0.0, 0.0, 1.0, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f);
                }
                Cairo.cairo_line_to(n7, 0.0, 0.0);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_fill(n7);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, n, n2, n3, n4, n5 * 64, n6 * 64);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        RGB rGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangle(n, n2, n3, n4);
            return;
        }
        int n5 = this.data.cairo;
        if (n5 != 0) {
            int n6 = bl ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
            Cairo.cairo_pattern_add_color_stop_rgba(n6, 0.0, (float)rGB3.red / 255.0f, (float)rGB3.green / 255.0f, (float)rGB3.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_pattern_add_color_stop_rgba(n6, 1.0, (float)rGB4.red / 255.0f, (float)rGB4.green / 255.0f, (float)rGB4.blue / 255.0f, (float)this.data.alpha / 255.0f);
            Cairo.cairo_save(n5);
            Cairo.cairo_translate(n5, n, n2);
            Cairo.cairo_scale(n5, n3, n4);
            Cairo.cairo_rectangle(n5, 0.0, 0.0, 1.0, 1.0);
            Cairo.cairo_set_source(n5, n6);
            Cairo.cairo_fill(n5);
            Cairo.cairo_restore(n5);
            Cairo.cairo_pattern_destroy(n6);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB3, rGB4, 8, 8, 8);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            if (n3 == n4) {
                Cairo.cairo_arc_negative(n5, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, 0.0, 2.0f * (float)Compatibility.PI);
            } else {
                Cairo.cairo_save(n5);
                Cairo.cairo_translate(n5, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
                Cairo.cairo_scale(n5, (float)n3 / 2.0f, (float)n4 / 2.0f);
                Cairo.cairo_arc_negative(n5, 0.0, 0.0, 1.0, 0.0, 2.0f * (float)Compatibility.PI);
                Cairo.cairo_restore(n5);
            }
            Cairo.cairo_fill(n5);
            return;
        }
        OS.gdk_draw_arc(this.data.drawable, this.handle, 1, n, n2, n3, n4, 0, 23040);
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        int n = this.data.cairo;
        int n2 = Cairo.cairo_copy_path(path.handle);
        if (n2 == 0) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(n, n2);
        Cairo.cairo_path_destroy(n2);
        Cairo.cairo_fill(n);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        int n = this.data.cairo;
        if (n != 0) {
            this.drawPolyline(n, nArray, true);
            Cairo.cairo_fill(n);
            return;
        }
        OS.gdk_draw_polygon(this.data.drawable, this.handle, 1, nArray, nArray.length / 2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if ((n5 = this.data.cairo) != 0) {
            Cairo.cairo_rectangle(n5, n, n2, n3, n4);
            Cairo.cairo_fill(n5);
            return;
        }
        OS.gdk_draw_rectangle(this.data.drawable, this.handle, 1, n, n2, n3, n4);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
            n9 -= n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n13 < 0) {
            n13 = 0 - n13;
        }
        if ((n7 = this.data.cairo) != 0) {
            if (n12 == 0 || n13 == 0) {
                Cairo.cairo_rectangle(n7, n, n2, n3, n4);
            } else {
                float f = (float)n12 / 2.0f;
                float f2 = (float)n13 / 2.0f;
                float f3 = (float)n10 / f;
                float f4 = (float)n11 / f2;
                Cairo.cairo_save(n7);
                Cairo.cairo_translate(n7, n8, n9);
                Cairo.cairo_scale(n7, f, f2);
                Cairo.cairo_move_to(n7, f3 - 1.0f, 0.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, 1.0, 1.0, Compatibility.PI + Compatibility.PI / 2.0, Compatibility.PI * 2.0);
                Cairo.cairo_arc(n7, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, Compatibility.PI / 2.0);
                Cairo.cairo_arc(n7, 1.0, f4 - 1.0f, 1.0, Compatibility.PI / 2.0, Compatibility.PI);
                Cairo.cairo_arc(n7, 1.0, 1.0, 1.0, Compatibility.PI, 270.0 * Compatibility.PI / 180.0);
                Cairo.cairo_close_path(n7);
                Cairo.cairo_restore(n7);
            }
            Cairo.cairo_fill(n7);
            return;
        }
        int n14 = n12 / 2;
        int n15 = n13 / 2;
        int n16 = this.data.drawable;
        if (n10 > n12) {
            if (n11 > n13) {
                OS.gdk_draw_arc(n16, this.handle, 1, n8, n9, n12, n13, 5760, 5760);
                OS.gdk_draw_rectangle(n16, this.handle, 1, n8 + n14, n9, n10 - n14 * 2, n11);
                OS.gdk_draw_arc(n16, this.handle, 1, n8 + n10 - n12, n9, n12, n13, 0, 5760);
                OS.gdk_draw_rectangle(n16, this.handle, 1, n8, n9 + n15, n14, n11 - n15 * 2);
                OS.gdk_draw_arc(n16, this.handle, 1, n8 + n10 - n12, n9 + n11 - n13, n12, n13, 17280, 5760);
                OS.gdk_draw_rectangle(n16, this.handle, 1, n8 + n10 - n14, n9 + n15, n14, n11 - n15 * 2);
                OS.gdk_draw_arc(n16, this.handle, 1, n8, n9 + n11 - n13, n12, n13, 11520, 5760);
            } else {
                OS.gdk_draw_arc(n16, this.handle, 1, n8, n9, n12, n11, 5760, 11520);
                OS.gdk_draw_rectangle(n16, this.handle, 1, n8 + n14, n9, n10 - n14 * 2, n11);
                OS.gdk_draw_arc(n16, this.handle, 1, n8 + n10 - n12, n9, n12, n11, 17280, 11520);
            }
        } else if (n11 > n13) {
            OS.gdk_draw_arc(n16, this.handle, 1, n8, n9, n10, n13, 0, 11520);
            OS.gdk_draw_rectangle(n16, this.handle, 1, n8, n9 + n15, n10, n11 - n15 * 2);
            OS.gdk_draw_arc(n16, this.handle, 1, n8, n9 + n11 - n13, n10, n13, 11520, 11520);
        } else {
            OS.gdk_draw_arc(n16, this.handle, 1, n8, n9, n10, n11, 0, 23040);
        }
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (n3 == -1) {
                n3 = n2;
            }
            --n2;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return n3;
    }

    public int getAdvanceWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.cairo != 0;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int n = Cairo.cairo_get_antialias(this.data.cairo);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.gtk_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.getSize(nArray, nArray2);
        n3 = nArray[0];
        n4 = nArray2[0];
        int n5 = this.data.cairo;
        int n6 = this.data.clipRgn;
        int n7 = this.data.damageRgn;
        if (n6 != 0 || n7 != 0 || n5 != 0) {
            int n8 = OS.gdk_region_new();
            GdkRectangle gdkRectangle = new GdkRectangle();
            gdkRectangle.width = n3;
            gdkRectangle.height = n4;
            OS.gdk_region_union_with_rect(n8, gdkRectangle);
            if (n7 != 0) {
                OS.gdk_region_intersect(n8, n7);
            }
            if (n6 != 0) {
                if (this.data.clippingTransform != null) {
                    n6 = this.convertRgn(n6, this.data.clippingTransform);
                    OS.gdk_region_intersect(n8, n6);
                    OS.gdk_region_destroy(n6);
                } else {
                    OS.gdk_region_intersect(n8, n6);
                }
            }
            if (n5 != 0) {
                double[] dArray = new double[6];
                Cairo.cairo_get_matrix(n5, dArray);
                Cairo.cairo_matrix_invert(dArray);
                n6 = this.convertRgn(n8, dArray);
                OS.gdk_region_destroy(n8);
                n8 = n6;
            }
            OS.gdk_region_get_clipbox(n8, gdkRectangle);
            OS.gdk_region_destroy(n8);
            n = gdkRectangle.x;
            n2 = gdkRectangle.y;
            n3 = gdkRectangle.width;
            n4 = gdkRectangle.height;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void getClipping(Region region) {
        Object object;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        int n = region.handle;
        OS.gdk_region_subtract(n, n);
        int n2 = this.data.cairo;
        int n3 = this.data.clipRgn;
        if (n3 == 0) {
            object = new GdkRectangle();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            ((GdkRectangle)object).width = nArray[0];
            ((GdkRectangle)object).height = nArray2[0];
            OS.gdk_region_union_with_rect(n, (GdkRectangle)object);
        } else if (this.data.clippingTransform != null) {
            int n4 = this.convertRgn(n3, this.data.clippingTransform);
            OS.gdk_region_union(n, n4);
            OS.gdk_region_destroy(n4);
        } else {
            OS.gdk_region_union(n, n3);
        }
        if (this.data.damageRgn != 0) {
            OS.gdk_region_intersect(n, this.data.damageRgn);
        }
        if (n2 != 0) {
            object = new double[6];
            Cairo.cairo_get_matrix(n2, (double[])object);
            Cairo.cairo_matrix_invert((double[])object);
            int n5 = this.convertRgn(n, (double[])object);
            OS.gdk_region_subtract(n, n);
            OS.gdk_region_union(n, n5);
            OS.gdk_region_destroy(n5);
        }
    }

    public int getFillRule() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = this.data.cairo) == 0) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(n) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.context == 0) {
            this.createLayout();
        }
        this.checkGC(4);
        Font font = this.data.font;
        int n = this.data.context;
        int n2 = OS.pango_context_get_language(n);
        int n3 = OS.pango_context_get_metrics(n, font.handle, n2);
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(n3));
        fontMetrics.descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(n3));
        fontMetrics.averageCharWidth = OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(n3));
        fontMetrics.height = fontMetrics.ascent + fontMetrics.descent;
        OS.pango_font_metrics_unref(n3);
        return fontMetrics;
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.gtk_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)this.data.lineDashes[i];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    void getSize(int[] nArray, int[] nArray2) {
        if (this.data.width != -1 && this.data.height != -1) {
            nArray[0] = this.data.width;
            nArray2[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                nArray[0] = OS.gdk_window_get_width(this.data.drawable);
                nArray2[0] = OS.gdk_window_get_height(this.data.drawable);
            } else {
                OS.gdk_drawable_get_size(this.data.drawable, nArray, nArray2);
            }
            return;
        }
        if (OS.USE_CAIRO) {
            int n = Cairo.cairo_get_target(this.handle);
            switch (Cairo.cairo_surface_get_type(n)) {
                case 0: {
                    nArray[0] = Cairo.cairo_image_surface_get_width(n);
                    nArray2[0] = Cairo.cairo_image_surface_get_height(n);
                    break;
                }
                case 3: {
                    nArray[0] = Cairo.cairo_xlib_surface_get_width(n);
                    nArray2[0] = Cairo.cairo_xlib_surface_get_height(n);
                }
            }
        }
    }

    public int getTextAntialias() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0) {
            return -1;
        }
        int n2 = 0;
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            int n3 = Cairo.cairo_font_options_create();
            Cairo.cairo_get_font_options(this.data.cairo, n3);
            n2 = Cairo.cairo_font_options_get_antialias(n3);
            Cairo.cairo_font_options_destroy(n3);
        } else if (this.data.context != 0 && (n = OS.pango_cairo_context_get_font_options(this.data.context)) != 0) {
            n2 = Cairo.cairo_font_options_get_antialias(n);
        }
        switch (n2) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.data.cairo) != 0) {
            Cairo.cairo_get_matrix(n, transform.handle);
            double[] dArray = this.identity();
            Cairo.cairo_matrix_invert(dArray);
            Cairo.cairo_matrix_multiply(transform.handle, transform.handle, dArray);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    double[] identity() {
        double[] dArray = new double[6];
        if ((this.data.style & 0x8000000) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            Cairo.cairo_matrix_init(dArray, -1.0, 0.0, 0.0, 1.0, nArray[0], 0.0);
        } else {
            Cairo.cairo_matrix_init_identity(dArray);
        }
        if (this.data.identity != null) {
            Cairo.cairo_matrix_multiply(dArray, this.data.identity, dArray);
        }
        return dArray;
    }

    void init(Drawable drawable, GCData gCData, int n) {
        int n2;
        Image image;
        if (gCData.foreground != null) {
            gCData.state &= 0xFFFFFFFE;
        }
        if (gCData.background != null) {
            gCData.state &= 0xFFFFFEFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        if ((image = gCData.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
        if (OS.USE_CAIRO) {
            n2 = gCData.cairo = this.handle;
            Cairo.cairo_set_fill_rule(n2, 1);
            gCData.state &= 0xFFFFFD80;
        } else if (OS.INIT_CAIRO) {
            this.initCairo();
        }
        this.setClipping(gCData.clipRgn);
        if ((gCData.style & 0x8000000) != 0) {
            this.initCairo();
            n2 = gCData.cairo;
            Cairo.cairo_set_matrix(n2, this.identity());
        }
    }

    void initCairo() {
        this.data.device.checkCairo();
        int n = this.data.cairo;
        if (n != 0) {
            return;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 17, 0)) {
            int[] nArray;
            int n2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n3 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = this.data.drawable;
            if (this.data.image != null) {
                n4 = OS.GDK_PIXMAP_XID(n7);
            } else if (!this.data.realDrawable) {
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                nArray = new int[1];
                OS.gdk_window_get_internal_paint_info(n7, nArray, nArray2, nArray3);
                n4 = OS.gdk_x11_drawable_get_xid(nArray[0]);
                n5 = -nArray2[0];
                n6 = -nArray3[0];
            }
            int n8 = 0;
            int n9 = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                n8 = OS.gdk_window_get_width(this.data.drawable);
                n9 = OS.gdk_window_get_height(this.data.drawable);
            } else {
                nArray = new int[1];
                int[] nArray4 = new int[1];
                OS.gdk_drawable_get_size(n7, nArray, nArray4);
                n8 = nArray[0];
                n9 = nArray4[0];
            }
            int n10 = Cairo.cairo_xlib_surface_create(n2, n4, n3, n8, n9);
            if (n10 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_surface_set_device_offset(n10, n5, n6);
            this.data.cairo = n = Cairo.cairo_create(n10);
            Cairo.cairo_surface_destroy(n10);
        } else {
            this.data.cairo = n = OS.gdk_cairo_create(this.data.drawable);
        }
        if (n == 0) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(n, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    void computeStringSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_pixel_size(this.data.layout, nArray, nArray2);
        this.data.stringHeight = nArray2[0];
        this.data.stringWidth = nArray[0];
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(double[] dArray) {
        if (dArray == null) {
            return true;
        }
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0 && dArray[4] == 0.0 && dArray[5] == 0.0;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((this.data.style & 0x8000000) != 0 || OS.USE_CAIRO || OS.INIT_CAIRO) {
            if (!bl) {
                this.setAlpha(255);
                this.setAntialias(-1);
                this.setBackgroundPattern(null);
                this.setClipping(0);
                this.setForegroundPattern(null);
                this.setInterpolation(-1);
                this.setTextAntialias(-1);
                this.setTransform(null);
            }
            return;
        }
        if (bl && this.data.cairo != 0) {
            return;
        }
        if (bl) {
            try {
                this.initCairo();
            }
            catch (SWTException sWTException) {}
        } else {
            if (!this.data.disposeCairo) {
                return;
            }
            int n = this.data.cairo;
            if (n != 0) {
                Cairo.cairo_destroy(n);
            }
            this.data.cairo = 0;
            this.data.interpolation = -1;
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0);
        }
    }

    public void setAlpha(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && (n & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = n & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int n3 = this.data.cairo;
        Cairo.cairo_set_antialias(n3, n2);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(int n, Font font) {
        if (font == null || font.isDisposed()) {
            return;
        }
        GC.setCairoFont(n, font.handle);
    }

    static void setCairoFont(int n, int n2) {
        int n3 = OS.pango_font_description_get_family(n2);
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4 + 1];
        OS.memmove(byArray, n3, n4);
        double d = OS.PANGO_PIXELS(OS.pango_font_description_get_size(n2)) * 96 / 72;
        int n5 = OS.pango_font_description_get_style(n2);
        int n6 = OS.pango_font_description_get_weight(n2);
        int n7 = 0;
        if (n5 == 2) {
            n7 = 1;
        }
        if (n5 == 1) {
            n7 = 2;
        }
        int n8 = 0;
        if (n6 == 700) {
            n8 = 1;
        }
        Cairo.cairo_select_font_face(n, byArray, n7, n8);
        Cairo.cairo_set_font_size(n, d);
    }

    static void setCairoRegion(int n, int n2) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gdk_cairo_region(n, n2);
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_region_get_rectangles(n2, nArray2, nArray);
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (int i = 0; i < nArray[0]; ++i) {
                OS.memmove(gdkRectangle, nArray2[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
                Cairo.cairo_rectangle(n, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            }
            if (nArray2[0] != 0) {
                OS.g_free(nArray2[0]);
            }
        }
    }

    static void setCairoPatternColor(int n, int n2, Color color, int n3) {
        GdkColor gdkColor = color.handle;
        double d = (double)(n3 & 0xFF) / 255.0;
        double d2 = (double)(gdkColor.red & 0xFFFF) / 65535.0;
        double d3 = (double)(gdkColor.green & 0xFFFF) / 65535.0;
        double d4 = (double)(gdkColor.blue & 0xFFFF) / 65535.0;
        Cairo.cairo_pattern_add_color_stop_rgba(n, n2, d2, d3, d4, d);
    }

    void setCairoClip(int n, int n2) {
        int n3 = this.data.cairo;
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0) && this.data.drawable != 0 && !OS.GTK3) {
            OS.gdk_cairo_reset_clip(n3, this.data.drawable);
        } else {
            Cairo.cairo_reset_clip(n3);
        }
        if (n != 0) {
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(n3, dArray);
            double[] dArray2 = new double[6];
            Cairo.cairo_matrix_init_identity(dArray2);
            Cairo.cairo_set_matrix(n3, dArray2);
            GC.setCairoRegion(n3, n);
            Cairo.cairo_clip(n3);
            Cairo.cairo_set_matrix(n3, dArray);
        }
        if (n2 != 0) {
            GC.setCairoRegion(n3, n2);
            Cairo.cairo_clip(n3);
        }
    }

    void setClipping(int n) {
        int n2 = this.data.cairo;
        if (n == 0) {
            if (this.data.clipRgn != 0) {
                OS.gdk_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            if (n2 != 0) {
                this.data.clippingTransform = null;
                this.setCairoClip(this.data.damageRgn, 0);
            } else {
                int n3 = this.data.damageRgn != 0 ? this.data.damageRgn : 0;
                OS.gdk_gc_set_clip_region(this.handle, n3);
            }
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.gdk_region_new();
            }
            OS.gdk_region_subtract(this.data.clipRgn, this.data.clipRgn);
            OS.gdk_region_union(this.data.clipRgn, n);
            if (n2 != 0) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(n2, this.data.clippingTransform);
                this.setCairoClip(this.data.damageRgn, n);
            } else {
                int n4 = n;
                if (this.data.damageRgn != 0) {
                    n4 = OS.gdk_region_new();
                    OS.gdk_region_union(n4, n);
                    OS.gdk_region_intersect(n4, this.data.damageRgn);
                }
                OS.gdk_gc_set_clip_region(this.handle, n4);
                if (n4 != n) {
                    OS.gdk_region_destroy(n4);
                }
            }
        }
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        int n5 = OS.gdk_region_new();
        OS.gdk_region_union_with_rect(n5, gdkRectangle);
        this.setClipping(n5);
        OS.gdk_region_destroy(n5);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.setClipping(0);
        if (path != null) {
            this.initCairo();
            int n = this.data.cairo;
            int n2 = Cairo.cairo_copy_path(path.handle);
            if (n2 == 0) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(n, n2);
            Cairo.cairo_path_destroy(n2);
            Cairo.cairo_clip(n);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int n3 = this.data.cairo;
        if (n3 != 0) {
            Cairo.cairo_set_fill_rule(n3, n2);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = n;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x240;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x10;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl || fArray2[i] == f3) continue;
                bl = true;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        this.initCairo();
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n;
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (bl || fArray[n] == (float)n2) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.data.lineDashes[n] = nArray[n];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFFDBF;
    }

    void setString(String string, int n) {
        byte[] byArray;
        int n2;
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (n & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int n3 = string.length();
        int n4 = this.data.layout;
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        if ((n & 8) != 0 && (n2 = this.fixMnemonic(cArray)) != -1) {
            char[] cArray2 = new char[n2 - 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            byte[] byArray2 = Converter.wcsToMbcs(null, cArray2, false);
            char[] cArray3 = new char[cArray.length - n2];
            System.arraycopy(cArray, n2 - 1, cArray3, 0, cArray3.length);
            byte[] byArray3 = Converter.wcsToMbcs(null, cArray3, false);
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
            int n5 = OS.pango_attr_list_new();
            int n6 = OS.pango_attr_underline_new(3);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, n6, PangoAttribute.sizeof);
            pangoAttribute.start_index = byArray2.length;
            pangoAttribute.end_index = byArray2.length + 1;
            OS.memmove(n6, pangoAttribute, PangoAttribute.sizeof);
            OS.pango_attr_list_insert(n5, n6);
            OS.pango_layout_set_attributes(n4, n5);
            OS.pango_attr_list_unref(n5);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray, false);
            OS.pango_layout_set_attributes(n4, 0);
        }
        OS.pango_layout_set_text(n4, byArray, byArray.length);
        OS.pango_layout_set_single_paragraph_mode(n4, (n & 2) == 0);
        OS.pango_layout_set_tabs(n4, (n & 4) != 0 ? 0 : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = n;
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.cairo == 0 && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        int n3 = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(n3, n2);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            Cairo.cairo_set_font_options(this.data.cairo, n3);
        } else {
            if (this.data.context == 0) {
                this.createLayout();
            }
            OS.pango_cairo_context_set_font_options(this.data.context, n3);
        }
        Cairo.cairo_font_options_destroy(n3);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0 && transform == null) {
            return;
        }
        this.initCairo();
        int n = this.data.cairo;
        double[] dArray = this.identity();
        if (transform != null) {
            Cairo.cairo_matrix_multiply(dArray, transform.handle, dArray);
        }
        Cairo.cairo_set_matrix(n, dArray);
        this.data.state &= 0xFFFFFDFF;
    }

    public void setXORMode(boolean bl) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((n = this.data.cairo) != 0 && Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 10, 0)) {
            Cairo.cairo_set_operator(this.handle, bl ? 23 : 2);
        }
        if (!OS.USE_CAIRO) {
            OS.gdk_gc_set_function(this.handle, bl ? 2 : 0);
        }
        this.data.xorMode = bl;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((n2 = this.data.cairo) != 0 && OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.checkGC(4);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            cairo_font_extents_t cairo_font_extents_t2 = new cairo_font_extents_t();
            Cairo.cairo_font_extents(n2, cairo_font_extents_t2);
            cairo_text_extents_t cairo_text_extents_t2 = new cairo_text_extents_t();
            Cairo.cairo_text_extents(n2, byArray, cairo_text_extents_t2);
            return new Point((int)cairo_text_extents_t2.width, (int)cairo_font_extents_t2.height);
        }
        this.setString(string, n);
        this.checkGC(4);
        if (this.data.stringWidth == -1) {
            this.computeStringSize();
        }
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

