/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import java.util.Date;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.iosp.mcidas.McIDASGridRecord;
import visad.jmet.MetUnits;

public final class McIDASLookup
implements GridTableLookup {
    private McIDASGridRecord sample;

    public McIDASLookup(McIDASGridRecord sample) {
        this.sample = sample;
    }

    public String getShapeName(GridDefRecord gds) {
        return "Spherical";
    }

    public final String getGridName(GridDefRecord gds) {
        return gds.toString();
    }

    public final GridParameter getParameter(GridRecord gr) {
        McIDASGridRecord mgr = (McIDASGridRecord)gr;
        String name = mgr.getParameterName();
        String desc = mgr.getGridDescription();
        if (desc.trim().equals("")) {
            desc = name;
        }
        String unit = MetUnits.makeSymbol(mgr.getParamUnitName());
        return new GridParameter(0, name, desc, unit);
    }

    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    public final String getLevelName(GridRecord gr) {
        String levelUnit = this.getLevelUnit(gr);
        int level1 = (int)gr.getLevel1();
        int level2 = (int)gr.getLevel2();
        int levelType = gr.getLevelType1();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            return GribPDSLevel.getNameShort(levelType);
        }
        if (levelUnit.equalsIgnoreCase("hPa")) {
            return "pressure";
        }
        if (level1 == 1013) {
            return "mean sea level";
        }
        if (level1 == 0) {
            return "tropopause";
        }
        if (level1 == 1001) {
            return "surface";
        }
        if (level2 != 0) {
            return "layer";
        }
        return "";
    }

    public final String getLevelDescription(GridRecord gr) {
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            return GribPDSLevel.getNameShort(gr.getLevelType1());
        }
        return this.getLevelName(gr);
    }

    public final String getLevelUnit(GridRecord gr) {
        return MetUnits.makeSymbol(((McIDASGridRecord)gr).getLevelUnitName());
    }

    public final String getTimeRangeUnitName(int tunit) {
        return "hour";
    }

    public final Date getFirstBaseTime() {
        return this.sample.getReferenceTime();
    }

    public final boolean isLatLon(GridDefRecord gds) {
        return this.getProjectionName(gds).equals("EQUI");
    }

    public final int getProjectionType(GridDefRecord gds) {
        String name = this.getProjectionName(gds).trim();
        if (name.equals("MERC")) {
            return 3;
        }
        if (name.equals("CONF")) {
            return 2;
        }
        if (name.equals("PS")) {
            return 1;
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        int type = gr.getLevelType1();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            if (type == 20) {
                return true;
            }
            if (type == 100) {
                return true;
            }
            if (type == 101) {
                return true;
            }
            if (type >= 103 && type <= 128) {
                return true;
            }
            if (type == 141) {
                return true;
            }
            if (type == 160) {
                return true;
            }
        } else if (this.getLevelUnit(gr).equals("hPa")) {
            return true;
        }
        return false;
    }

    public final boolean isPositiveUp(GridRecord gr) {
        int type = gr.getLevelType1();
        if (((McIDASGridRecord)gr).hasGribInfo()) {
            if (type == 103) {
                return true;
            }
            if (type == 104) {
                return true;
            }
            if (type == 105) {
                return true;
            }
            if (type == 106) {
                return true;
            }
            if (type == 111) {
                return true;
            }
            if (type == 112) {
                return true;
            }
            if (type == 125) {
                return true;
            }
            if (this.getLevelUnit(gr).equals("hPa")) {
                return false;
            }
        }
        return true;
    }

    public final float getFirstMissingValue() {
        return -2.1390621E9f;
    }

    public boolean isLayer(GridRecord gr) {
        return gr.getLevel2() != 0.0;
    }

    private String getProjectionName(GridDefRecord gds) {
        return gds.getParam("ProjFlag");
    }

    public final String getTitle() {
        return "GRID data";
    }

    public String getInstitution() {
        return null;
    }

    public final String getSource() {
        return null;
    }

    public final String getComment() {
        return null;
    }

    public String getGridType() {
        return "McIDAS";
    }
}

