/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridRecord;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridEnsembleCoord {
    private static Logger log = LoggerFactory.getLogger(GridEnsembleCoord.class);
    private List<EnsCoord> ensCoords;
    private int seq = 0;

    GridEnsembleCoord(List<GridRecord> records) {
        HashMap<Integer, EnsCoord> map = new HashMap<Integer, EnsCoord>();
        for (GridRecord record : records) {
            GribGridRecord ggr = (GribGridRecord)record;
            int ensNumber = ggr.getPds().getPerturbationNumber();
            int ensType = ggr.getPds().getPerturbationType();
            map.put(ensNumber, new EnsCoord(ensNumber, ensType));
        }
        this.ensCoords = new ArrayList(map.values());
        Collections.sort(this.ensCoords);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridEnsembleCoord that = (GridEnsembleCoord)o;
        return ((Object)this.ensCoords).equals(that.ensCoords);
    }

    public int hashCode() {
        return ((Object)this.ensCoords).hashCode();
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getName() {
        return this.seq == 0 ? "ens" : "ens" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNEnsembles(), true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDimensions(v.getShortName());
        v.setDataType(DataType.STRING);
        v.addAttribute(new Attribute("long_name", "ensemble"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        String[] data = new String[this.getNEnsembles()];
        for (int i = 0; i < this.getNEnsembles(); ++i) {
            EnsCoord ec = this.ensCoords.get(i);
            data[i] = Grib2Tables.codeTable4_6(ec.type) + " " + ec.number;
        }
        Array dataArray = Array.factory(DataType.STRING, new int[]{this.getNEnsembles()}, (Object)data);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(g, v);
    }

    int getIndex(GribGridRecord ggr) {
        int ensNumber = ggr.getPds().getPerturbationNumber();
        int ensType = ggr.getPds().getPerturbationType();
        int count = 0;
        for (EnsCoord coord : this.ensCoords) {
            if (coord.number == ensNumber && coord.type == ensType) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    int getNEnsembles() {
        return this.ensCoords.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnsCoord
    implements Comparable<EnsCoord> {
        int number;
        int type;

        private EnsCoord(int number, int type) {
            this.number = number;
            this.type = type;
        }

        @Override
        public int compareTo(EnsCoord o) {
            return this.number - o.number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnsCoord ensCoord = (EnsCoord)o;
            if (this.number != ensCoord.number) {
                return false;
            }
            return this.type == ensCoord.type;
        }

        public int hashCode() {
            int result = this.number;
            result = 31 * result + this.type;
            return result;
        }
    }
}

