/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import thredds.inventory.DatasetCollectionFromCatalog;
import thredds.inventory.DatasetCollectionManager;
import thredds.inventory.FeatureCollectionConfig;
import thredds.inventory.MFile;
import thredds.inventory.NcmlCollectionReader;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.FmrcDataset;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Fmrc {
    private static Logger logger = LoggerFactory.getLogger(Fmrc.class);
    private final CollectionManager manager;
    private final FeatureCollectionConfig.Config config;
    private Object lock = new Object();
    private FmrcDataset fmrcDataset;
    private volatile boolean forceProto = false;
    private volatile Date lastInvChanged;
    private volatile Date lastProtoChanged;

    public static Fmrc open(String collection, Formatter errlog) throws IOException {
        if (collection.startsWith("catalog:")) {
            DatasetCollectionFromCatalog manager = new DatasetCollectionFromCatalog(collection);
            return new Fmrc(manager);
        }
        if (collection.endsWith(".ncml")) {
            NcmlCollectionReader ncmlCollection = NcmlCollectionReader.open(collection, errlog);
            if (ncmlCollection == null) {
                return null;
            }
            Fmrc fmrc = new Fmrc(ncmlCollection.getDatasetManager());
            fmrc.setNcml(ncmlCollection.getNcmlOuter(), ncmlCollection.getNcmlInner());
            return fmrc;
        }
        return new Fmrc(collection, errlog);
    }

    public static Fmrc open(FeatureCollectionConfig.Config config, Formatter errlog) throws IOException {
        if (config.spec.startsWith("catalog:")) {
            DatasetCollectionFromCatalog manager = new DatasetCollectionFromCatalog(config.spec);
            return new Fmrc(manager);
        }
        return new Fmrc(config, errlog);
    }

    private Fmrc(String collectionSpec, Formatter errlog) {
        this.manager = new DatasetCollectionManager(collectionSpec, errlog);
        this.config = new FeatureCollectionConfig.Config();
    }

    private Fmrc(FeatureCollectionConfig.Config config, Formatter errlog) {
        DatasetCollectionManager dcm = new DatasetCollectionManager(config, errlog);
        dcm.setRecheck(config.recheckAfter);
        this.manager = dcm;
        this.config = config;
    }

    public Fmrc(CollectionManager manager) {
        this.manager = manager;
        this.config = new FeatureCollectionConfig.Config();
    }

    public void setNcml(Element outerNcml, Element innerNcml) {
        this.config.protoConfig.outerNcml = outerNcml;
        this.config.innerNcml = innerNcml;
    }

    public double getOlderThanFilterInSecs() {
        if (this.manager instanceof DatasetCollectionManager) {
            return ((DatasetCollectionManager)this.manager).getOlderThanFilterInSecs();
        }
        return -1.0;
    }

    public CollectionManager getManager() {
        return this.manager;
    }

    public FmrcInv getFmrcInv(Formatter debug) throws IOException {
        return this.makeFmrcInv(debug);
    }

    public void triggerProto() {
        this.forceProto = true;
    }

    public void triggerRescan() throws IOException {
        this.checkNeeded(true);
    }

    public List<Date> getRunDates() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getRunDates();
    }

    public List<Date> getForecastDates() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastDates();
    }

    public double[] getForecastOffsets() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastOffsets();
    }

    public GridDataset getDataset2D(NetcdfDataset result) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getNetcdfDataset2D(result);
        return gds;
    }

    public GridDataset getDatasetBest() throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getBest();
        return gds;
    }

    public GridDataset getDatasetBest(FeatureCollectionConfig.BestDataset bd) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getBest(bd);
        return gds;
    }

    public GridDataset getRunTimeDataset(Date run) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getRunTimeDataset(run);
        return gds;
    }

    public GridDataset getConstantForecastDataset(Date time) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getConstantForecastDataset(time);
        return gds;
    }

    public GridDataset getConstantOffsetDataset(double hour) throws IOException {
        this.checkNeeded(false);
        GridDataset gds = this.fmrcDataset.getConstantOffsetDataset(hour);
        return gds;
    }

    public boolean checkInvState(Date lastInvChange) throws IOException {
        this.checkNeeded(false);
        return !this.lastInvChanged.before(lastInvChange);
    }

    public boolean checkProtoState(Date lastProtoChanged) throws IOException {
        this.checkNeeded(false);
        return !this.lastProtoChanged.before(lastProtoChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNeeded(boolean force) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean forceProtoLocal = this.forceProto;
            if (this.fmrcDataset == null) {
                try {
                    this.fmrcDataset = new FmrcDataset(this.config);
                    this.manager.scan(null);
                    FmrcInv fmrcInv = this.makeFmrcInv(null);
                    this.fmrcDataset.setInventory(fmrcInv, forceProtoLocal);
                    if (forceProtoLocal) {
                        this.forceProto = false;
                    }
                    this.lastInvChanged = new Date();
                    this.lastProtoChanged = new Date();
                    return;
                }
                catch (Throwable t) {
                    logger.error(this.config.spec + ": initial fmrcDataset creation failed", t);
                    throw new RuntimeException(t);
                }
            }
            if (!force && !this.manager.isRescanNeeded()) {
                return;
            }
            if (!this.manager.rescan()) {
                return;
            }
            try {
                FmrcInv fmrcInv = this.makeFmrcInv(null);
                this.fmrcDataset.setInventory(fmrcInv, forceProtoLocal);
                if (logger.isInfoEnabled()) {
                    logger.info(this.config.spec + ": make new Dataset, new proto = " + forceProtoLocal);
                }
                if (forceProtoLocal) {
                    this.forceProto = false;
                }
                this.lastInvChanged = new Date();
                if (forceProtoLocal) {
                    this.lastProtoChanged = new Date();
                }
            }
            catch (Throwable t) {
                logger.error(this.config.spec + ": rescan failed");
                throw new RuntimeException(t);
            }
        }
    }

    private FmrcInv makeFmrcInv(Formatter debug) throws IOException {
        try {
            HashMap<Date, FmrInv> fmrMap = new HashMap<Date, FmrInv>();
            ArrayList<FmrInv> fmrList = new ArrayList<FmrInv>();
            List<MFile> fileList = this.manager.getFiles();
            for (MFile f : fileList) {
                FmrInv fmr;
                if (logger.isDebugEnabled()) {
                    logger.debug("Fmrc: " + this.config.spec + ": file=" + f.getPath());
                }
                GridDatasetInv inv = null;
                try {
                    inv = GridDatasetInv.open(this.manager, f, this.config.innerNcml);
                }
                catch (IOException ioe) {
                    logger.warn("Error opening " + f.getPath() + "(skipped)", (Object)ioe.getMessage());
                    continue;
                }
                Date runDate = inv.getRunDate();
                if (debug != null) {
                    debug.format("  opened %s rundate = %s%n", f.getPath(), inv.getRunDateString());
                }
                if ((fmr = (FmrInv)fmrMap.get(runDate)) == null) {
                    fmr = new FmrInv(runDate);
                    fmrMap.put(runDate, fmr);
                    fmrList.add(fmr);
                }
                fmr.addDataset(inv, debug);
            }
            if (debug != null) {
                debug.format("%n", new Object[0]);
            }
            Collections.sort(fmrList);
            for (FmrInv fmr : fmrList) {
                fmr.finish();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Fmrc: " + this.config.spec + ": fmr " + fmr.getRunDate() + " nfiles= " + fmr.getFiles().size());
            }
            return new FmrcInv(this.manager.getCollectionName(), fmrList, this.config.fmrcConfig.regularize);
        }
        catch (Throwable t) {
            logger.error("makeFmrcInv", t);
            throw new RuntimeException(t);
        }
    }

    public void showDetails(Formatter out) throws IOException {
        this.checkNeeded(false);
        this.fmrcDataset.showDetails(out);
    }

    public static void main(String[] args) throws IOException {
        Formatter errlog = new Formatter();
        String spec1 = "/data/testdata/ncml/nc/nam_c20s/NAM_CONUS_20km_surface_#yyyyMMdd_HHmm#.grib1";
        String spec2 = "/data/testdata/grid/grib/grib1/data/agg/.*grb";
        String spec3 = "/data/testdata/ncml/nc/ruc_conus40/RUC_CONUS_40km_#yyyyMMdd_HHmm#.grib1";
        String spec4 = "/data/testdata/cdmUnitTest/rtmodels/.*_nmm\\.GrbF[0-9]{5}$";
        String cat1 = "catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/RUC2/CONUS_40km/files/catalog.xml";
        String cat2 = "catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NDFD/CONUS_5km/files/catalog.xml";
        String specH = "C:/data/datasets/nogaps/US058GMET-GR1mdl.*air_temp";
        String specH2 = "C:/data/ft/grid/cg/.*nc$";
        String specH3 = "C:/data/ft/grid/namExtract/#yyyyMMdd_HHmm#.*nc$";
        Fmrc fmrc = new Fmrc(specH3, errlog);
        System.out.printf("errlog = %s%n", errlog);
    }
}

