/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.GribPds;

@Immutable
public abstract class Grib2Pds
extends GribPds {
    private static Logger log = LoggerFactory.getLogger(Grib2Pds.class);
    private static final int MISSING = -9999;
    private static final double MISSINGD = -9999.0;
    protected final int template;
    protected final long refTime;
    protected long validTime = -1L;
    protected int[] intv = null;

    public static Grib2Pds factory(byte[] input, long refTime, Calendar cal) throws IOException {
        int template = GribNumbers.int2(input[7] & 0xFF, input[8] & 0xFF);
        switch (template) {
            case 0: {
                return new Grib2Pds0(input, refTime, cal);
            }
            case 1: {
                return new Grib2Pds1(input, refTime, cal);
            }
            case 2: {
                return new Grib2Pds2(input, refTime, cal);
            }
            case 5: {
                return new Grib2Pds5(input, refTime, cal);
            }
            case 6: {
                return new Grib2Pds6(input, refTime, cal);
            }
            case 8: {
                return new Grib2Pds8(input, refTime, cal);
            }
            case 9: {
                return new Grib2Pds9(input, refTime, cal);
            }
            case 10: {
                return new Grib2Pds10(input, refTime, cal);
            }
            case 11: {
                return new Grib2Pds11(input, refTime, cal);
            }
            case 12: {
                return new Grib2Pds12(input, refTime, cal);
            }
            case 15: {
                return new Grib2Pds15(input, refTime, cal);
            }
            case 30: {
                return new Grib2Pds30(input, refTime, cal);
            }
        }
        log.warn("Missing template " + template);
        return null;
    }

    public static long makeDate(long refTime, int timeUnit, int forecastTime, Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(refTime);
        int type = 1;
        int factor = 1;
        switch (timeUnit) {
            case 0: {
                type = 12;
                break;
            }
            case 1: {
                type = 11;
                break;
            }
            case 2: {
                type = 11;
                factor = 24;
                break;
            }
            case 3: {
                type = 2;
                break;
            }
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                type = 1;
                factor = 10;
                break;
            }
            case 6: {
                type = 1;
                factor = 30;
                break;
            }
            case 7: {
                type = 1;
                factor = 100;
                break;
            }
            case 10: {
                type = 11;
                factor = 3;
                break;
            }
            case 11: {
                type = 11;
                factor = 6;
                break;
            }
            case 12: {
                type = 11;
                factor = 12;
                break;
            }
            case -9999: {
                type = 11;
                factor = 0;
                break;
            }
            default: {
                log.warn("Unknown timeUnit= " + timeUnit);
                factor = 0;
            }
        }
        if (factor != 0) {
            cal.add(type, factor * forecastTime);
        }
        return cal.getTimeInMillis();
    }

    public static int makeForecastTime(long refTime, long foreDate, int timeUnit) {
        int intv = (int)((foreDate - refTime) / 1000L);
        if (timeUnit == 1) {
            return intv / 3600;
        }
        if (timeUnit == 0) {
            return intv / 60;
        }
        if (timeUnit == 2) {
            return intv / 3600 / 24;
        }
        if (timeUnit == 10) {
            return intv / 3600 / 3;
        }
        if (timeUnit == 11) {
            return intv / 3600 / 6;
        }
        if (timeUnit == 12) {
            return intv / 3600 / 12;
        }
        if (timeUnit == 13) {
            return intv;
        }
        throw new UnsupportedOperationException();
    }

    protected Grib2Pds(byte[] input, long refTime, Calendar cal) throws IOException {
        this.input = input;
        this.refTime = refTime;
        this.template = GribNumbers.int2(this.getOctet(8), this.getOctet(9));
    }

    public long getReferenceTime() {
        return this.refTime;
    }

    public final int getLength() {
        return GribNumbers.int4(this.getOctet(1), this.getOctet(2), this.getOctet(3), this.getOctet(4));
    }

    public final int getSection() {
        return this.getOctet(5);
    }

    public final int getNumberCoordinates() {
        return GribNumbers.int2(this.getOctet(6), this.getOctet(7));
    }

    public final int getProductDefinitionTemplate() {
        return this.template;
    }

    public final int getParameterCategory() {
        return this.getOctet(10);
    }

    public final int getParameterNumber() {
        return this.getOctet(11);
    }

    public int getGenProcessType() {
        return -9999;
    }

    public String getUseGenProcessType() {
        int type = this.getGenProcessType();
        if (type == 7 || type == 6) {
            return "error";
        }
        return null;
    }

    public Date getForecastDate() {
        if (this.validTime < 0L) {
            this.validTime = Grib2Pds.makeDate(this.refTime, this.getTimeUnit(), this.getForecastTime(), null);
        }
        return new Date(this.validTime);
    }

    public int getGenProcessId() {
        return -9999;
    }

    public boolean isInterval() {
        return this.template >= 8 && this.template <= 14;
    }

    public int getStatisticalProcessType() {
        if (!this.isInterval()) {
            return -1;
        }
        PdsInterval pdsIntv = (PdsInterval)((Object)this);
        TimeInterval[] ti = pdsIntv.getTimeIntervals();
        if (ti.length > 0) {
            TimeInterval ti0 = ti[0];
            return ti0.statProcessType;
        }
        return -1;
    }

    public long getIntervalTimeEnd() {
        return -9999L;
    }

    public int getForecastTime() {
        if (this.isInterval()) {
            int[] intv = this.getForecastTimeInterval();
            return intv[1];
        }
        return this._getForecastTime();
    }

    public int[] getForecastTimeInterval() {
        if (!this.isInterval()) {
            return null;
        }
        if (this.intv != null) {
            return this.intv;
        }
        int timeUnit = this.getTimeUnit();
        PdsInterval pdsIntv = (PdsInterval)((Object)this);
        int incr = 0;
        for (TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit != timeUnit || ti.timeIncrementUnit != timeUnit && ti.timeIncrementUnit != 255) {
                log.warn("TimeInterval has different units timeUnit= " + timeUnit + " TimeInterval=" + ti);
            }
            incr += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            incr += ti.timeIncrement;
        }
        int[] result = new int[2];
        result[1] = pdsIntv.getForecastTime();
        result[0] = result[1] - incr;
        this.intv = result;
        return result;
    }

    protected int _getForecastTime() {
        return GribNumbers.int4(this.getOctet(19), this.getOctet(20), this.getOctet(21), this.getOctet(22));
    }

    public boolean isEnsemble() {
        return false;
    }

    public int getPerturbationNumber() {
        return -9999;
    }

    public int getPerturbationType() {
        return -9999;
    }

    public boolean isEnsembleDerived() {
        return false;
    }

    public int getNumberEnsembleForecasts() {
        return -9999;
    }

    public boolean isProbability() {
        return false;
    }

    public double getProbabilityLowerLimit() {
        return -9999.0;
    }

    public double getProbabilityUpperLimit() {
        return -9999.0;
    }

    public int getProbabilityType() {
        return -9999;
    }

    public boolean isPercentile() {
        return false;
    }

    public int getPercentileValue() {
        return -1;
    }

    public void show(Formatter f) {
        f.format("Grib2Pds{ template=%d, validTime=%s }", this.template, this.getForecastDate());
    }

    long calcTime(long refTime, Calendar calendar, int startIndex) {
        int year = GribNumbers.int2(this.getOctet(startIndex++), this.getOctet(startIndex++));
        int month = this.getOctet(startIndex++);
        int day = this.getOctet(startIndex++);
        int hour = this.getOctet(startIndex++);
        int minute = this.getOctet(startIndex++);
        int second = this.getOctet(startIndex++);
        if (year == 0 && month == 0 && day == 0 && hour == 0 && minute == 0 && second == 0) {
            return refTime;
        }
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(16, 0);
        calendar.set(year, month - 1, day, hour, minute, second);
        return calendar.getTimeInMillis();
    }

    double applyScaleFactor(int scale, int value) {
        return scale == 0 || value == 0 ? (double)value : (double)value * Math.pow(10.0, -scale);
    }

    TimeInterval[] readTimeIntervals(int n, int startIndex) {
        TimeInterval[] result = new TimeInterval[n];
        for (int i = 0; i < n; ++i) {
            TimeInterval ti = new TimeInterval();
            ti.statProcessType = this.getOctet(startIndex++);
            ti.timeIncrementType = this.getOctet(startIndex++);
            ti.timeRangeUnit = this.getOctet(startIndex++);
            ti.timeRangeLength = GribNumbers.int4(this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++));
            ti.timeIncrementUnit = this.getOctet(startIndex++);
            ti.timeIncrement = GribNumbers.int4(this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++));
            result[i] = ti;
        }
        return result;
    }

    public static class TimeInterval {
        public int statProcessType;
        public int timeIncrementType;
        public int timeRangeUnit;
        public int timeRangeLength;
        public int timeIncrementUnit;
        public int timeIncrement;

        public void show(Formatter f) {
            f.format("TimeInterval: statProcessType= %d, timeIncrementType= %d, timeRangeUnit= %d, timeRangeLength= %d, timeIncrementUnit= %d, timeIncrement=%d%n", this.statProcessType, this.timeIncrementType, this.timeRangeUnit, this.timeRangeLength, this.timeIncrementUnit, this.timeIncrement);
        }
    }

    public static class SatelliteBand {
        public int series;
        public int number;
        public int instrumentType;
        public double value;
    }

    private static class Grib2Pds30
    extends Grib2Pds {
        Grib2Pds30(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public double getLevelValue1() {
            return -9999.0;
        }

        public double getLevelValue2() {
            return -9999.0;
        }

        public int getLevelType1() {
            return -9999;
        }

        public int getLevelType2() {
            return -9999;
        }

        public int getTimeUnit() {
            return 0;
        }

        public int getForecastTime() {
            return 0;
        }

        public int getGenProcessId() {
            return this.getOctet(13);
        }

        public int getNumSatelliteBands() {
            return this.getOctet(14);
        }

        public SatelliteBand[] getSatelliteBands() {
            int nb = this.getNumSatelliteBands();
            SatelliteBand[] result = new SatelliteBand[nb];
            int pos = 15;
            for (int i = 0; i < nb; ++i) {
                SatelliteBand sb = new SatelliteBand();
                sb.number = GribNumbers.int2(this.getOctet(pos), this.getOctet(pos + 1));
                sb.series = GribNumbers.int2(this.getOctet(pos + 2), this.getOctet(pos + 3));
                sb.instrumentType = this.getOctet(pos + 4);
                int scaleFactor = this.getOctet(pos + 5);
                int svalue = GribNumbers.int4(this.getOctet(pos + 6), this.getOctet(pos + 7), this.getOctet(pos + 8), this.getOctet(pos + 9));
                sb.value = this.applyScaleFactor(scaleFactor, svalue);
                pos += 10;
                result[i] = sb;
            }
            return result;
        }

        public int templateLength() {
            return 14 + this.getNumSatelliteBands() * 10;
        }
    }

    private static class Grib2Pds10
    extends Grib2Pds6
    implements PdsInterval {
        long endInterval;
        int ft;

        Grib2Pds10(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
            this.endInterval = this.calcTime(refTime, cal, 36);
            this.ft = Grib2Pds10.makeForecastTime(refTime, this.endInterval, this.getTimeUnit());
        }

        public long getIntervalTimeEnd() {
            return this.endInterval;
        }

        public int getForecastTime() {
            return this.ft;
        }

        public int getNumberTimeRanges() {
            return this.getOctet(43);
        }

        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(44), this.getOctet(45), this.getOctet(46), this.getOctet(47));
        }

        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 48);
        }

        public int templateLength() {
            return 48 + this.getNumberTimeRanges() * 12;
        }
    }

    private static class Grib2Pds6
    extends Grib2Pds0
    implements PdsPercentile {
        Grib2Pds6(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public boolean isPercentile() {
            return true;
        }

        public int getPercentileValue() {
            return this.getOctet(35);
        }

        public int templateLength() {
            return 36;
        }
    }

    private static class Grib2Pds8
    extends Grib2Pds0
    implements PdsInterval {
        long endInterval;
        int ft;

        Grib2Pds8(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
            this.endInterval = this.calcTime(refTime, cal, 35);
            this.ft = Grib2Pds8.makeForecastTime(refTime, this.endInterval, this.getTimeUnit());
        }

        public long getIntervalTimeEnd() {
            return this.endInterval;
        }

        public int getForecastTime() {
            return this.ft;
        }

        public int getNumberTimeRanges() {
            return this.getOctet(42);
        }

        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(43), this.getOctet(44), this.getOctet(45), this.getOctet(46));
        }

        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 47);
        }

        public int templateLength() {
            return 46 + this.getNumberTimeRanges() * 12;
        }

        public void show(Formatter f) {
            super.show(f);
            f.format("%n   endInterval=%s%n", new Date(this.endInterval));
            for (TimeInterval ti : this.getTimeIntervals()) {
                ti.show(f);
            }
        }
    }

    private static class Grib2Pds9
    extends Grib2Pds5
    implements PdsInterval {
        long endInterval;
        int ft;

        Grib2Pds9(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
            this.endInterval = this.calcTime(refTime, cal, 48);
            this.ft = Grib2Pds9.makeForecastTime(refTime, this.endInterval, this.getTimeUnit());
        }

        public long getIntervalTimeEnd() {
            return this.endInterval;
        }

        public int getForecastTime() {
            return this.ft;
        }

        public int getNumberTimeRanges() {
            return this.getOctet(55);
        }

        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(56), this.getOctet(57), this.getOctet(58), this.getOctet(59));
        }

        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 60);
        }

        public int templateLength() {
            return 59 + this.getNumberTimeRanges() * 12;
        }
    }

    private static class Grib2Pds5
    extends Grib2Pds0
    implements PdsProbability {
        Grib2Pds5(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public boolean isProbability() {
            return true;
        }

        public int getForecastProbabilityNumber() {
            return this.getOctet(35);
        }

        public int getNumberForecastProbabilities() {
            return this.getOctet(36);
        }

        public int getProbabilityType() {
            return this.getOctet(37);
        }

        public double getProbabilityLowerLimit() {
            int scale = this.getOctet(37);
            int value = GribNumbers.int4(this.getOctet(39), this.getOctet(40), this.getOctet(41), this.getOctet(42));
            return this.applyScaleFactor(scale, value);
        }

        public double getProbabilityUpperLimit() {
            int scale = this.getOctet(43);
            int value = GribNumbers.int4(this.getOctet(44), this.getOctet(45), this.getOctet(46), this.getOctet(47));
            return this.applyScaleFactor(scale, value);
        }

        public int templateLength() {
            return 47;
        }
    }

    private static class Grib2Pds12
    extends Grib2Pds2
    implements PdsInterval {
        long endInterval;
        int ft;

        Grib2Pds12(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
            this.endInterval = this.calcTime(refTime, cal, 37);
            this.ft = Grib2Pds12.makeForecastTime(refTime, this.endInterval, this.getTimeUnit());
        }

        public long getIntervalTimeEnd() {
            return this.endInterval;
        }

        public int getForecastTime() {
            return this.ft;
        }

        public int getNumberTimeRanges() {
            return this.getOctet(44);
        }

        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(45), this.getOctet(46), this.getOctet(47), this.getOctet(48));
        }

        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 49);
        }

        public int templateLength() {
            return 48 + this.getNumberTimeRanges() * 12;
        }
    }

    private static class Grib2Pds2
    extends Grib2Pds0
    implements PdsEnsembleDerived {
        Grib2Pds2(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public boolean isEnsembleDerived() {
            return true;
        }

        public int getDerivedForecastType() {
            return this.getOctet(35);
        }

        public int getNumberForecastsInEnsemble() {
            return this.getOctet(36);
        }

        public int templateLength() {
            return 36;
        }
    }

    private static class Grib2Pds11
    extends Grib2Pds1
    implements PdsInterval {
        private long endInterval;
        private int ft;

        Grib2Pds11(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
            this.endInterval = this.calcTime(refTime, cal, 37);
            this.ft = Grib2Pds11.makeForecastTime(refTime, this.endInterval, this.getTimeUnit());
        }

        public long getIntervalTimeEnd() {
            return this.endInterval;
        }

        public int getForecastTime() {
            return this.ft;
        }

        public int getNumberTimeRanges() {
            return this.getOctet(45);
        }

        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(46), this.getOctet(47), this.getOctet(48), this.getOctet(49));
        }

        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 50);
        }

        public int templateLength() {
            return 49 + this.getNumberTimeRanges() * 12;
        }
    }

    private static class Grib2Pds1
    extends Grib2Pds0
    implements PdsEnsemble {
        Grib2Pds1(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public boolean isEnsemble() {
            return true;
        }

        public int getPerturbationType() {
            return this.getOctet(35);
        }

        public int getPerturbationNumber() {
            return this.getOctet(36);
        }

        public int getNumberEnsembleForecasts() {
            return this.getOctet(37);
        }

        public int templateLength() {
            return 37;
        }
    }

    private static class Grib2Pds15
    extends Grib2Pds0 {
        Grib2Pds15(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public int getStatisticalProcessType() {
            return this.getOctet(35);
        }

        public int getSpatialProcessType() {
            return this.getOctet(36);
        }

        public int getNSpatialDataPoints() {
            return this.getOctet(37);
        }
    }

    private static class Grib2Pds0
    extends Grib2Pds {
        Grib2Pds0(byte[] input, long refTime, Calendar cal) throws IOException {
            super(input, refTime, cal);
        }

        public int getGenProcessType() {
            return this.getOctet(12);
        }

        public int getGenProcessIdBackground() {
            return this.getOctet(13);
        }

        public int getGenProcessId() {
            return this.getOctet(14);
        }

        public int getHoursAfterCutoff() {
            return GribNumbers.int2(this.getOctet(15), this.getOctet(16));
        }

        public int getMinutesAfterCutoff() {
            return this.getOctet(17);
        }

        public int getTimeUnit() {
            return this.getOctet(18);
        }

        public int getLevelType1() {
            return this.getOctet(23);
        }

        public double getLevelValue1() {
            int scaleFirstFixedSurface = this.getOctet(24);
            int valueFirstFixedSurface = GribNumbers.int4(this.getOctet(25), this.getOctet(26), this.getOctet(27), this.getOctet(28));
            return this.applyScaleFactor(scaleFirstFixedSurface, valueFirstFixedSurface);
        }

        public int getLevelType2() {
            return this.getOctet(29);
        }

        public double getLevelValue2() {
            int scale = this.getOctet(30);
            int value = GribNumbers.int4(this.getOctet(31), this.getOctet(32), this.getOctet(33), this.getOctet(34));
            return this.applyScaleFactor(scale, value);
        }

        public int templateLength() {
            return 34;
        }

        public final int getChemicalType() {
            switch (this.template) {
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    return GribNumbers.int2(this.getOctet(11), this.getOctet(12));
                }
            }
            return -9999;
        }

        public void show(Formatter f) {
            super.show(f);
        }
    }

    public static interface PdsProbability {
        public int getForecastProbabilityNumber();

        public int getNumberForecastProbabilities();

        public int getProbabilityType();

        public double getProbabilityLowerLimit();

        public double getProbabilityUpperLimit();
    }

    public static interface PdsPercentile {
        public int getPercentileValue();
    }

    public static interface PdsEnsembleDerived {
        public int getDerivedForecastType();

        public int getNumberEnsembleForecasts();
    }

    public static interface PdsEnsemble {
        public int getPerturbationType();

        public int getPerturbationNumber();

        public int getNumberEnsembleForecasts();
    }

    public static interface PdsInterval {
        public long getIntervalTimeEnd();

        public int getForecastTime();

        public int getNumberTimeRanges();

        public int getNumberMissing();

        public TimeInterval[] getTimeIntervals();
    }
}

