/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ComponentLocation;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.JTableHeader;

public class JTableHeaderLocation
extends ComponentLocation {
    private String value = null;
    private int col = -1;

    public JTableHeaderLocation() {
    }

    public JTableHeaderLocation(String value) {
        this.value = value;
    }

    public JTableHeaderLocation(int col) {
        if (col < 0) {
            String msg = Strings.get("tester.JTableHeader.invalid_index", new Object[]{new Integer(col)});
            throw new LocationUnavailableException(msg);
        }
        this.col = col;
    }

    public JTableHeaderLocation(Point where) {
        super(where);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.tableheader.bad_format", new Object[]{encoded});
    }

    protected Point indexToPoint(JTableHeader header, int index) {
        if (index < 0 || index >= header.getColumnModel().getColumnCount()) {
            String msg = Strings.get("tester.JTableHeader.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        Rectangle rect = header.getHeaderRect(index);
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    private int valueToIndex(JTableHeader header, String value) {
        int size = header.getColumnModel().getColumnCount();
        for (int i = 0; i < size; ++i) {
            String str = header.getTable().getModel().getColumnName(i);
            if (!ExtendedComparator.stringsMatch(value, str)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(JTableHeader header) {
        if (this.value != null) {
            return this.valueToIndex(header, this.value);
        }
        if (this.col != -1) {
            return this.col;
        }
        return header.columnAtPoint(super.getPoint(header));
    }

    public Point getPoint(Component c) {
        JTableHeader header = (JTableHeader)c;
        if (this.value != null || this.col != -1) {
            return this.indexToPoint(header, this.getIndex(header));
        }
        return super.getPoint(header);
    }

    public Rectangle getBounds(Component c) {
        JTableHeader header = (JTableHeader)c;
        int index = this.getIndex(header);
        if (index == -1) {
            String msg = Strings.get("tester.JTableHeader.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        return header.getHeaderRect(index);
    }

    public boolean equals(Object o) {
        if (o instanceof JTableHeaderLocation) {
            JTableHeaderLocation loc = (JTableHeaderLocation)o;
            if (this.value != null) {
                return this.value.equals(loc.value);
            }
            if (this.col != -1) {
                return this.col == loc.col;
            }
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.value != null) {
            return this.encodeValue(this.value);
        }
        if (this.col != -1) {
            return this.encodeIndex(this.col);
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if (this.isValue(encoded = encoded.trim())) {
            this.value = this.parseValue(encoded);
            return this;
        }
        if (this.isIndex(encoded)) {
            this.col = this.parseIndex(encoded);
            return this;
        }
        return super.parse(encoded);
    }
}

