/*
 * Decompiled with CFR 0.152.
 */
package abbot.finder;

import abbot.Log;
import abbot.finder.AWTHierarchy;
import abbot.util.AWT;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;

public class TestHierarchy
extends AWTHierarchy {
    private Map filtered = new WeakHashMap();
    private Map transientFiltered = new WeakHashMap();
    private static boolean trackAppletConsole = Boolean.getBoolean("abbot.applet.track_console");
    private AWTEventListener listener;

    public TestHierarchy() {
        this(true);
    }

    public TestHierarchy(boolean ignoreExisting) {
        if (ignoreExisting) {
            this.ignoreExisting();
        }
        this.listener = new TransientWindowListener();
    }

    public boolean contains(Component c) {
        return super.contains(c) && !this.isFiltered(c);
    }

    public void dispose(Window w) {
        if (this.contains(w)) {
            super.dispose(w);
            this.setFiltered(w, true);
        }
    }

    public void ignoreExisting() {
        Iterator iter = this.getRoots().iterator();
        while (iter.hasNext()) {
            this.setFiltered((Component)iter.next(), true);
        }
    }

    public Collection getRoots() {
        Collection s = super.getRoots();
        s.removeAll(this.filtered.keySet());
        return s;
    }

    public Collection getComponents(Component c) {
        if (!this.isFiltered(c)) {
            Collection s = super.getComponents(c);
            s.removeAll(this.filtered.keySet());
            return s;
        }
        return EMPTY;
    }

    private boolean isWindowFiltered(Component c) {
        Window w = AWT.getWindow(c);
        return w != null && this.isFiltered(w);
    }

    public boolean isFiltered(Component c) {
        if (c == null) {
            return false;
        }
        if ("sun.plugin.ConsoleWindow".equals(c.getClass().getName())) {
            return !trackAppletConsole;
        }
        return this.filtered.containsKey(c) || c instanceof Window && this.isFiltered(c.getParent()) || !(c instanceof Window) && this.isWindowFiltered(c);
    }

    public void setFiltered(Component c, boolean filter) {
        block5: {
            block4: {
                if (!AWT.isSharedInvisibleFrame(c)) break block4;
                Iterator iter = this.getComponents(c).iterator();
                while (iter.hasNext()) {
                    this.setFiltered((Component)iter.next(), filter);
                }
                break block5;
            }
            if (filter) {
                this.filtered.put(c, Boolean.TRUE);
            } else {
                this.filtered.remove(c);
            }
            this.transientFiltered.remove(c);
            if (!(c instanceof Window)) break block5;
            Window[] owned = ((Window)c).getOwnedWindows();
            for (int i = 0; i < owned.length; ++i) {
                this.setFiltered(owned[i], filter);
            }
        }
    }

    private class TransientWindowListener
    implements AWTEventListener {
        public TransientWindowListener() {
            long mask = 65L;
            new WeakAWTEventListener(this, mask);
        }

        public void eventDispatched(AWTEvent e) {
            Window w;
            if (e.getID() == 200 || e.getID() == 102 && e.getSource() instanceof Window) {
                Window w2 = (Window)e.getSource();
                Log.debug("window " + w2.getName() + " open/shown");
                if (TestHierarchy.this.transientFiltered.containsKey(w2)) {
                    Log.debug("un-filter window " + w2.getName());
                    TestHierarchy.this.setFiltered(w2, false);
                } else if (TestHierarchy.this.isFiltered(w2.getParent())) {
                    Log.debug("Parent is filtered, filter " + w2.getName());
                    TestHierarchy.this.setFiltered(w2, true);
                }
            } else if (e.getID() == 202 && !TestHierarchy.this.isFiltered(w = (Window)e.getSource())) {
                TestHierarchy.this.transientFiltered.put(w, Boolean.TRUE);
                Log.debug("queueing dispose of " + w.getName());
                SwingUtilities.invokeLater(new DisposeAction(w));
            }
        }

        private class DisposeAction
        implements Runnable {
            private Window w;

            public DisposeAction(Window w) {
                this.w = w;
            }

            public void run() {
                if (TestHierarchy.this.transientFiltered.containsKey(this.w)) {
                    TestHierarchy.this.setFiltered(this.w, true);
                    Log.debug("window " + this.w.getName() + " filtered");
                } else {
                    Log.debug("cancel dispose of " + this.w.getName());
                }
            }
        }
    }
}

