/*
 * Decompiled with CFR 0.152.
 */
package abbot.finder;

import abbot.ExitException;
import abbot.Log;
import abbot.finder.Hierarchy;
import abbot.tester.Robot;
import abbot.tester.WindowTracker;
import abbot.util.AWT;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public class AWTHierarchy
implements Hierarchy {
    protected static final WindowTracker tracker = WindowTracker.getTracker();
    protected static final Collection EMPTY = new ArrayList();
    private static Hierarchy defaultHierarchy = null;

    public static Hierarchy getDefault() {
        return defaultHierarchy != null ? defaultHierarchy : new AWTHierarchy();
    }

    public static void setDefault(Hierarchy h) {
        defaultHierarchy = h;
    }

    public boolean contains(Component c) {
        return true;
    }

    public void dispose(final Window w) {
        if (AWT.isAppletViewerFrame(w)) {
            return;
        }
        Log.debug("Dispose " + w);
        Window[] owned = w.getOwnedWindows();
        for (int i = 0; i < owned.length; ++i) {
            this.dispose(owned[i]);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        Runnable action = new Runnable(){

            public void run() {
                try {
                    System.setProperty("abbot.finder.disposal", "true");
                    w.dispose();
                    System.setProperty("abbot.finder.disposal", "false");
                }
                catch (NullPointerException npe) {
                    Log.log(npe);
                }
                catch (ExitException e) {
                    Log.log("Ignoring SUT exit: " + e);
                }
                catch (Throwable e) {
                    Log.warn(e);
                    Log.warn("An exception was thrown when disposing  the window " + Robot.toString(w) + ".  The exception is ignored");
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(action);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Collection getRoots() {
        return tracker.getRootWindows();
    }

    public Collection getComponents(Component c) {
        if (c instanceof Container) {
            Container cont = (Container)c;
            ArrayList<Component> list = new ArrayList<Component>();
            list.addAll(Arrays.asList(cont.getComponents()));
            if (c instanceof JMenu) {
                list.add(((JMenu)c).getPopupMenu());
            } else if (c instanceof Window) {
                list.addAll(Arrays.asList(((Window)c).getOwnedWindows()));
            } else if (c instanceof JDesktopPane) {
                list.addAll(this.findInternalFramesFromIcons(cont));
            }
            return list;
        }
        return EMPTY;
    }

    private Collection findInternalFramesFromIcons(Container cont) {
        ArrayList<JInternalFrame> list = new ArrayList<JInternalFrame>();
        int count = cont.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = cont.getComponent(i);
            if (child instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame frame = ((JInternalFrame.JDesktopIcon)child).getInternalFrame();
                if (frame == null) continue;
                list.add(frame);
                continue;
            }
            if (!(child instanceof Container)) continue;
            list.addAll(this.findInternalFramesFromIcons((Container)child));
        }
        return list;
    }

    public Container getParent(Component c) {
        JInternalFrame.JDesktopIcon icon;
        Container p = c.getParent();
        if (p == null && c instanceof JInternalFrame && (icon = ((JInternalFrame)c).getDesktopIcon()) != null) {
            p = icon.getDesktopPane();
        }
        return p;
    }
}

