/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;

public abstract class ToolBase
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.util.ToolBase");
    public Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static Options buildGeneralOptions() {
        OptionBuilder.withArgName((String)"local|namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a namenode");
        Option fs = OptionBuilder.create((String)"fs");
        OptionBuilder.withArgName((String)"local|jobtracker:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a job tracker");
        Option jt = OptionBuilder.create((String)"jt");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify an application configuration file");
        Option oconf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgPattern((String)"=", (int)1);
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((char)'D');
        Options opts = new Options();
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        return opts;
    }

    private static void processGeneralOptions(Configuration conf, CommandLine line) {
        if (line.hasOption("fs")) {
            conf.set("fs.default.name", line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            conf.set("mapred.job.tracker", line.getOptionValue("jt"));
        }
        if (line.hasOption("conf")) {
            conf.addFinalResource(new Path(line.getOptionValue("conf")));
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (int i = 0; i < property.length - 1; i += 2) {
                if (property[i] == null) continue;
                conf.set(property[i], property[i + 1]);
            }
        }
    }

    private static String[] parseGeneralOptions(Configuration conf, String[] args) {
        Options opts = ToolBase.buildGeneralOptions();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(opts, args, true);
            ToolBase.processGeneralOptions(conf, line);
            return line.getArgs();
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed: " + e.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return args;
        }
    }

    public final int doMain(Configuration conf, String[] args) throws Exception {
        String[] commandOptions = ToolBase.parseGeneralOptions(conf, args);
        this.setConf(conf);
        return this.run(commandOptions);
    }
}

