/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeCodeLoader {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.util.NativeCodeLoader");
    private static boolean nativeCodeLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    static {
        LOG.debug((Object)"Trying to load the custom-built native-hadoop library...");
        try {
            System.loadLibrary("hadoop");
            LOG.info((Object)"Loaded the native-hadoop library");
            nativeCodeLoaded = true;
        }
        catch (Throwable t) {
            LOG.debug((Object)("Failed to load native-hadoop with error: " + t));
            LOG.debug((Object)("java.library.path=" + System.getProperty("java.library.path")));
        }
        if (!nativeCodeLoaded) {
            LOG.warn((Object)"Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

