/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

public class JLong
extends JType {
    public JLong() {
        this.setJavaType(new JavaLong());
        this.setCppType(new JType.CppType(this, "int64_t"));
        this.setCType(new JType.CType(this));
    }

    String getSignature() {
        return "l";
    }

    class JavaLong
    extends JType.JavaType {
        JavaLong() {
            super(JLong.this, "long", "Long", "Long");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("ret = (int) (" + fname + "^(" + fname + ">>>32));\n");
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("long i = org.apache.hadoop.record.Utils.readVLong(" + b + ", " + s + ");\n");
            cb.append("int z = org.apache.hadoop.record.Utils.getVIntSize(i);\n");
            cb.append(s + "+=z; " + l + "-=z;\n");
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("long i1 = org.apache.hadoop.record.Utils.readVLong(b1, s1);\n");
            cb.append("long i2 = org.apache.hadoop.record.Utils.readVLong(b2, s2);\n");
            cb.append("if (i1 != i2) {\n");
            cb.append("return ((i1-i2) < 0) ? -1 : 0;\n");
            cb.append("}\n");
            cb.append("int z1 = org.apache.hadoop.record.Utils.getVIntSize(i1);\n");
            cb.append("int z2 = org.apache.hadoop.record.Utils.getVIntSize(i2);\n");
            cb.append("s1+=z1; s2+=z2; l1-=z1; l2-=z2;\n");
            cb.append("}\n");
        }
    }
}

