/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

public class JDouble
extends JType {
    public JDouble() {
        this.setJavaType(new JavaDouble());
        this.setCppType(new JType.CppType(this, "double"));
        this.setCType(new JType.CType(this));
    }

    String getSignature() {
        return "d";
    }

    class JavaDouble
    extends JType.JavaType {
        JavaDouble() {
            super(JDouble.this, "double", "Double", "Double");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            String tmp = "Double.doubleToLongBits(" + fname + ")";
            cb.append("ret = (int)(" + tmp + "^(" + tmp + ">>>32));\n");
        }

        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("if (" + l + "<8) {\n");
            cb.append("throw new java.io.IOException(\"Double is exactly 8 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append(s + "+=8; " + l + "-=8;\n");
            cb.append("}\n");
        }

        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("if (l1<8 || l2<8) {\n");
            cb.append("throw new java.io.IOException(\"Double is exactly 8 bytes. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append("double d1 = org.apache.hadoop.record.Utils.readDouble(b1, s1);\n");
            cb.append("double d2 = org.apache.hadoop.record.Utils.readDouble(b2, s2);\n");
            cb.append("if (d1 != d2) {\n");
            cb.append("return ((d1-d2) < 0) ? -1 : 0;\n");
            cb.append("}\n");
            cb.append("s1+=8; s2+=8; l1-=8; l2-=8;\n");
            cb.append("}\n");
        }
    }
}

