/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JType;

abstract class JCompType
extends JType {
    JCompType() {
    }

    class CCompType
    extends JType.CType {
        CCompType() {
            super(JCompType.this);
        }
    }

    class CppCompType
    extends JType.CppType {
        CppCompType(String type) {
            super(JCompType.this, type);
        }

        void genGetSet(CodeBuffer cb, String fname) {
            cb.append("virtual const " + this.getType() + "& get" + JType.toCamelCase(fname) + "() const {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
            cb.append("virtual " + this.getType() + "& get" + JType.toCamelCase(fname) + "() {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
        }
    }

    abstract class JavaCompType
    extends JType.JavaType {
        JavaCompType(String type, String suffix, String wrapper) {
            super(JCompType.this, type, suffix, wrapper);
        }

        void genCompareTo(CodeBuffer cb, String fname, String other) {
            cb.append("ret = " + fname + ".compareTo(" + other + ");\n");
        }

        void genEquals(CodeBuffer cb, String fname, String peer) {
            cb.append("ret = " + fname + ".equals(" + peer + ");\n");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("ret = " + fname + ".hashCode();\n");
        }

        void genClone(CodeBuffer cb, String fname) {
            cb.append("other." + fname + " = (" + this.getType() + ") this." + fname + ".clone();\n");
        }
    }
}

