/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorJobBase;

public class ValueAggregatorReducer
extends ValueAggregatorJobBase {
    public void reduce(WritableComparable key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        String keyStr = key.toString();
        int pos = keyStr.indexOf(":");
        String type = keyStr.substring(0, pos);
        keyStr = keyStr.substring(pos + ":".length());
        ValueAggregator aggregator = ValueAggregatorBaseDescriptor.generateValueAggregator(type);
        while (values.hasNext()) {
            aggregator.addNextValue(values.next());
        }
        String val = aggregator.getReport();
        key = new Text(keyStr);
        output.collect(key, new Text(val));
    }

    public void map(WritableComparable arg0, Writable arg1, OutputCollector arg2, Reporter arg3) throws IOException {
        throw new IOException("should not be called\n");
    }
}

