/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.lib.aggregate.UserDefinedValueAggregatorDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueAggregatorJobBase
implements Mapper,
Reducer {
    protected ArrayList<ValueAggregatorDescriptor> aggregatorDescriptorList = null;

    @Override
    public void configure(JobConf job) {
        this.initializeMySpec(job);
        this.logSpec();
    }

    private static ValueAggregatorDescriptor getValueAggregatorDescriptor(String spec, JobConf job) {
        if (spec == null) {
            return null;
        }
        String[] segments = spec.split(",", -1);
        String type = segments[0];
        if (type.compareToIgnoreCase("UserDefined") == 0) {
            String className = segments[1];
            return new UserDefinedValueAggregatorDescriptor(className, job);
        }
        return null;
    }

    private static ArrayList<ValueAggregatorDescriptor> getAggregatorDescriptors(JobConf job) {
        String advn = "aggregator.descriptor";
        int num = job.getInt(advn + ".num", 0);
        ArrayList<ValueAggregatorDescriptor> retv = new ArrayList<ValueAggregatorDescriptor>(num);
        for (int i = 0; i < num; ++i) {
            String spec = job.get(advn + "." + i);
            ValueAggregatorDescriptor ad = ValueAggregatorJobBase.getValueAggregatorDescriptor(spec, job);
            if (ad == null) continue;
            retv.add(ad);
        }
        return retv;
    }

    private void initializeMySpec(JobConf job) {
        this.aggregatorDescriptorList = ValueAggregatorJobBase.getAggregatorDescriptors(job);
        if (this.aggregatorDescriptorList.size() == 0) {
            this.aggregatorDescriptorList.add(new UserDefinedValueAggregatorDescriptor(ValueAggregatorBaseDescriptor.class.getCanonicalName(), job));
        }
    }

    protected void logSpec() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (this.aggregatorDescriptorList == null) {
            sb.append(" aggregatorDescriptorList: null");
        } else {
            sb.append(" aggregatorDescriptorList: ");
            for (int i = 0; i < this.aggregatorDescriptorList.size(); ++i) {
                sb.append(" ").append(this.aggregatorDescriptorList.get(i).toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

