/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorReducer;

public class ValueAggregatorJob {
    public static JobControl createValueAggregatorJobs(String[] args) throws IOException {
        JobControl theControl = new JobControl("ValueAggregatorJobs");
        ArrayList dependingJobs = new ArrayList();
        JobConf aJobConf = ValueAggregatorJob.createValueAggregatorJob(args);
        Job aJob = new Job(aJobConf, dependingJobs);
        theControl.addJob(aJob);
        return theControl;
    }

    public static JobConf createValueAggregatorJob(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("usage: inputDirs outDir [numOfReducer [textinputformat|seq [specfile [jobName]]]]");
            System.exit(1);
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 2) {
            numOfReducers = Integer.parseInt(args[2]);
        }
        Class theInputFormat = SequenceFileInputFormat.class;
        if (args.length > 3 && args[3].compareToIgnoreCase("textinputformat") == 0) {
            theInputFormat = TextInputFormat.class;
        }
        Path specFile = null;
        if (args.length > 4) {
            specFile = new Path(args[4]);
        }
        String jobName = "";
        if (args.length > 5) {
            jobName = args[5];
        }
        JobConf theJob = new JobConf(ValueAggregatorJob.class);
        if (specFile != null) {
            theJob.addDefaultResource(specFile);
        }
        FileSystem fs = FileSystem.get(theJob);
        theJob.setJobName("ValueAggregatorJob: " + jobName);
        String[] inputDirsSpecs = inputDir.split(",");
        for (int i = 0; i < inputDirsSpecs.length; ++i) {
            theJob.addInputPath(new Path(inputDirsSpecs[i]));
        }
        theJob.setInputFormat(theInputFormat);
        theJob.setMapperClass(ValueAggregatorMapper.class);
        theJob.setOutputPath(new Path(outputDir));
        theJob.setOutputFormat(TextOutputFormat.class);
        theJob.setMapOutputKeyClass(Text.class);
        theJob.setMapOutputValueClass(Text.class);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(ValueAggregatorReducer.class);
        theJob.setCombinerClass(ValueAggregatorCombiner.class);
        theJob.setNumMapTasks(1);
        theJob.setNumReduceTasks(numOfReducers);
        return theJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        boolean sucess = true;
        RunningJob running = null;
        try {
            running = jc.submitJob(job);
            String jobId = running.getJobID();
            System.out.println("Job " + jobId + " is submitted");
            while (!running.isComplete()) {
                System.out.println("Job " + jobId + " is still running.");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                running = jc.getJob(jobId);
            }
            sucess = running.isSuccessful();
        }
        finally {
            if (!sucess && running != null) {
                running.killJob();
            }
            jc.close();
        }
        return sucess;
    }

    public static void main(String[] args) throws IOException {
        JobConf job = ValueAggregatorJob.createValueAggregatorJob(args);
        ValueAggregatorJob.runJob(job);
    }
}

