/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class RegexMapper
extends MapReduceBase
implements Mapper {
    private Pattern pattern;
    private int group;

    public void configure(JobConf job) {
        this.pattern = Pattern.compile(job.get("mapred.mapper.regex"));
        this.group = job.getInt("mapred.mapper.regex.group", 0);
    }

    public void map(WritableComparable key, Writable value, OutputCollector output, Reporter reporter) throws IOException {
        String text = ((Text)value).toString();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            output.collect(new Text(matcher.group(this.group)), new LongWritable(1L));
        }
    }
}

