/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

public class KeyFieldBasedPartitioner
implements Partitioner {
    private int numOfPartitionFields;
    private String keyFieldSeparator;

    public void configure(JobConf job) {
        this.keyFieldSeparator = job.get("map.output.key.field.separator", "\t");
        this.numOfPartitionFields = job.getInt("num.key.fields.for.partition", 0);
    }

    public int getPartition(WritableComparable key, Writable value, int numReduceTasks) {
        String partitionKeyStr = key.toString();
        String[] fields = partitionKeyStr.split(this.keyFieldSeparator);
        if (this.numOfPartitionFields > 0 && this.numOfPartitionFields < fields.length) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.numOfPartitionFields; ++i) {
                sb.append(fields[i]).append(this.keyFieldSeparator);
            }
            partitionKeyStr = sb.toString();
            if (partitionKeyStr.length() > 0) {
                partitionKeyStr = partitionKeyStr.substring(0, partitionKeyStr.length() - 1);
            }
        }
        return (partitionKeyStr.hashCode() & Integer.MAX_VALUE) % numReduceTasks;
    }
}

