/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormatBase;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class TextOutputFormat
extends OutputFormatBase {
    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path dir = job.getOutputPath();
        FileSystem fs = dir.getFileSystem(job);
        boolean isCompressed = TextOutputFormat.getCompressOutput(job);
        if (!isCompressed) {
            FSDataOutputStream fileOut = fs.create(new Path(dir, name), progress);
            return new LineRecordWriter(fileOut);
        }
        Class codecClass = TextOutputFormat.getOutputCompressorClass(job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
        Path filename = new Path(dir, name + codec.getDefaultExtension());
        FSDataOutputStream fileOut = fs.create(filename, progress);
        return new LineRecordWriter(new DataOutputStream(codec.createOutputStream(fileOut)));
    }

    protected static class LineRecordWriter
    implements RecordWriter {
        private DataOutputStream out;

        public LineRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        public synchronized void write(WritableComparable key, Writable value) throws IOException {
            if (key == null && value == null) {
                return;
            }
            if (key != null) {
                this.out.write(key.toString().getBytes("UTF-8"));
            }
            if (key != null && value != null) {
                this.out.write("\t".getBytes("UTF-8"));
            }
            if (value != null) {
                this.out.write(value.toString().getBytes("UTF-8"));
            }
            this.out.writeByte(10);
        }

        public synchronized void close(Reporter reporter) throws IOException {
            this.out.close();
        }
    }
}

