/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class TaskLogAppender
extends AppenderSkeleton {
    private TaskLog.Writer taskLogWriter = null;
    private String taskId;
    private int noKeepSplits;
    private long totalLogFileSize;
    private boolean purgeLogSplits;
    private int logsRetainHours;

    public void activateOptions() {
        this.taskLogWriter = new TaskLog.Writer(this.taskId, TaskLog.LogFilter.SYSLOG, this.noKeepSplits, this.totalLogFileSize, this.purgeLogSplits, this.logsRetainHours);
        try {
            this.taskLogWriter.init();
        }
        catch (IOException ioe) {
            this.taskLogWriter = null;
            this.errorHandler.error("Failed to initialize the task's logging infrastructure: " + StringUtils.stringifyException(ioe));
        }
    }

    protected synchronized void append(LoggingEvent event) {
        if (this.taskLogWriter == null) {
            this.errorHandler.error("Calling 'append' on uninitialize/closed logger");
            return;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout for appender " + this.name, null, 5);
        }
        String logMessage = this.layout.format(event);
        try {
            byte[] logMessageData = logMessage.getBytes();
            this.taskLogWriter.write(logMessageData, 0, logMessageData.length);
        }
        catch (IOException ioe) {
            this.errorHandler.error("Failed to log: '" + logMessage + "' to the task's logging infrastructure with the exception: " + StringUtils.stringifyException(ioe));
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public synchronized void close() {
        if (this.taskLogWriter != null) {
            try {
                this.taskLogWriter.close();
            }
            catch (IOException ioe) {
                this.errorHandler.error("Failed to close the task's log with the exception: " + StringUtils.stringifyException(ioe));
            }
        } else {
            this.errorHandler.error("Calling 'close' on uninitialize/closed logger");
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public int getNoKeepSplits() {
        return this.noKeepSplits;
    }

    public void setNoKeepSplits(int noKeepSplits) {
        this.noKeepSplits = noKeepSplits;
    }

    public int getLogsRetainHours() {
        return this.logsRetainHours;
    }

    public void setLogsRetainHours(int logsRetainHours) {
        this.logsRetainHours = logsRetainHours;
    }

    public boolean isPurgeLogSplits() {
        return this.purgeLogSplits;
    }

    public void setPurgeLogSplits(boolean purgeLogSplits) {
        this.purgeLogSplits = purgeLogSplits;
    }

    public long getTotalLogFileSize() {
        return this.totalLogFileSize;
    }

    public void setTotalLogFileSize(long splitFileSize) {
        this.totalLogFileSize = splitFileSize;
    }
}

