/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.BufferSorter;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapTaskRunner;
import org.apache.hadoop.mapred.MergeSorter;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

class MapTask
extends Task {
    private BytesWritable split = new BytesWritable();
    private String splitClass;
    private InputSplit instantiatedSplit = null;
    private static final int APPROX_HEADER_LENGTH = 150;
    private static final Log LOG = LogFactory.getLog((String)MapTask.class.getName());

    public MapTask() {
        this.setPhase(TaskStatus.Phase.MAP);
    }

    public MapTask(String jobId, String jobFile, String tipId, String taskId, int partition, String splitClass, BytesWritable split) throws IOException {
        super(jobId, jobFile, tipId, taskId, partition);
        this.setPhase(TaskStatus.Phase.MAP);
        this.splitClass = splitClass;
        this.split.set(split);
    }

    public boolean isMapTask() {
        return true;
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        super.localizeConfiguration(conf);
        Path localSplit = new Path(new Path(this.getJobFile()).getParent(), "split.dta");
        LOG.debug((Object)("Writing local split to " + localSplit));
        FSDataOutputStream out = FileSystem.getLocal(conf).create(localSplit);
        Text.writeString(out, this.splitClass);
        this.split.write(out);
        ((FilterOutputStream)out).close();
    }

    public TaskRunner createRunner(TaskTracker tracker) {
        return new MapTaskRunner(this, tracker, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString(out, this.splitClass);
        this.split.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.splitClass = Text.readString(in);
        this.split.readFields(in);
    }

    InputSplit getInputSplit() throws UnsupportedOperationException {
        return this.instantiatedSplit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JobConf job, final TaskUmbilicalProtocol umbilical) throws IOException {
        final Reporter reporter = this.getReporter(umbilical);
        int numReduceTasks = this.conf.getNumReduceTasks();
        LOG.info((Object)("numReduceTasks: " + numReduceTasks));
        MapOutputCollector collector = null;
        collector = numReduceTasks > 0 ? new MapOutputBuffer(umbilical, job, reporter) : new DirectMapOutputCollector(umbilical, job, reporter);
        try {
            this.instantiatedSplit = (InputSplit)ReflectionUtils.newInstance(job.getClassByName(this.splitClass), job);
        }
        catch (ClassNotFoundException exp) {
            IOException wrap = new IOException("Split class " + this.splitClass + " not found");
            wrap.initCause(exp);
            throw wrap;
        }
        DataInputBuffer splitBuffer = new DataInputBuffer();
        splitBuffer.reset(this.split.get(), 0, this.split.getSize());
        this.instantiatedSplit.readFields(splitBuffer);
        if (this.instantiatedSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)this.instantiatedSplit;
            job.set("map.input.file", fileSplit.getPath().toString());
            job.setLong("map.input.start", fileSplit.getStart());
            job.setLong("map.input.length", fileSplit.getLength());
        }
        final RecordReader rawIn = job.getInputFormat().getRecordReader(this.instantiatedSplit, job, reporter);
        RecordReader in = new RecordReader(){

            public WritableComparable createKey() {
                return rawIn.createKey();
            }

            public Writable createValue() {
                return rawIn.createValue();
            }

            public synchronized boolean next(Writable key, Writable value) throws IOException {
                MapTask.this.setProgress(this.getProgress());
                MapTask.this.reportProgress(umbilical);
                long beforePos = this.getPos();
                boolean ret = rawIn.next(key, value);
                if (ret) {
                    reporter.incrCounter(Task.Counter.MAP_INPUT_RECORDS, 1L);
                    reporter.incrCounter(Task.Counter.MAP_INPUT_BYTES, this.getPos() - beforePos);
                }
                return ret;
            }

            public long getPos() throws IOException {
                return rawIn.getPos();
            }

            public void close() throws IOException {
                rawIn.close();
            }

            public float getProgress() throws IOException {
                return rawIn.getProgress();
            }
        };
        MapRunnable runner = (MapRunnable)ReflectionUtils.newInstance(job.getMapRunnerClass(), job);
        try {
            runner.run(in, collector, reporter);
            collector.flush();
        }
        finally {
            in.close();
            collector.close();
        }
        this.done(umbilical);
    }

    private Thread createProgressThread(final TaskUmbilicalProtocol umbilical) {
        Thread sortProgress = new Thread(){

            public void run() {
                LOG.debug((Object)("Started thread: " + this.getName()));
                while (true) {
                    try {
                        while (true) {
                            MapTask.this.reportProgress(umbilical);
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Throwable e) {
                        LOG.info((Object)("Thread Exception in reporting sort progress\n" + StringUtils.stringifyException(e)));
                        continue;
                    }
                    break;
                }
            }
        };
        sortProgress.setName("Sort progress reporter for task " + this.getTaskId());
        sortProgress.setDaemon(true);
        sortProgress.start();
        return sortProgress;
    }

    class MapOutputBuffer
    implements MapOutputCollector {
        private final int partitions;
        private Partitioner partitioner;
        private TaskUmbilicalProtocol umbilical;
        private JobConf job;
        private Reporter reporter;
        private DataOutputBuffer keyValBuffer;
        private int maxBufferSize;
        private int numSpills;
        private FileSystem localFs;
        private CompressionCodec codec;
        private SequenceFile.CompressionType compressionType;
        private Class keyClass;
        private Class valClass;
        private WritableComparator comparator;
        private BufferSorter[] sortImpl;
        private SequenceFile.Writer writer;
        private FSDataOutputStream out;
        private FSDataOutputStream indexOut;
        private long segmentStart;

        public MapOutputBuffer(TaskUmbilicalProtocol umbilical, JobConf job, Reporter reporter) throws IOException {
            this.partitions = job.getNumReduceTasks();
            this.partitioner = (Partitioner)ReflectionUtils.newInstance(job.getPartitionerClass(), job);
            this.maxBufferSize = job.getInt("io.sort.mb", 100) * 1024 * 1024;
            this.keyValBuffer = new DataOutputBuffer();
            this.umbilical = umbilical;
            this.job = job;
            this.reporter = reporter;
            this.comparator = job.getOutputKeyComparator();
            this.keyClass = job.getMapOutputKeyClass();
            this.valClass = job.getMapOutputValueClass();
            this.localFs = FileSystem.getLocal(job);
            this.codec = null;
            this.compressionType = SequenceFile.CompressionType.NONE;
            if (job.getCompressMapOutput()) {
                this.compressionType = job.getMapOutputCompressionType();
                Class<? extends CompressionCodec> codecClass = job.getMapOutputCompressorClass(DefaultCodec.class);
                this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
            }
            this.sortImpl = new BufferSorter[this.partitions];
            for (int i = 0; i < this.partitions; ++i) {
                this.sortImpl[i] = (BufferSorter)ReflectionUtils.newInstance(job.getClass("map.sort.class", MergeSorter.class, BufferSorter.class), job);
            }
        }

        public void startPartition(int partNumber) throws IOException {
            this.segmentStart = this.out.getPos();
            this.writer = SequenceFile.createWriter(this.job, this.out, this.job.getMapOutputKeyClass(), this.job.getMapOutputValueClass(), this.compressionType, this.codec);
        }

        private void endPartition(int partNumber) throws IOException {
            this.writer.sync();
            this.indexOut.writeLong(this.segmentStart);
            this.indexOut.writeLong(this.out.getPos() - this.segmentStart);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void collect(WritableComparable key, Writable value) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", recieved " + key.getClass().getName());
            }
            if (value.getClass() != this.valClass) {
                throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", recieved " + value.getClass().getName());
            }
            MapOutputBuffer mapOutputBuffer = this;
            synchronized (mapOutputBuffer) {
                int keyOffset = this.keyValBuffer.getLength();
                key.write(this.keyValBuffer);
                int keyLength = this.keyValBuffer.getLength() - keyOffset;
                value.write(this.keyValBuffer);
                int valLength = this.keyValBuffer.getLength() - (keyOffset + keyLength);
                int partNumber = this.partitioner.getPartition(key, value, this.partitions);
                this.sortImpl[partNumber].addKeyValue(keyOffset, keyLength, valLength);
                this.reporter.incrCounter(Task.Counter.MAP_OUTPUT_RECORDS, 1L);
                this.reporter.incrCounter(Task.Counter.MAP_OUTPUT_BYTES, this.keyValBuffer.getLength() - keyOffset);
                long totalMem = 0L;
                for (int i = 0; i < this.partitions; ++i) {
                    totalMem += this.sortImpl[i].getMemoryUtilized();
                }
                if ((long)this.keyValBuffer.getLength() + totalMem >= (long)this.maxBufferSize) {
                    Thread progress = MapTask.this.createProgressThread(this.umbilical);
                    try {
                        this.sortAndSpillToDisk();
                        this.keyValBuffer.reset();
                        for (int i = 0; i < this.partitions; ++i) {
                            this.sortImpl[i].close();
                        }
                    }
                    finally {
                        progress.interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortAndSpillToDisk() throws IOException {
            MapOutputBuffer mapOutputBuffer = this;
            synchronized (mapOutputBuffer) {
                long size = this.keyValBuffer.getLength() + this.partitions * 150;
                Path filename = MapTask.this.mapOutputFile.getSpillFileForWrite(MapTask.this.getTaskId(), this.numSpills, size);
                this.out = this.localFs.create(filename);
                Path indexFilename = MapTask.this.mapOutputFile.getSpillIndexFileForWrite(MapTask.this.getTaskId(), this.numSpills, this.partitions * 16);
                this.indexOut = this.localFs.create(indexFilename);
                LOG.debug((Object)("opened " + MapTask.this.mapOutputFile.getSpillFile(MapTask.this.getTaskId(), this.numSpills).getName()));
                for (int i = 0; i < this.partitions; ++i) {
                    this.sortImpl[i].setInputBuffer(this.keyValBuffer);
                    SequenceFile.Sorter.RawKeyValueIterator rIter = this.sortImpl[i].sort();
                    this.startPartition(i);
                    if (rIter != null) {
                        if (this.job.getCombinerClass() != null) {
                            Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.job.getCombinerClass(), this.job);
                            OutputCollector combineCollector = new OutputCollector(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void collect(WritableComparable key, Writable value) throws IOException {
                                    1 var3_3 = this;
                                    synchronized (var3_3) {
                                        MapOutputBuffer.this.writer.append(key, value);
                                    }
                                }
                            };
                            this.combineAndSpill(rIter, combiner, combineCollector);
                            combiner.close();
                        } else {
                            this.spill(rIter);
                        }
                    }
                    this.endPartition(i);
                }
                ++this.numSpills;
                this.out.close();
                this.indexOut.close();
            }
        }

        private void combineAndSpill(SequenceFile.Sorter.RawKeyValueIterator resultIter, Reducer combiner, OutputCollector combineCollector) throws IOException {
            CombineValuesIterator values = new CombineValuesIterator(resultIter, this.comparator, this.keyClass, this.valClass, this.job, this.reporter);
            while (values.more()) {
                combiner.reduce(values.getKey(), values, combineCollector, this.reporter);
                values.nextKey();
                this.reporter.incrCounter(Task.Counter.COMBINE_OUTPUT_RECORDS, 1L);
            }
        }

        private void spill(SequenceFile.Sorter.RawKeyValueIterator resultIter) throws IOException {
            WritableComparable key = null;
            Writable value = null;
            try {
                key = (WritableComparable)ReflectionUtils.newInstance(this.keyClass, this.job);
                value = (Writable)ReflectionUtils.newInstance(this.valClass, this.job);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            DataInputBuffer keyIn = new DataInputBuffer();
            DataInputBuffer valIn = new DataInputBuffer();
            DataOutputBuffer valOut = new DataOutputBuffer();
            while (resultIter.next()) {
                keyIn.reset(resultIter.getKey().getData(), resultIter.getKey().getLength());
                key.readFields(keyIn);
                valOut.reset();
                resultIter.getValue().writeUncompressedBytes(valOut);
                valIn.reset(valOut.getData(), valOut.getLength());
                value.readFields(valIn);
                this.writer.append(key, value);
            }
        }

        private void mergeParts() throws IOException {
            long finalOutFileSize = 0L;
            long finalIndexFileSize = 0L;
            Path[] filename = new Path[this.numSpills];
            Path[] indexFileName = new Path[this.numSpills];
            for (int i = 0; i < this.numSpills; ++i) {
                filename[i] = MapTask.this.mapOutputFile.getSpillFile(MapTask.this.getTaskId(), i);
                indexFileName[i] = MapTask.this.mapOutputFile.getSpillIndexFile(MapTask.this.getTaskId(), i);
                finalOutFileSize += this.localFs.getLength(filename[i]);
            }
            finalIndexFileSize = this.partitions * 16;
            Path finalOutputFile = MapTask.this.mapOutputFile.getOutputFileForWrite(MapTask.this.getTaskId(), finalOutFileSize += (long)(this.partitions * 150));
            Path finalIndexFile = MapTask.this.mapOutputFile.getOutputIndexFileForWrite(MapTask.this.getTaskId(), finalIndexFileSize);
            if (this.numSpills == 1) {
                this.localFs.rename(filename[0], finalOutputFile);
                this.localFs.rename(indexFileName[0], finalIndexFile);
                return;
            }
            FSDataOutputStream finalOut = this.localFs.create(finalOutputFile, true, 4096);
            FSDataOutputStream finalIndexOut = this.localFs.create(finalIndexFile, true, 4096);
            if (this.numSpills == 0) {
                for (int i = 0; i < this.partitions; ++i) {
                    long segmentStart = finalOut.getPos();
                    SequenceFile.createWriter(this.job, finalOut, this.job.getMapOutputKeyClass(), this.job.getMapOutputValueClass(), this.compressionType, this.codec);
                    finalIndexOut.writeLong(segmentStart);
                    finalIndexOut.writeLong(finalOut.getPos() - segmentStart);
                }
                finalOut.close();
                finalIndexOut.close();
                return;
            }
            SequenceFile.Sorter sorter = new SequenceFile.Sorter(this.localFs, this.keyClass, this.valClass, (Configuration)this.job);
            for (int parts = 0; parts < this.partitions; ++parts) {
                ArrayList<SequenceFile.Sorter.SegmentDescriptor> segmentList = new ArrayList<SequenceFile.Sorter.SegmentDescriptor>(this.numSpills);
                for (int i = 0; i < this.numSpills; ++i) {
                    FSDataInputStream indexIn = this.localFs.open(indexFileName[i]);
                    indexIn.seek(parts * 16);
                    long segmentOffset = indexIn.readLong();
                    long segmentLength = indexIn.readLong();
                    indexIn.close();
                    SequenceFile.Sorter sorter2 = sorter;
                    sorter2.getClass();
                    SequenceFile.Sorter.SegmentDescriptor s = sorter2.new SequenceFile.Sorter.SegmentDescriptor(segmentOffset, segmentLength, filename[i]);
                    s.preserveInput(true);
                    s.doSync();
                    segmentList.add(i, s);
                }
                long segmentStart = finalOut.getPos();
                SequenceFile.Writer writer = SequenceFile.createWriter(this.job, finalOut, this.job.getMapOutputKeyClass(), this.job.getMapOutputValueClass(), this.compressionType, this.codec);
                sorter.writeFile(sorter.merge(segmentList, new Path(MapTask.this.getTaskId())), writer);
                writer.sync();
                finalIndexOut.writeLong(segmentStart);
                finalIndexOut.writeLong(finalOut.getPos() - segmentStart);
            }
            finalOut.close();
            finalIndexOut.close();
            for (int i = 0; i < this.numSpills; ++i) {
                this.localFs.delete(filename[i]);
                this.localFs.delete(indexFileName[i]);
            }
        }

        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Thread progress = MapTask.this.createProgressThread(this.umbilical);
            try {
                if (this.keyValBuffer.getLength() > 0) {
                    this.sortAndSpillToDisk();
                }
                this.mergeParts();
            }
            finally {
                progress.interrupt();
            }
        }

        private class CombineValuesIterator
        extends ReduceTask.ValuesIterator {
            public CombineValuesIterator(SequenceFile.Sorter.RawKeyValueIterator in, WritableComparator comparator, Class keyClass, Class valClass, Configuration conf, Reporter reporter) throws IOException {
                super(in, comparator, keyClass, valClass, conf, reporter);
            }

            public Object next() {
                this.reporter.incrCounter(Task.Counter.COMBINE_INPUT_RECORDS, 1L);
                return super.next();
            }
        }
    }

    class DirectMapOutputCollector
    implements MapOutputCollector {
        private RecordWriter out = null;
        private Reporter reporter = null;
        private JobConf job;
        private TaskUmbilicalProtocol umbilical;

        public DirectMapOutputCollector(TaskUmbilicalProtocol umbilical, JobConf job, Reporter reporter) throws IOException {
            this.umbilical = umbilical;
            this.job = job;
            this.reporter = reporter;
            String finalName = MapTask.this.getTipId();
            FileSystem fs = FileSystem.get(this.job);
            this.out = job.getOutputFormat().getRecordWriter(fs, job, finalName, reporter);
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close(this.reporter);
            }
        }

        public void flush() throws IOException {
        }

        public void collect(WritableComparable key, Writable value) throws IOException {
            this.out.write(key, value);
        }
    }

    static interface MapOutputCollector
    extends OutputCollector {
        public void close() throws IOException;

        public void flush() throws IOException;
    }
}

