/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class LineRecordReader
implements RecordReader {
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private BufferedInputStream in;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(256);
    private TextStuffer bridge = new TextStuffer();

    public LineRecordReader(Configuration job, FileSplit split) throws IOException {
        FSDataInputStream fileIn;
        long start = split.getStart();
        long end = start + split.getLength();
        Path file = split.getPath();
        this.compressionCodecs = new CompressionCodecFactory(job);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = FileSystem.get(job);
        InputStream in = fileIn = fs.open(split.getPath());
        if (codec != null) {
            in = codec.createInputStream(fileIn);
            end = Long.MAX_VALUE;
        } else if (start != 0L) {
            fileIn.seek(start - 1L);
            LineRecordReader.readLine(fileIn, null);
            start = fileIn.getPos();
        }
        this.in = new BufferedInputStream(in);
        this.start = start;
        this.pos = start;
        this.end = end;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset) throws IOException {
        this.in = new BufferedInputStream(in);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    public WritableComparable createKey() {
        return new LongWritable();
    }

    public Writable createValue() {
        return new Text();
    }

    public synchronized boolean next(Writable key, Writable value) throws IOException {
        if (this.pos >= this.end) {
            return false;
        }
        ((LongWritable)key).set(this.pos);
        this.buffer.reset();
        long bytesRead = this.readLine();
        if (bytesRead == 0L) {
            return false;
        }
        this.pos += bytesRead;
        this.bridge.target = (Text)value;
        this.buffer.writeTo(this.bridge);
        return true;
    }

    protected long readLine() throws IOException {
        return LineRecordReader.readLine(this.in, this.buffer);
    }

    public static long readLine(InputStream in, OutputStream out) throws IOException {
        int b;
        long bytes = 0L;
        while ((b = in.read()) != -1) {
            ++bytes;
            byte c = (byte)b;
            if (c == 10) break;
            if (c == 13) {
                in.mark(1);
                byte nextC = (byte)in.read();
                if (nextC != 10) {
                    in.reset();
                    break;
                }
                ++bytes;
                break;
            }
            if (out == null) continue;
            out.write(c);
        }
        return bytes;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    private static class TextStuffer
    extends OutputStream {
        public Text target;

        private TextStuffer() {
        }

        public void write(int b) {
            throw new UnsupportedOperationException("write(byte) not supported");
        }

        public void write(byte[] data, int offset, int len) throws IOException {
            this.target.set(data, offset, len);
        }
    }
}

