/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class FileSplit
implements InputSplit {
    private Path file;
    private long start;
    private long length;
    private JobConf conf;

    FileSplit() {
    }

    public FileSplit(Path file, long start, long length, JobConf conf) {
        this.file = file;
        this.start = start;
        this.length = length;
        this.conf = conf;
    }

    public File getFile() {
        return new File(this.file.toString());
    }

    public Path getPath() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return this.file + ":" + this.start + "+" + this.length;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.file.toString());
        out.writeLong(this.start);
        out.writeLong(this.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.file = new Path(UTF8.readString(in));
        this.start = in.readLong();
        this.length = in.readLong();
    }

    public String[] getLocations() throws IOException {
        String[][] hints = this.file.getFileSystem(this.conf).getFileCacheHints(this.file, this.start, this.length);
        if (hints != null && hints.length > 0) {
            return hints[0];
        }
        return new String[0];
    }
}

