/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters
implements Writable {
    private Map<String, Map<Integer, CounterRec>> counters = new TreeMap<String, Map<Integer, CounterRec>>();

    public synchronized Collection<String> getGroupNames() {
        return new ArrayList<String>(this.counters.keySet());
    }

    public synchronized Group getGroup(String groupName) {
        Map<Integer, CounterRec> counterMap = this.counters.get(groupName);
        Collection<Object> groupCounters = counterMap == null ? Collections.emptySet() : counterMap.values();
        return new Group(groupName, groupCounters);
    }

    public synchronized void incrCounter(Enum key, long amount) {
        int ordinal = key.ordinal();
        String counterName = key.toString();
        String groupName = key.getDeclaringClass().getName();
        Map<Integer, CounterRec> counterMap = this.getCounterMap(groupName);
        CounterRec counter = this.getCounter(counterMap, counterName, ordinal);
        counter.value += amount;
    }

    public synchronized long getCounter(Enum key) {
        long result = 0L;
        String groupName = key.getDeclaringClass().getName();
        Map<Integer, CounterRec> counterMap = this.counters.get(groupName);
        if (counterMap != null) {
            int ordinal = key.ordinal();
            String name = key.toString();
            CounterRec counter = counterMap.get(ordinal);
            if (counter != null && counter.name.equals(name)) {
                result = counter.value;
            } else {
                for (CounterRec ctr : counterMap.values()) {
                    if (!ctr.name.equals(name)) continue;
                    result = ctr.value;
                    break;
                }
            }
        }
        return result;
    }

    private Map<Integer, CounterRec> getCounterMap(String groupName) {
        Map<Integer, CounterRec> map = this.counters.get(groupName);
        if (map == null) {
            map = new TreeMap<Integer, CounterRec>();
            this.counters.put(groupName, map);
        }
        return map;
    }

    private CounterRec getCounter(Map<Integer, CounterRec> counterMap, String counterName, int ordinal) {
        CounterRec result = counterMap.get(ordinal);
        if (result == null) {
            result = new CounterRec(counterName, 0L);
            counterMap.put(ordinal, result);
        }
        return result;
    }

    public synchronized void incrAllCounters(Counters other) {
        for (String groupName : other.counters.keySet()) {
            Map<Integer, CounterRec> otherCounters = other.counters.get(groupName);
            Map<Integer, CounterRec> myCounters = this.getCounterMap(groupName);
            for (int i : otherCounters.keySet()) {
                CounterRec otherCounter = otherCounters.get(i);
                CounterRec counter = this.getCounter(myCounters, otherCounter.name, i);
                counter.value += otherCounter.value;
            }
        }
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public synchronized int size() {
        int result = 0;
        for (String groupName : this.counters.keySet()) {
            result += this.counters.get(groupName).size();
        }
        return result;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (String groupName : this.counters.keySet()) {
            UTF8.writeString(out, groupName);
            Map<Integer, CounterRec> map = this.counters.get(groupName);
            out.writeInt(map.size());
            for (Integer ordinal : map.keySet()) {
                CounterRec counter = map.get(ordinal);
                out.writeInt(ordinal);
                UTF8.writeString(out, counter.name);
                out.writeLong(counter.value);
            }
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        while (numClasses-- > 0) {
            String groupName = UTF8.readString(in);
            Map<Integer, CounterRec> counters = this.getCounterMap(groupName);
            int numCounters = in.readInt();
            while (numCounters-- > 0) {
                int index = in.readInt();
                String counterName = UTF8.readString(in);
                long value = in.readLong();
                counters.put(index, new CounterRec(counterName, value));
            }
        }
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        Collection<String> groupNames = this.getGroupNames();
        for (String groupName : groupNames) {
            Group group = this.getGroup(groupName);
            log.info((Object)("  " + group.getDisplayName()));
            for (String counterName : group.getCounterNames()) {
                log.info((Object)("    " + group.getDisplayName(counterName) + "=" + group.getCounter(counterName)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group {
        private String groupName;
        private ResourceBundle bundle = null;
        private Map<String, Long> groupCounters = new LinkedHashMap<String, Long>();

        Group(String groupName, Collection<CounterRec> counters) {
            this.groupName = groupName;
            try {
                this.bundle = Group.getResourceBundle(groupName);
            }
            catch (MissingResourceException neverMind) {
                // empty catch block
            }
            for (CounterRec counter : counters) {
                this.groupCounters.put(counter.name, counter.value);
            }
        }

        private static ResourceBundle getResourceBundle(String enumClassName) {
            String bundleName = enumClassName.replace('$', '_');
            return ResourceBundle.getBundle(bundleName);
        }

        public String getName() {
            return this.groupName;
        }

        public String getDisplayName() {
            return this.localize("CounterGroupName", this.groupName);
        }

        public String getDisplayName(String counter) {
            return this.localize(counter + ".name", counter);
        }

        public Collection<String> getCounterNames() {
            return this.groupCounters.keySet();
        }

        public long getCounter(String counter) {
            Long result = this.groupCounters.get(counter);
            return result == null ? 0L : result;
        }

        public int size() {
            return this.groupCounters.size();
        }

        private String localize(String key, String defaultValue) {
            String result = defaultValue;
            if (this.bundle != null) {
                try {
                    result = this.bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    private static class CounterRec {
        public String name;
        public long value;

        public CounterRec(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }
}

