/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.lzo;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.util.NativeCodeLoader;

public class LzoCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog((String)LzoCompressor.class.getName());
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private Buffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufLen = 0;
    private Buffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private CompressionStrategy strategy;
    private long lzoCompressor = 0L;
    private int workingMemoryBufLen = 0;
    private Buffer workingMemoryBuf;
    private static boolean nativeLzoLoaded = false;

    public static boolean isNativeLzoLoaded() {
        return nativeLzoLoaded;
    }

    public LzoCompressor(CompressionStrategy strategy, int directBufferSize) {
        this.strategy = strategy;
        this.directBufferSize = directBufferSize;
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
        this.init(this.strategy.getCompressor());
        this.workingMemoryBuf = ByteBuffer.allocateDirect(this.workingMemoryBufLen);
    }

    public LzoCompressor() {
        this(CompressionStrategy.LZO1X_1, 65536);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        this.uncompressedDirectBufLen = this.userBufLen;
        if (this.uncompressedDirectBufLen > this.directBufferSize) {
            this.uncompressedDirectBufLen = this.directBufferSize;
        }
        this.uncompressedDirectBuf.rewind();
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        if (this.compressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.uncompressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = 0;
        n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            return n;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.limit(this.directBufferSize);
        n = this.compressBytesDirect(this.strategy.getCompressor());
        this.compressedDirectBuf.limit(n);
        if (this.userBufLen <= 0) {
            this.finished = true;
        }
        n = Math.min(n, len);
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    public synchronized void reset() {
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBufLen = 0;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    public synchronized void end() {
    }

    private static native void initIDs();

    private native void init(int var1);

    private native int compressBytesDirect(int var1);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            LzoCompressor.initIDs();
            nativeLzoLoaded = true;
        } else {
            LOG.error((Object)("Cannot load " + LzoCompressor.class.getName() + " without native-hadoop library!"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionStrategy {
        LZO1(0),
        LZO1_99(1),
        LZO1A(2),
        LZO1A_99(3),
        LZO1B(4),
        LZO1B_BEST_COMPRESSION(5),
        LZO1B_BEST_SPEED(6),
        LZO1B_1(7),
        LZO1B_2(8),
        LZO1B_3(9),
        LZO1B_4(10),
        LZO1B_5(11),
        LZO1B_6(12),
        LZO1B_7(13),
        LZO1B_8(14),
        LZO1B_9(15),
        LZO1B_99(16),
        LZO1B_999(17),
        LZO1C(18),
        LZO1C_BEST_COMPRESSION(19),
        LZO1C_BEST_SPEED(20),
        LZO1C_1(21),
        LZO1C_2(22),
        LZO1C_3(23),
        LZO1C_4(24),
        LZO1C_5(25),
        LZO1C_6(26),
        LZO1C_7(27),
        LZO1C_8(28),
        LZO1C_9(29),
        LZO1C_99(30),
        LZO1C_999(31),
        LZO1F_1(32),
        LZO1F_999(33),
        LZO1X_1(34),
        LZO1X_11(35),
        LZO1X_12(36),
        LZO1X_15(37),
        LZO1X_999(38),
        LZO1Y_1(39),
        LZO1Y_999(40),
        LZO1Z_999(41),
        LZO2A_999(42);

        private final int compressor;

        private CompressionStrategy(int compressor) {
            this.compressor = compressor;
        }

        int getCompressor() {
            return this.compressor;
        }
    }
}

