/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.HashMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class WritableFactories {
    private static final HashMap<Class, WritableFactory> CLASS_TO_FACTORY = new HashMap();

    private WritableFactories() {
    }

    public static synchronized void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static synchronized WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result = factory.newInstance();
            if (result instanceof Configurable) {
                ((Configurable)((Object)result)).setConf(conf);
            }
            return result;
        }
        return (Writable)ReflectionUtils.newInstance(c, conf);
    }

    public static Writable newInstance(Class c) {
        return WritableFactories.newInstance(c, null);
    }
}

