/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.INode;

class S3InputStream
extends FSInputStream {
    private FileSystemStore store;
    private Block[] blocks;
    private boolean closed;
    private long fileLength;
    private long pos = 0L;
    private File blockFile;
    private DataInputStream blockStream;
    private long blockEnd = -1L;

    public S3InputStream(Configuration conf, FileSystemStore store, INode inode) {
        this.store = store;
        for (Block block : this.blocks = inode.getBlocks()) {
            this.fileLength += block.getLength();
        }
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        return (int)(this.fileLength - this.pos);
    }

    public synchronized void seek(long targetPos) throws IOException {
        if (targetPos > this.fileLength) {
            throw new IOException("Cannot seek after EOF");
        }
        this.pos = targetPos;
        this.blockEnd = -1L;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int result = -1;
        if (this.pos < this.fileLength) {
            if (this.pos > this.blockEnd) {
                this.blockSeekTo(this.pos);
            }
            if ((result = this.blockStream.read()) >= 0) {
                ++this.pos;
            }
        }
        return result;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.pos < this.fileLength) {
            int realLen;
            int result;
            if (this.pos > this.blockEnd) {
                this.blockSeekTo(this.pos);
            }
            if ((result = this.blockStream.read(buf, off, realLen = Math.min(len, (int)(this.blockEnd - this.pos + 1L)))) >= 0) {
                this.pos += (long)result;
            }
            return result;
        }
        return -1;
    }

    private synchronized void blockSeekTo(long target) throws IOException {
        int targetBlock = -1;
        long targetBlockStart = 0L;
        long targetBlockEnd = 0L;
        for (int i = 0; i < this.blocks.length; ++i) {
            long blockLength = this.blocks[i].getLength();
            targetBlockEnd = targetBlockStart + blockLength - 1L;
            if (target >= targetBlockStart && target <= targetBlockEnd) {
                targetBlock = i;
                break;
            }
            targetBlockStart = targetBlockEnd + 1L;
        }
        if (targetBlock < 0) {
            throw new IOException("Impossible situation: could not find target position " + target);
        }
        long offsetIntoBlock = target - targetBlockStart;
        this.blockFile = this.store.retrieveBlock(this.blocks[targetBlock], offsetIntoBlock);
        this.pos = target;
        this.blockEnd = targetBlockEnd;
        this.blockStream = new DataInputStream(new FileInputStream(this.blockFile));
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.blockStream != null) {
            this.blockStream.close();
            this.blockStream = null;
        }
        if (this.blockFile != null) {
            this.blockFile.delete();
        }
        super.close();
        this.closed = true;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }
}

