/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class FSDataInputStream
extends DataInputStream
implements Seekable,
PositionedReadable {
    protected FSInputStream inStream;

    public FSDataInputStream(FSInputStream in, Configuration conf) throws IOException {
        this(in, conf.getInt("io.file.buffer.size", 4096));
    }

    public FSDataInputStream(FSInputStream in, int bufferSize) throws IOException {
        super(new Buffer(new PositionCache(in), bufferSize));
        this.inStream = in;
    }

    public synchronized void seek(long desired) throws IOException {
        ((Buffer)this.in).seek(desired);
    }

    public long getPos() throws IOException {
        return ((Buffer)this.in).getPos();
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return ((Buffer)this.in).read(position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        ((Buffer)this.in).readFully(position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        ((Buffer)this.in).readFully(position, buffer, 0, buffer.length);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return this.inStream.seekToNewSource(targetPos);
    }

    private static class Buffer
    extends BufferedInputStream {
        public Buffer(PositionCache in, int bufferSize) throws IOException {
            super(in, bufferSize);
        }

        public void seek(long desired) throws IOException {
            long end = ((PositionCache)this.in).getPos();
            long start = end - (long)this.count;
            int avail = this.count - this.pos;
            if (desired >= start && desired < end && avail > 0) {
                this.pos = (int)(desired - start);
            } else {
                this.count = 0;
                this.pos = 0;
                ((PositionCache)this.in).seek(desired);
            }
        }

        public long getPos() throws IOException {
            return ((PositionCache)this.in).getPos() - (long)(this.count - this.pos);
        }

        public int read() throws IOException {
            if (this.pos >= this.count) {
                return super.read();
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            return ((PositionCache)this.in).read(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            ((PositionCache)this.in).readFully(position, buffer, offset, length);
        }
    }

    private static class PositionCache
    extends FilterInputStream {
        long position;

        public PositionCache(FSInputStream in) throws IOException {
            super(in);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result > 0) {
                this.position += (long)result;
            }
            return result;
        }

        public void seek(long desired) throws IOException {
            ((FSInputStream)this.in).seek(desired);
            this.position = desired;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            return ((FSInputStream)this.in).read(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            ((FSInputStream)this.in).readFully(position, buffer, offset, length);
        }
    }
}

