/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.JspHelper;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.io.UTF8;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class browseDirectory_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static Vector _jspx_dependants;

    public void generateDirectoryStructure(JspWriter out, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UTF8 target;
        DFSClient dfs;
        String dir = req.getParameter("dir");
        if (dir == null || dir.length() == 0) {
            out.print("Invalid input");
            return;
        }
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if (!(dfs = new DFSClient(JspHelper.nameNodeAddr, JspHelper.conf)).isDirectory(target = new UTF8(dir))) {
            LocatedBlock[] blocks = dfs.namenode.open(dir);
            DatanodeInfo[] locations = blocks[0].getLocations();
            if (locations.length == 0) {
                out.print("Empty file");
            } else {
                DatanodeInfo chosenNode = jspHelper.bestNode(blocks[0]);
                String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
                String datanodeAddr = chosenNode.getName();
                int datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                String redirectLocation = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/browseBlock.jsp?blockId=" + blocks[0].getBlock().getBlockId() + "&blockSize=" + blocks[0].getBlock().getNumBytes() + "&filename=" + URLEncoder.encode(dir, "UTF-8") + "&datanodePort=" + datanodePort + "&namenodeInfoPort=" + namenodeInfoPort;
                resp.sendRedirect(redirectLocation);
            }
            return;
        }
        DFSFileInfo[] files = dfs.listPaths(target);
        String[] headings = new String[]{"Name", "Type", "Size", "Replication", "BlockSize"};
        out.print("<h3>Contents of directory " + dir + "</h3><hr>");
        File f = new File(dir);
        String parent = f.getParent();
        if (parent != null) {
            out.print("<a href=\"" + req.getRequestURL() + "?dir=" + parent + "&namenodeInfoPort=" + namenodeInfoPort + "\">Go to parent directory</a><br>");
        }
        if (files == null || files.length == 0) {
            out.print("Empty directory");
            dfs.close();
            return;
        }
        jspHelper.addTableHeader(out);
        int row = 0;
        jspHelper.addTableRow(out, headings, row++);
        String[] cols = new String[5];
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getPath().endsWith(".crc")) continue;
            if (!files[i].isDir()) {
                LocatedBlock[] blocks = dfs.namenode.open(files[i].getPath());
                DatanodeInfo[] locations = blocks[0].getLocations();
                if (locations.length == 0) {
                    cols[0] = files[i].getName();
                } else {
                    String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getPath(), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort;
                    cols[0] = "<a href=\"" + datanodeUrl + "\">" + files[i].getName() + "</a>";
                }
                cols[1] = "file";
                cols[2] = FsShell.byteDesc(files[i].getLen());
                cols[3] = Short.toString(files[i].getReplication());
                cols[4] = FsShell.byteDesc(files[i].getBlockSize());
            } else {
                String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getPath(), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort;
                cols[0] = "<a href=\"" + datanodeUrl + "\">" + files[i].getName() + "</a>";
                cols[1] = "dir";
                cols[2] = "";
                cols[3] = "";
                cols[4] = "";
            }
            jspHelper.addTableRow(out, cols, row++);
        }
        jspHelper.addTableFooter(out);
        String namenodeHost = JspHelper.nameNodeAddr.getHostName();
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        browseDirectory_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write("\n\n<html>\n<HEAD>\n<STYLE TYPE=text/css>\n<!--\nBODY \n  {\n  font-face:sanserif;\n  }\n-->\n</STYLE>\n<title>Hadoop DFS Directory Browsing</title>\n</HEAD>\n\n<body>\n");
            this.generateDirectoryStructure(out, request, response);
            out.write("\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n<hr>\n<a href=\"http://lucene.apache.org/hadoop\">Hadoop</a>, 2006.<br>\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

