/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.NameNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnderReplicatedBlocks {
    private static final int LEVEL = 3;
    private List<TreeSet<Block>> priorityQueues = new ArrayList<TreeSet<Block>>();

    UnderReplicatedBlocks() {
        for (int i = 0; i < 3; ++i) {
            this.priorityQueues.add(new TreeSet());
        }
    }

    synchronized int size() {
        int size = 0;
        for (int i = 0; i < 3; ++i) {
            size += this.priorityQueues.get(i).size();
        }
        return size;
    }

    synchronized boolean contains(Block block) {
        for (TreeSet<Block> set : this.priorityQueues) {
            if (!set.contains(block)) continue;
            return true;
        }
        return false;
    }

    private int getPriority(Block block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        if (curReplicas < 0 || curReplicas >= expectedReplicas) {
            return 3;
        }
        if (curReplicas == 0) {
            if (decommissionedReplicas > 0) {
                return 0;
            }
            return 3;
        }
        if (curReplicas == 1) {
            return 0;
        }
        if (curReplicas * 3 < expectedReplicas) {
            return 1;
        }
        return 2;
    }

    synchronized boolean add(Block block, int curReplicas, int decomissionedReplicas, int expectedReplicas) {
        if (curReplicas < 0 || expectedReplicas <= curReplicas) {
            return false;
        }
        int priLevel = this.getPriority(block, curReplicas, decomissionedReplicas, expectedReplicas);
        if (priLevel != 3 && this.priorityQueues.get(priLevel).add(block)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.add:" + block.getBlockName() + " has only " + curReplicas + " replicas and need " + expectedReplicas + " replicas so is added to neededReplications" + " at priority level " + priLevel));
            return true;
        }
        return false;
    }

    synchronized boolean remove(Block block, int oldReplicas, int decommissionedReplicas, int oldExpectedReplicas) {
        int priLevel = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        return this.remove(block, priLevel);
    }

    private boolean remove(Block block, int priLevel) {
        if (priLevel >= 0 && priLevel < 3 && this.priorityQueues.get(priLevel).remove(block)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block " + block.getBlockName() + " from priority queue " + priLevel));
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (i == priLevel || !this.priorityQueues.get(i).remove(block)) continue;
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.remove: Removing block " + block.getBlockName() + " from priority queue " + i));
            return true;
        }
        return false;
    }

    synchronized void update(Block block, int curReplicas, int decommissionedReplicas, int curExpectedReplicas, int curReplicasDelta, int expectedReplicasDelta) {
        int oldReplicas = curReplicas - curReplicasDelta;
        int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
        int curPri = this.getPriority(block, curReplicas, decommissionedReplicas, curExpectedReplicas);
        int oldPri = this.getPriority(block, oldReplicas, decommissionedReplicas, oldExpectedReplicas);
        NameNode.stateChangeLog.debug((Object)("UnderReplicationBlocks.update " + block + " curReplicas " + curReplicas + " curExpectedReplicas " + curExpectedReplicas + " oldReplicas " + oldReplicas + " oldExpectedReplicas  " + oldExpectedReplicas + " curPri  " + curPri + " oldPri  " + oldPri));
        if (oldPri != 3 && oldPri != curPri) {
            this.remove(block, oldPri);
        }
        if (curPri != 3 && oldPri != curPri && this.priorityQueues.get(curPri).add(block)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.UnderReplicationBlock.update:" + block.getBlockName() + " has only " + curReplicas + " replicas and need " + curExpectedReplicas + " replicas so is added to neededReplications" + " at priority level " + curPri));
        }
    }

    synchronized Iterator<Block> iterator() {
        return new Iterator<Block>(){
            private int level = 0;
            private List<Iterator<Block>> iterators = new ArrayList<Iterator<Block>>();
            {
                for (int i = 0; i < 3; ++i) {
                    this.iterators.add(((TreeSet)UnderReplicatedBlocks.this.priorityQueues.get(i)).iterator());
                }
            }

            private void update() {
                while (this.level < 2 && !this.iterators.get(this.level).hasNext()) {
                    ++this.level;
                }
            }

            @Override
            public Block next() {
                this.update();
                return this.iterators.get(this.level).next();
            }

            @Override
            public boolean hasNext() {
                this.update();
                return this.iterators.get(this.level).hasNext();
            }

            @Override
            public void remove() {
                this.iterators.get(this.level).remove();
            }
        };
    }
}

