/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.AlreadyBeingCreatedException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.DisallowedDatanodeException;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSEditLog;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FileUnderConstruction;
import org.apache.hadoop.dfs.FsckServlet;
import org.apache.hadoop.dfs.GetImageServlet;
import org.apache.hadoop.dfs.Host2NodesMap;
import org.apache.hadoop.dfs.LeaseExpiredException;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.NotReplicatedYetException;
import org.apache.hadoop.dfs.PendingReplicationBlocks;
import org.apache.hadoop.dfs.ReplicationTargetChooser;
import org.apache.hadoop.dfs.SafeModeException;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.UnderReplicatedBlocks;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSNamesystem
implements FSConstants {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.FSNamesystem");
    FSDirectory dir;
    BlocksMap blocksMap = new BlocksMap();
    Map<String, DatanodeDescriptor> datanodeMap = new TreeMap<String, DatanodeDescriptor>();
    private Map<String, Collection<Block>> recentInvalidateSets = new TreeMap<String, Collection<Block>>();
    private Map<String, Collection<Block>> excessReplicateMap = new TreeMap<String, Collection<Block>>();
    Map<UTF8, FileUnderConstruction> pendingCreates = new TreeMap<UTF8, FileUnderConstruction>();
    Collection<Block> pendingCreateBlocks = new TreeSet<Block>();
    long totalCapacity = 0L;
    long totalRemaining = 0L;
    int totalLoad = 0;
    StatusHttpServer infoServer;
    int infoPort;
    String infoBindAddress;
    Date startTime;
    Random r = new Random();
    ArrayList<DatanodeDescriptor> heartbeats = new ArrayList();
    private UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    private PendingReplicationBlocks pendingReplications;
    private Map<UTF8, Lease> leases = new TreeMap<UTF8, Lease>();
    private SortedSet<Lease> sortedLeases = new TreeSet<Lease>();
    Daemon hbthread = null;
    Daemon lmthread = null;
    Daemon smmthread = null;
    Daemon replthread = null;
    volatile boolean fsRunning = true;
    long systemStart = 0L;
    private int maxReplication;
    private int maxReplicationStreams;
    private int minReplication;
    private int defaultReplication;
    private long heartbeatRecheckInterval;
    private long heartbeatExpireInterval;
    private long replicationRecheckInterval;
    private long decommissionRecheckInterval;
    static int replIndex = 0;
    static int REPL_WORK_PER_ITERATION = 32;
    public static FSNamesystem fsNamesystemObject;
    private String localMachine;
    private int port;
    private SafeModeInfo safeMode;
    private Host2NodesMap host2DataNodeMap = new Host2NodesMap();
    NetworkTopology clusterMap = new NetworkTopology();
    ReplicationTargetChooser replicator;
    private HostsFileReader hostsReader;
    private Daemon dnthread = null;
    static Random randBlockId;

    public FSNamesystem(String hostname, int port, NameNode nn, Configuration conf) throws IOException {
        fsNamesystemObject = this;
        this.replicator = new ReplicationTargetChooser(conf.getBoolean("dfs.replication.considerLoad", true), this, this.clusterMap, LOG);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        this.maxReplication = conf.getInt("dfs.replication.max", 512);
        this.minReplication = conf.getInt("dfs.replication.min", 1);
        if (this.minReplication <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be greater than 0");
        }
        if (this.maxReplication >= Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + this.maxReplication + " must be less than " + Short.MAX_VALUE);
        }
        if (this.maxReplication < this.minReplication) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be less than dfs.replication.max = " + this.maxReplication);
        }
        this.maxReplicationStreams = conf.getInt("dfs.max-repl-streams", 2);
        long heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.heartbeatRecheckInterval = 300000L;
        this.heartbeatExpireInterval = 2L * this.heartbeatRecheckInterval + 10L * heartbeatInterval;
        this.replicationRecheckInterval = 3000L;
        this.decommissionRecheckInterval = conf.getInt("dfs.namenode.decommission.interval", 300000);
        this.localMachine = hostname;
        this.port = port;
        this.dir = new FSDirectory(this);
        FSConstants.StartupOption startOpt = (FSConstants.StartupOption)((Object)conf.get("dfs.namenode.startup", (Object)FSConstants.StartupOption.REGULAR));
        this.dir.loadFSImage(FSNamesystem.getNamespaceDirs(conf), startOpt);
        this.safeMode = new SafeModeInfo(conf);
        this.setBlockTotal();
        this.pendingReplications = new PendingReplicationBlocks(LOG);
        this.hbthread = new Daemon(new HeartbeatMonitor());
        this.lmthread = new Daemon(new LeaseMonitor());
        this.replthread = new Daemon(new ReplicationMonitor());
        this.hbthread.start();
        this.lmthread.start();
        this.replthread.start();
        this.systemStart = FSNamesystem.now();
        this.startTime = new Date(this.systemStart);
        this.hostsReader = new HostsFileReader(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        this.dnthread = new Daemon(new DecommissionedMonitor());
        this.dnthread.start();
        this.infoPort = conf.getInt("dfs.info.port", 50070);
        this.infoBindAddress = conf.get("dfs.info.bindAddress", "0.0.0.0");
        this.infoServer = new StatusHttpServer("dfs", this.infoBindAddress, this.infoPort, false);
        this.infoServer.setAttribute("name.system", this);
        this.infoServer.setAttribute("name.node", nn);
        this.infoServer.setAttribute("name.conf", conf);
        this.infoServer.addServlet("fsck", "/fsck", FsckServlet.class);
        this.infoServer.addServlet("getimage", "/getimage", GetImageServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        conf.set("dfs.info.port", this.infoPort);
        LOG.info((Object)("Web-server up at: " + conf.get("dfs.info.port")));
    }

    static Collection<File> getNamespaceDirs(Configuration conf) {
        String[] dirNames = conf.getStrings("dfs.name.dir");
        if (dirNames == null) {
            dirNames = new String[]{"/tmp/hadoop/dfs/name"};
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.length);
        for (int idx = 0; idx < dirNames.length; ++idx) {
            dirs.add(new File(dirNames[idx]));
        }
        return dirs;
    }

    FSNamesystem(FSImage fsImage) throws IOException {
        fsNamesystemObject = this;
        this.dir = new FSDirectory(fsImage, this);
    }

    public static FSNamesystem getFSNamesystem() {
        return fsNamesystemObject;
    }

    NamespaceInfo getNamespaceInfo() {
        return new NamespaceInfo(this.dir.fsImage.getNamespaceID(), this.dir.fsImage.getCTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        this.fsRunning = false;
        try {
            if (this.pendingReplications != null) {
                this.pendingReplications.stop();
            }
            if (this.infoServer != null) {
                this.infoServer.stop();
            }
            if (this.hbthread != null) {
                this.hbthread.interrupt();
            }
            if (this.replthread != null) {
                this.replthread.interrupt();
            }
            if (this.dnthread != null) {
                this.dnthread.interrupt();
            }
            if (this.smmthread != null) {
                this.smmthread.interrupt();
            }
        }
        catch (InterruptedException ie) {
            try {
                if (this.lmthread != null) {
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
            }
            catch (InterruptedException ie2) {
            }
            finally {
                try {
                    this.dir.close();
                }
                catch (IOException ex) {}
            }
        }
        finally {
            block45: {
                block44: {
                    if (this.lmthread == null) break block44;
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
                try {
                    this.dir.close();
                }
                catch (IOException ex) {}
                break block45;
                catch (InterruptedException ie) {
                    try {
                        this.dir.close();
                    }
                    catch (IOException ex) {}
                    catch (Throwable throwable) {
                        try {
                            this.dir.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        File file = new File(System.getProperty("hadoop.log.dir"), filename);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
            if (this.neededReplications.size() > 0) {
                Iterator<Block> it = this.neededReplications.iterator();
                while (it.hasNext()) {
                    Block block = it.next();
                    out.print(block);
                    Iterator<DatanodeDescriptor> jt = this.blocksMap.nodeIterator(block);
                    while (jt.hasNext()) {
                        DatanodeDescriptor node = jt.next();
                        out.print(" " + node + " : ");
                    }
                    out.println("");
                }
            }
        }
        this.pendingReplications.metaSave(out);
        this.dumpRecentInvalidateSets(out);
        this.datanodeDump(out);
        out.flush();
        out.close();
    }

    private int getReplication(Block block) {
        FSDirectory.INode fileINode = this.blocksMap.getINode(block);
        if (fileINode == null) {
            return 0;
        }
        return fileINode.getReplication();
    }

    synchronized void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        NumberReplicas repl = this.countNodes(block);
        int curExpectedReplicas = this.getReplication(block);
        this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
    }

    public synchronized Object[] open(String clientMachine, UTF8 src) {
        Object[] results = null;
        Block[] blocks = this.dir.getFile(src);
        if (blocks != null) {
            results = new Object[2];
            DatanodeDescriptor[][] machineSets = new DatanodeDescriptor[blocks.length][];
            DatanodeDescriptor client = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            for (int i = 0; i < blocks.length; ++i) {
                int numNodes = this.blocksMap.numNodes(blocks[i]);
                if (numNodes <= 0) {
                    machineSets[i] = new DatanodeDescriptor[0];
                    continue;
                }
                machineSets[i] = new DatanodeDescriptor[numNodes];
                numNodes = 0;
                Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blocks[i]);
                while (it.hasNext()) {
                    machineSets[i][numNodes++] = it.next();
                }
                this.clusterMap.sortByDistance(client, machineSets[i]);
            }
            results[0] = blocks;
            results[1] = machineSets;
        }
        return results;
    }

    public synchronized boolean setReplication(String src, short replication) throws IOException {
        int idx;
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
        }
        this.verifyReplication(src, replication, null);
        Vector<Integer> oldReplication = new Vector<Integer>();
        Block[] fileBlocks = this.dir.setReplication(src, replication, oldReplication);
        if (fileBlocks == null) {
            return false;
        }
        int oldRepl = oldReplication.elementAt(0);
        if (oldRepl == replication) {
            return true;
        }
        LOG.info((Object)("Increasing replication for file " + src + ". New replication is " + replication));
        for (idx = 0; idx < fileBlocks.length; ++idx) {
            this.updateNeededReplications(fileBlocks[idx], 0, replication - oldRepl);
        }
        if (oldRepl > replication) {
            LOG.info((Object)("Reducing replication for file " + src + ". New replication is " + replication));
            for (idx = 0; idx < fileBlocks.length; ++idx) {
                this.proccessOverReplicatedBlock(fileBlocks[idx], replication);
            }
        }
        return true;
    }

    public long getBlockSize(String filename) throws IOException {
        return this.dir.getBlockSize(filename);
    }

    private void verifyReplication(String src, short replication, UTF8 clientName) throws IOException {
        String text = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text + " is less than the required minimum " + this.minReplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] startFile(UTF8 src, UTF8 holder, UTF8 clientMachine, boolean overwrite, short replication, long blockSize) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: file " + src + " for " + holder + " at " + clientMachine));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create file" + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(src.toString())) {
            throw new IOException("Invalid file name: " + src);
        }
        try {
            DatanodeDescriptor clientNode;
            DatanodeDescriptor[] targets;
            FileUnderConstruction pendingFile = this.pendingCreates.get(src);
            if (pendingFile != null) {
                Lease lease = this.leases.get(holder);
                if (lease != null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file.");
                }
                UTF8 oldholder = pendingFile.getClientName();
                lease = this.leases.get(oldholder);
                if (lease == null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found.");
                }
                if (lease.expiredSoftLimit()) {
                    lease.releaseLocks();
                    this.leases.remove(lease.holder);
                    LOG.info((Object)("Removing lease " + lease + " "));
                    if (!this.sortedLeases.remove(lease)) {
                        LOG.error((Object)("Unknown failure trying to remove " + lease + " from lease set."));
                    }
                } else {
                    throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + ", because this file is already being created by " + pendingFile.getClientName() + " on " + pendingFile.getClientMachine());
                }
            }
            try {
                this.verifyReplication(src.toString(), replication, clientMachine);
            }
            catch (IOException e) {
                throw new IOException("failed to create " + e.getMessage());
            }
            if (!this.dir.isValidToCreate(src)) {
                if (overwrite) {
                    this.delete(src);
                } else {
                    throw new IOException("failed to create file " + src + " on client " + clientMachine + " either because the filename is invalid or the file exists");
                }
            }
            if ((targets = this.replicator.chooseTarget(replication, clientNode = this.host2DataNodeMap.getDatanodeByHost(clientMachine.toString()), null, blockSize)).length < this.minReplication) {
                if (this.clusterMap.getNumOfLeaves() == 0) {
                    throw new IOException("Failed to create file " + src + " on client " + clientMachine + " because this cluster has no datanodes.");
                }
                throw new IOException("Failed to create file " + src + " on client " + clientMachine + " because there were not enough datanodes available. " + "Found " + targets.length + " datanodes but MIN_REPLICATION for the cluster is " + "configured to be " + this.minReplication + ".");
            }
            this.pendingCreates.put(src, new FileUnderConstruction(replication, blockSize, holder, clientMachine, clientNode));
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: add " + src + " to pendingCreates for " + holder));
            Map<UTF8, Lease> map = this.leases;
            synchronized (map) {
                Lease lease = this.leases.get(holder);
                if (lease == null) {
                    lease = new Lease(holder);
                    this.leases.put(holder, lease);
                    this.sortedLeases.add(lease);
                } else {
                    this.sortedLeases.remove(lease);
                    lease.renew();
                    this.sortedLeases.add(lease);
                }
                lease.startedCreate(src);
            }
            Object[] results = new Object[]{this.allocateBlock(src), targets};
            return results;
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + ie.getMessage()));
            throw ie;
        }
    }

    public synchronized Object[] getAdditionalBlock(UTF8 src, UTF8 clientName) throws IOException {
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: file " + src + " for " + clientName));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot add block to " + src, this.safeMode);
        }
        FileUnderConstruction pendingFile = this.pendingCreates.get(src);
        if (pendingFile == null) {
            throw new LeaseExpiredException("No lease on " + src);
        }
        if (!pendingFile.getClientName().equals(clientName)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " and appended by " + clientName);
        }
        if (!this.checkFileProgress(pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet:" + src);
        }
        DatanodeDescriptor clientNode = pendingFile.getClientNode();
        DatanodeDescriptor[] targets = this.replicator.chooseTarget(pendingFile.getReplication(), clientNode, null, pendingFile.getBlockSize());
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes, instead of " + this.minReplication);
        }
        return new Object[]{this.allocateBlock(src), targets};
    }

    public synchronized boolean abandonBlock(Block b, UTF8 src) {
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b.getBlockName() + "of file " + src));
        FileUnderConstruction pendingFile = this.pendingCreates.get(src);
        if (pendingFile != null) {
            Collection<Block> pendingVector = pendingFile.getBlocks();
            Iterator<Block> it = pendingVector.iterator();
            while (it.hasNext()) {
                Block cur = it.next();
                if (cur.compareTo(b) != 0) continue;
                this.pendingCreateBlocks.remove(cur);
                it.remove();
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b.getBlockName() + " is removed from pendingCreateBlock and pendingCreates"));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abandonFileInProgress(UTF8 src, UTF8 holder) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.abandonFileInProgress:" + src));
        Map<UTF8, Lease> map = this.leases;
        synchronized (map) {
            Lease lease = this.leases.get(holder);
            if (lease != null) {
                if (lease.completedCreate(src)) {
                    this.internalReleaseCreate(src, holder);
                } else {
                    LOG.info((Object)("Attempt by " + holder.toString() + " to release someone else's create lock on " + src.toString()));
                }
            } else {
                LOG.info((Object)("Attempt to release a lock from an unknown lease holder " + holder.toString() + " for " + src.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int completeFile(UTF8 src, UTF8 holder) throws IOException {
        int i;
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete file " + src, this.safeMode);
        }
        FileUnderConstruction pendingFile = this.pendingCreates.get(src);
        if (this.dir.getFile(src) != null || pendingFile == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.completeFile: failed to complete " + src + " because dir.getFile()==" + this.dir.getFile(src) + " and " + pendingFile));
            return 0;
        }
        if (!this.checkFileProgress(pendingFile, true)) {
            return 1;
        }
        Collection<Block> blocks = pendingFile.getBlocks();
        int nrBlocks = blocks.size();
        Block[] pendingBlocks = blocks.toArray(new Block[nrBlocks]);
        for (i = 0; i < nrBlocks; ++i) {
            Block b = pendingBlocks[i];
            Block storedBlock = this.blocksMap.getStoredBlock(b);
            if (storedBlock == null) continue;
            pendingBlocks[i] = storedBlock;
        }
        if (!this.dir.addFile(src, pendingBlocks, pendingFile.getReplication())) {
            return 0;
        }
        this.pendingCreates.remove(src);
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " is removed from pendingCreates"));
        for (i = 0; i < nrBlocks; ++i) {
            this.pendingCreateBlocks.remove(pendingBlocks[i]);
        }
        Map<UTF8, Lease> i2 = this.leases;
        synchronized (i2) {
            Lease lease = this.leases.get(holder);
            if (lease != null) {
                lease.completedCreate(src);
                if (!lease.hasLocks()) {
                    this.leases.remove(holder);
                    this.sortedLeases.remove(lease);
                }
            }
        }
        short numExpectedReplicas = pendingFile.getReplication();
        for (int i3 = 0; i3 < nrBlocks; ++i3) {
            NumberReplicas number = this.countNodes(pendingBlocks[i3]);
            if (number.liveReplicas() >= numExpectedReplicas) continue;
            this.neededReplications.add(pendingBlocks[i3], number.liveReplicas(), number.decommissionedReplicas, numExpectedReplicas);
        }
        return 2;
    }

    synchronized Block allocateBlock(UTF8 src) {
        Block b = null;
        while (this.isValidBlock(b = new Block(randBlockId.nextLong(), 0L))) {
        }
        FileUnderConstruction v = this.pendingCreates.get(src);
        v.getBlocks().add(b);
        this.pendingCreateBlocks.add(b);
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.allocateBlock: " + src + ". " + b.getBlockName() + " is created and added to pendingCreates and pendingCreateBlocks"));
        return b;
    }

    synchronized boolean checkFileProgress(FileUnderConstruction v, boolean checkall) {
        if (checkall) {
            Iterator<Block> it = v.getBlocks().iterator();
            while (it.hasNext()) {
                if (this.blocksMap.numNodes(it.next()) >= this.minReplication) continue;
                return false;
            }
        } else {
            Block b = v.getPenultimateBlock();
            if (b != null && this.blocksMap.numNodes(b) < this.minReplication) {
                return false;
            }
        }
        return true;
    }

    private void addToInvalidates(Block b, DatanodeInfo n) {
        Collection<Block> invalidateSet = this.recentInvalidateSets.get(n.getStorageID());
        if (invalidateSet == null) {
            invalidateSet = new ArrayList<Block>();
            this.recentInvalidateSets.put(n.getStorageID(), invalidateSet);
        }
        invalidateSet.add(b);
    }

    private synchronized void dumpRecentInvalidateSets(PrintWriter out) {
        Collection<Collection<Block>> values = this.recentInvalidateSets.values();
        Iterator<Map.Entry<String, Collection<Block>>> it = this.recentInvalidateSets.entrySet().iterator();
        if (values.size() == 0) {
            out.println("Metasave: Blocks waiting deletion: 0");
            return;
        }
        out.println("Metasave: Blocks waiting deletion from " + values.size() + " datanodes.");
        while (it.hasNext()) {
            Map.Entry<String, Collection<Block>> entry = it.next();
            String storageId = entry.getKey();
            DatanodeDescriptor node = this.datanodeMap.get(storageId);
            Collection<Block> blklist = entry.getValue();
            if (blklist.size() <= 0) continue;
            out.print(node.getName());
            for (Block block : blklist) {
                out.print(" " + block);
            }
            out.println("");
        }
    }

    public synchronized void invalidateBlock(Block blk, DatanodeInfo dn) throws IOException {
        NameNode.stateChangeLog.info((Object)("DIR* NameSystem.invalidateBlock: " + blk.getBlockName() + " on " + dn.getName()));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot invalidate block " + blk.getBlockName(), this.safeMode);
        }
        int count = this.countNodes(blk).liveReplicas();
        if (count > 1) {
            this.addToInvalidates(blk, dn);
            this.removeStoredBlock(blk, this.getDatanode(dn));
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.invalidateBlocks: " + blk.getBlockName() + " on " + dn.getName() + " listed for deletion."));
        } else {
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.invalidateBlocks: " + blk.getBlockName() + " on " + dn.getName() + " is the only copy and was not deleted."));
        }
    }

    public synchronized boolean renameTo(UTF8 src, UTF8 dst) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(dst.toString())) {
            throw new IOException("Invalid name: " + dst);
        }
        return this.dir.renameTo(src, dst);
    }

    public synchronized boolean delete(UTF8 src) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot delete " + src, this.safeMode);
        }
        Block[] deletedBlocks = this.dir.delete(src);
        if (deletedBlocks != null) {
            for (int i = 0; i < deletedBlocks.length; ++i) {
                Block b = deletedBlocks[i];
                Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
                while (it.hasNext()) {
                    DatanodeDescriptor node = it.next();
                    this.addToInvalidates(b, node);
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.delete: " + b.getBlockName() + " is added to invalidSet of " + node.getName()));
                }
            }
        }
        return deletedBlocks != null;
    }

    public boolean exists(UTF8 src) {
        return this.dir.getFile(src) != null || this.dir.isDir(src);
    }

    public boolean isDir(UTF8 src) {
        return this.dir.isDir(src);
    }

    static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean mkdirs(String src) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create directory " + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(src)) {
            throw new IOException("Invalid directory name: " + src);
        }
        boolean success = this.dir.mkdirs(src);
        if (!success) {
            throw new IOException("Invalid directory name: " + src);
        }
        return success;
    }

    public String[][] getDatanodeHints(String src, long start, long len) {
        if (start < 0L || len < 0L) {
            return new String[0][];
        }
        int startBlock = -1;
        int endBlock = -1;
        Block[] blocks = this.dir.getFile(new UTF8(src));
        if (blocks == null) {
            return new String[0][];
        }
        long startpos = start;
        long endpos = start + len;
        for (int i = 0; i < blocks.length; ++i) {
            if (startpos >= 0L && (startpos -= blocks[i].getNumBytes()) <= 0L) {
                startBlock = i;
            }
            if (endpos < 0L || (endpos -= blocks[i].getNumBytes()) > 0L) continue;
            endBlock = i;
            break;
        }
        if (startBlock < 0 || endBlock < 0) {
            return new String[0][];
        }
        String[][] hosts = new String[endBlock - startBlock + 1][];
        for (int i = startBlock; i <= endBlock; ++i) {
            ArrayList<String> v = new ArrayList<String>();
            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blocks[i]);
            while (it.hasNext()) {
                v.add(it.next().getHostName());
            }
            hosts[i - startBlock] = v.toArray(new String[v.size()]);
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized int obtainLock(UTF8 src, UTF8 holder, boolean exclusive) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot lock file " + src, this.safeMode);
        }
        int result = this.dir.obtainLock(src, holder, exclusive);
        if (result == 2) {
            Map<UTF8, Lease> map = this.leases;
            synchronized (map) {
                Lease lease = this.leases.get(holder);
                if (lease == null) {
                    lease = new Lease(holder);
                    this.leases.put(holder, lease);
                    this.sortedLeases.add(lease);
                } else {
                    this.sortedLeases.remove(lease);
                    lease.renew();
                    this.sortedLeases.add(lease);
                }
                lease.obtained(src);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized int releaseLock(UTF8 src, UTF8 holder) {
        int result = this.internalReleaseLock(src, holder);
        if (result == 2) {
            Map<UTF8, Lease> map = this.leases;
            synchronized (map) {
                Lease lease = this.leases.get(holder);
                if (lease != null) {
                    lease.released(src);
                    if (!lease.hasLocks()) {
                        this.leases.remove(holder);
                        this.sortedLeases.remove(lease);
                    }
                }
            }
        }
        return result;
    }

    private int internalReleaseLock(UTF8 src, UTF8 holder) {
        return this.dir.releaseLock(src, holder);
    }

    private void internalReleaseCreate(UTF8 src, UTF8 holder) {
        FileUnderConstruction v = this.pendingCreates.remove(src);
        if (v != null) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.internalReleaseCreate: " + src + " is removed from pendingCreates for " + holder + " (failure)"));
            for (Block b : v.getBlocks()) {
                this.pendingCreateBlocks.remove(b);
            }
        } else {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseCreate: attempt to release a create lock on " + src.toString() + " that was not in pedingCreates"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLease(UTF8 holder) throws IOException {
        Map<UTF8, Lease> map = this.leases;
        synchronized (map) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
            }
            Lease lease = this.leases.get(holder);
            if (lease != null) {
                this.sortedLeases.remove(lease);
                lease.renew();
                this.sortedLeases.add(lease);
            }
        }
    }

    public DFSFileInfo[] getListing(UTF8 src) {
        return this.dir.getListing(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerDatanode(DatanodeRegistration nodeReg, String networkLocation) throws IOException {
        if (!this.verifyNodeRegistration(nodeReg)) {
            throw new DisallowedDatanodeException(nodeReg);
        }
        String dnAddress = Server.getRemoteAddress();
        if (dnAddress == null) {
            throw new IOException("Could not find remote address for registration from " + nodeReg.getName());
        }
        String hostName = nodeReg.getHost();
        DatanodeID dnReg = new DatanodeID(dnAddress + ":" + nodeReg.getPort(), nodeReg.getStorageID(), nodeReg.getInfoPort());
        nodeReg.updateRegInfo(dnReg);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.registerDatanode: node registration from " + nodeReg.getName() + " storage " + nodeReg.getStorageID()));
        DatanodeDescriptor nodeS = this.datanodeMap.get(nodeReg.getStorageID());
        DatanodeDescriptor nodeN = this.host2DataNodeMap.getDatanodeByName(nodeReg.getName());
        if (nodeN != null && nodeN != nodeS) {
            NameNode.LOG.info((Object)("BLOCK* NameSystem.registerDatanode: node from name: " + nodeN.getName()));
            this.removeDatanode(nodeN);
            this.wipeDatanode(nodeN);
            this.getEditLog().logRemoveDatanode(nodeN);
            nodeN = null;
        }
        if (nodeS != null) {
            if (nodeN == nodeS) {
                NameNode.stateChangeLog.debug((Object)"BLOCK* NameSystem.registerDatanode: node restarted.");
            } else {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.registerDatanode: node " + nodeS.getName() + " is replaced by " + nodeReg.getName() + "."));
            }
            this.getEditLog().logRemoveDatanode(nodeS);
            this.clusterMap.remove(nodeS);
            nodeS.updateRegInfo(nodeReg);
            nodeS.setNetworkLocation(networkLocation);
            this.clusterMap.add(nodeS);
            nodeS.setHostName(hostName);
            this.getEditLog().logAddDatanode(nodeS);
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                if (!this.heartbeats.contains(nodeS)) {
                    this.heartbeats.add(nodeS);
                    nodeS.updateHeartbeat(0L, 0L, 0);
                    nodeS.isAlive = true;
                }
            }
            return;
        }
        if (nodeReg.getStorageID().equals("")) {
            nodeReg.storageID = this.newStorageID();
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.registerDatanode: new storageID " + nodeReg.getStorageID() + " assigned."));
        }
        DatanodeDescriptor nodeDescr = new DatanodeDescriptor(nodeReg, networkLocation, hostName);
        this.unprotectedAddDatanode(nodeDescr);
        this.clusterMap.add(nodeDescr);
        this.getEditLog().logAddDatanode(nodeDescr);
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            this.heartbeats.add(nodeDescr);
            nodeDescr.isAlive = true;
        }
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage);
    }

    private String newStorageID() {
        String newID = null;
        while (newID == null) {
            newID = "DS" + Integer.toString(this.r.nextInt());
            if (this.datanodeMap.get(newID) == null) continue;
            newID = null;
        }
        return newID;
    }

    private boolean isDatanodeDead(DatanodeDescriptor node) {
        return node.getLastUpdate() < FSNamesystem.now() - this.heartbeatExpireInterval;
    }

    void setDatanodeDead(DatanodeID nodeID) throws IOException {
        DatanodeDescriptor node = this.getDatanode(nodeID);
        node.setLastUpdate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gotHeartbeat(DatanodeID nodeID, long capacity, long remaining, int xceiverCount, int xmitsInProgress, Object[] xferResults, Object[] deleteList) throws IOException {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            Map<String, DatanodeDescriptor> map = this.datanodeMap;
            synchronized (map) {
                DatanodeDescriptor nodeinfo;
                try {
                    nodeinfo = this.getDatanode(nodeID);
                    if (nodeinfo == null) {
                        return true;
                    }
                }
                catch (UnregisteredDatanodeException e) {
                    return true;
                }
                if (this.shouldNodeShutdown(nodeinfo)) {
                    this.setDatanodeDead(nodeinfo);
                    throw new DisallowedDatanodeException(nodeinfo);
                }
                if (!nodeinfo.isAlive) {
                    return true;
                }
                this.updateStats(nodeinfo, false);
                nodeinfo.updateHeartbeat(capacity, remaining, xceiverCount);
                this.updateStats(nodeinfo, true);
                nodeinfo.getReplicationSets(this.maxReplicationStreams - xmitsInProgress, xferResults);
                if (xferResults[0] == null) {
                    nodeinfo.getInvalidateBlocks(100, deleteList);
                }
                return false;
            }
        }
    }

    private void updateStats(DatanodeDescriptor node, boolean isAdded) {
        assert (Thread.holdsLock(this.heartbeats));
        if (isAdded) {
            this.totalCapacity += node.getCapacity();
            this.totalRemaining += node.getRemaining();
            this.totalLoad += node.getXceiverCount();
        } else {
            this.totalCapacity -= node.getCapacity();
            this.totalRemaining -= node.getRemaining();
            this.totalLoad -= node.getXceiverCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeDatanodeWork() throws IOException {
        int numiter = 0;
        int foundwork = 0;
        int hsize = 0;
        while (true) {
            Block[] blocklist;
            Object[] replsets;
            DatanodeDescriptor node = null;
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                hsize = this.heartbeats.size();
                if (numiter++ >= hsize) {
                    break;
                }
                if (replIndex >= hsize) {
                    replIndex = 0;
                }
                node = this.heartbeats.get(replIndex);
                ++replIndex;
            }
            int precomputed = node.getNumberOfBlocksToBeReplicated();
            int needed = this.maxReplicationStreams - precomputed;
            boolean doReplication = false;
            boolean doInvalidation = false;
            if (needed > 0 && (replsets = this.pendingTransfers(node, needed)) != null) {
                doReplication = true;
                this.addBlocksToBeReplicated(node, (Block[])replsets[0], (DatanodeDescriptor[][])replsets[1]);
            }
            if (!doReplication && (blocklist = this.blocksToInvalidate(node)) != null) {
                doInvalidation = true;
                this.addBlocksToBeInvalidated(node, blocklist);
            }
            if (!doReplication && !doInvalidation) continue;
            if (foundwork > hsize * REPL_WORK_PER_ITERATION / 100) break;
            ++foundwork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    this.neededReplications.add(timedOutItems[i], num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(timedOutItems[i]));
                }
            }
        }
    }

    synchronized void addBlocksToBeReplicated(DatanodeDescriptor node, Block[] blocklist, DatanodeDescriptor[][] targets) throws IOException {
        DatanodeDescriptor n = this.getDatanode(node);
        if (n != null) {
            n.addBlocksToBeReplicated(blocklist, targets);
        }
    }

    synchronized void addBlocksToBeInvalidated(DatanodeDescriptor node, Block[] blocklist) throws IOException {
        DatanodeDescriptor n = this.getDatanode(node);
        if (n != null) {
            n.addBlocksToBeInvalidated(blocklist);
        }
    }

    public synchronized void removeDatanode(DatanodeID nodeID) throws IOException {
        DatanodeDescriptor nodeInfo = this.getDatanode(nodeID);
        if (nodeInfo != null) {
            this.removeDatanode(nodeInfo);
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.removeDatanode: " + nodeID.getName() + " does not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (nodeInfo.isAlive) {
                this.updateStats(nodeInfo, false);
                this.heartbeats.remove(nodeInfo);
                nodeInfo.isAlive = false;
            }
        }
        Iterator<Block> it = nodeInfo.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), nodeInfo);
        }
        this.unprotectedRemoveDatanode(nodeInfo);
        this.clusterMap.remove(nodeInfo);
    }

    void unprotectedRemoveDatanode(DatanodeDescriptor nodeDescr) {
        nodeDescr.resetBlocks();
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedRemoveDatanode: " + nodeDescr.getName() + " is out of service now."));
    }

    void unprotectedAddDatanode(DatanodeDescriptor nodeDescr) {
        this.host2DataNodeMap.remove(this.datanodeMap.put(nodeDescr.getStorageID(), nodeDescr));
        this.host2DataNodeMap.add(nodeDescr);
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedAddDatanode: node " + nodeDescr.getName() + " is added to datanodeMap."));
    }

    void wipeDatanode(DatanodeID nodeID) throws IOException {
        String key = nodeID.getStorageID();
        this.host2DataNodeMap.remove(this.datanodeMap.remove(key));
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.wipeDatanode: " + nodeID.getName() + " storage " + key + " is removed from datanodeMap."));
    }

    private FSEditLog getEditLog() {
        return this.dir.fsImage.getEditLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeatCheck() {
        boolean allAlive = false;
        while (!allAlive) {
            boolean foundDead = false;
            DatanodeDescriptor nodeID = null;
            Object object = this.heartbeats;
            synchronized (object) {
                for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                    if (!this.isDatanodeDead(nodeInfo)) continue;
                    foundDead = true;
                    nodeID = nodeInfo;
                    break;
                }
            }
            if (foundDead) {
                object = this;
                synchronized (object) {
                    ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
                    synchronized (arrayList) {
                        Map<String, DatanodeDescriptor> map = this.datanodeMap;
                        synchronized (map) {
                            DatanodeDescriptor nodeInfo = null;
                            try {
                                nodeInfo = this.getDatanode(nodeID);
                            }
                            catch (IOException e) {
                                nodeInfo = null;
                            }
                            if (nodeInfo != null && this.isDatanodeDead(nodeInfo)) {
                                NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.heartbeatCheck: lost heartbeat from " + nodeInfo.getName()));
                                this.removeDatanode(nodeInfo);
                            }
                        }
                    }
                }
            }
            allAlive = !foundDead;
        }
    }

    public synchronized Block[] processReport(DatanodeID nodeID, Block[] newReport) throws IOException {
        DatanodeDescriptor node;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.processReport: from " + nodeID.getName() + " " + newReport.length + " blocks"));
        }
        if ((node = this.getDatanode(nodeID)) == null) {
            throw new IOException("ProcessReport from unregisterted node: " + nodeID.getName());
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        int newPos = 0;
        Iterator<Block> iter = node.getBlockIterator();
        Block oldblk = iter.hasNext() ? iter.next() : null;
        Block newblk = newReport != null && newReport.length > 0 ? newReport[0] : null;
        LinkedList<Block> toRemove = new LinkedList<Block>();
        LinkedList<Block> toAdd = new LinkedList<Block>();
        while (oldblk != null || newblk != null) {
            int cmp;
            int n = oldblk == null ? 1 : (cmp = newblk == null ? -1 : oldblk.compareTo(newblk));
            if (cmp == 0) {
                oldblk = iter.hasNext() ? iter.next() : null;
                newblk = newPos < newReport.length ? newReport[++newPos] : null;
                continue;
            }
            if (cmp < 0) {
                toRemove.add(oldblk);
                oldblk = iter.hasNext() ? iter.next() : null;
                continue;
            }
            toAdd.add(newblk);
            newblk = ++newPos < newReport.length ? newReport[newPos] : null;
        }
        for (Block b : toRemove) {
            this.removeStoredBlock(b, node);
            node.removeBlock(b);
        }
        for (Block b : toAdd) {
            node.addBlock(this.addStoredBlock(b, node));
        }
        ArrayList<Block> obsolete = new ArrayList<Block>();
        Iterator<Block> it = node.getBlockIterator();
        while (it.hasNext()) {
            Block b = it.next();
            if (this.isValidBlock(b) || this.pendingCreateBlocks.contains(b)) continue;
            if (obsolete.size() > 100) {
                this.addToInvalidates(b, node);
            } else {
                obsolete.add(b);
            }
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.processReport: ask " + nodeID.getName() + " to delete " + b.getBlockName()));
        }
        return obsolete.toArray(new Block[obsolete.size()]);
    }

    synchronized Block addStoredBlock(Block block, DatanodeDescriptor node) {
        FSDirectory.INode fileINode = this.blocksMap.getINode(block);
        int replication = fileINode != null ? fileINode.getReplication() : this.defaultReplication;
        boolean added = this.blocksMap.addNode(block, node, replication);
        Block storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock != null && block != storedBlock) {
            if (block.getNumBytes() > 0L) {
                storedBlock.setNumBytes(block.getNumBytes());
            }
            block = storedBlock;
        }
        int curReplicaDelta = 0;
        if (added) {
            curReplicaDelta = 1;
            if (NameNode.stateChangeLog.isTraceEnabled()) {
                NameNode.stateChangeLog.trace((Object)("BLOCK* NameSystem.addStoredBlock: blockMap updated: " + node.getName() + " is added to " + block.getBlockName()));
            }
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.addStoredBlock: Redundant addStoredBlock request received for " + block.getBlockName() + " on " + node.getName()));
        }
        if (fileINode == null) {
            return block;
        }
        NumberReplicas num = this.countNodes(block);
        int numCurrentReplica = num.liveReplicas() + this.pendingReplications.getNumReplicas(block);
        this.incrementSafeBlockCount(numCurrentReplica);
        short fileReplication = fileINode.getReplication();
        if (numCurrentReplica >= fileReplication) {
            this.neededReplications.remove(block, numCurrentReplica, num.decommissionedReplicas, fileReplication);
        } else {
            this.updateNeededReplications(block, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.proccessOverReplicatedBlock(block, fileReplication);
        }
        return block;
    }

    private void proccessOverReplicatedBlock(Block block, short replication) {
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned()) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication);
    }

    /*
     * WARNING - void declaration
     */
    void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication) {
        while (nonExcess.size() - replication > 0) {
            void var8_7;
            DatanodeID cur = null;
            long minSpace = Long.MAX_VALUE;
            for (DatanodeInfo datanodeInfo : nonExcess) {
                long free = datanodeInfo.getRemaining();
                if (minSpace <= free) continue;
                minSpace = free;
                cur = datanodeInfo;
            }
            nonExcess.remove(cur);
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks == null) {
                excessBlocks = new TreeSet<Block>();
                this.excessReplicateMap.put(cur.getStorageID(), excessBlocks);
            }
            excessBlocks.add(b);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.chooseExcessReplicates: (" + cur.getName() + ", " + b.getBlockName() + ") is added to excessReplicateMap"));
            Collection<Block> collection = this.recentInvalidateSets.get(cur.getStorageID());
            if (collection == null) {
                ArrayList arrayList = new ArrayList();
                this.recentInvalidateSets.put(cur.getStorageID(), arrayList);
            }
            var8_7.add(b);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.chooseExcessReplicates: (" + cur.getName() + ", " + b.getBlockName() + ") is added to recentInvalidateSets"));
        }
    }

    synchronized void removeStoredBlock(Block block, DatanodeDescriptor node) {
        Collection<Block> excessBlocks;
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block.getBlockName() + " from " + node.getName()));
        if (!this.blocksMap.removeNode(block, node)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block.getBlockName() + " has already been removed from node " + node));
            return;
        }
        this.decrementSafeBlockCount(block);
        FSDirectory.INode fileINode = this.blocksMap.getINode(block);
        if (fileINode != null) {
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null) {
            excessBlocks.remove(block);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block.getBlockName() + " is removed from excessBlocks"));
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getStorageID());
            }
        }
    }

    public synchronized void blockReceived(DatanodeID nodeID, Block block) throws IOException {
        DatanodeDescriptor node = this.getDatanode(nodeID);
        if (node == null) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.blockReceived: " + block.getBlockName() + " is received from an unrecorded node " + nodeID.getName()));
            throw new IllegalArgumentException("Unexpected exception.  Got blockReceived message from node " + block.getBlockName() + ", but there is no info for it");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.blockReceived: " + block.getBlockName() + " is received from " + nodeID.getName()));
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        node.addBlock(this.addStoredBlock(block, node));
        this.pendingReplications.remove(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long totalCapacity() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long totalRemaining() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalLoad() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalLoad;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DatanodeInfo[] datanodeReport() {
        DatanodeInfo[] results = null;
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            results = new DatanodeInfo[this.datanodeMap.size()];
            int i = 0;
            Iterator<DatanodeDescriptor> it = this.datanodeMap.values().iterator();
            while (it.hasNext()) {
                results[i++] = new DatanodeInfo(it.next());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                if (this.isDatanodeDead(node)) {
                    dead.add(node);
                    continue;
                }
                live.add(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void datanodeDump(PrintWriter out) {
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            out.println("Metasave: Number of datanodes: " + this.datanodeMap.size());
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                out.println(node.dumpDatanode());
            }
        }
    }

    private void startDecommission(DatanodeDescriptor node) throws IOException {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            LOG.info((Object)("Start Decommissioning node " + node.name));
            node.startDecommission();
            Block[] decommissionBlocks = node.getBlocks();
            for (int j = 0; j < decommissionBlocks.length; ++j) {
                this.updateNeededReplications(decommissionBlocks[j], -1, 0);
            }
        }
    }

    public void stopDecommission(DatanodeDescriptor node) throws IOException {
        LOG.info((Object)("Stop Decommissioning node " + node.name));
        node.stopDecommission();
    }

    public DatanodeInfo getDataNodeInfo(String name) {
        return this.datanodeMap.get(name);
    }

    public String getDFSNameNodeMachine() {
        return this.localMachine;
    }

    public int getDFSNameNodePort() {
        return this.port;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    short getMaxReplication() {
        return (short)this.maxReplication;
    }

    short getMinReplication() {
        return (short)this.minReplication;
    }

    short getDefaultReplication() {
        return (short)this.defaultReplication;
    }

    public synchronized Block[] blocksToInvalidate(DatanodeID nodeID) {
        int sendNum;
        if (this.isInSafeMode()) {
            return null;
        }
        Collection<Block> invalidateSet = this.recentInvalidateSets.remove(nodeID.getStorageID());
        if (invalidateSet == null) {
            return null;
        }
        Iterator<Block> it = null;
        int origSize = sendNum = invalidateSet.size();
        ArrayList<Block> sendBlock = new ArrayList<Block>(sendNum);
        if (sendNum > 100) {
            sendNum = 100;
        }
        it = invalidateSet.iterator();
        while (sendNum > 0) {
            assert (it.hasNext());
            sendBlock.add(it.next());
            it.remove();
            --sendNum;
        }
        if (it.hasNext()) {
            assert (origSize > 100);
            this.recentInvalidateSets.put(nodeID.getStorageID(), invalidateSet);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            StringBuffer blockList = new StringBuffer();
            for (int i = 0; i < sendBlock.size(); ++i) {
                blockList.append(' ');
                Block block = (Block)sendBlock.get(i);
                blockList.append(block.getBlockName());
            }
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.blockToInvalidate: ask " + nodeID.getName() + " to delete " + blockList));
        }
        return sendBlock.toArray(new Block[sendBlock.size()]);
    }

    private NumberReplicas countNodes(Iterator<DatanodeDescriptor> nodeIter) {
        int count = 0;
        int live = 0;
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++count;
                continue;
            }
            ++live;
        }
        return new NumberReplicas(live, count);
    }

    private NumberReplicas countNodes(Block b) {
        return this.countNodes(this.blocksMap.nodeIterator(b));
    }

    ArrayList<DatanodeDescriptor> containingNodeList(Block b, NumberReplicas[] numReplicas) {
        ArrayList<DatanodeDescriptor> nodeList = new ArrayList<DatanodeDescriptor>();
        int count = 0;
        int live = 0;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
                ++live;
            } else {
                ++count;
            }
            nodeList.add(node);
        }
        if (numReplicas != null) {
            numReplicas[0] = new NumberReplicas(live, count);
        }
        return nodeList;
    }

    private boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        Block[] decommissionBlocks = srcNode.getBlocks();
        boolean status = false;
        for (int i = 0; i < decommissionBlocks.length; ++i) {
            Block block = decommissionBlocks[i];
            FSDirectory.INode fileINode = this.blocksMap.getINode(block);
            if (fileINode == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (curExpectedReplicas <= curReplicas) continue;
            status = true;
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.update(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas, -1, 0);
        }
        return status;
    }

    private boolean checkDecommissionStateInternal(DatanodeDescriptor node) {
        if (node.isDecommissionInProgress() && !this.isReplicationInProgress(node)) {
            node.setDecommissioned();
            LOG.info((Object)("Decommission complete for node " + node.name));
        }
        return node.isDecommissioned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] pendingTransfers(DatanodeID srcNode, int needed) {
        if (this.isInSafeMode()) {
            return null;
        }
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            Object[] results = null;
            if (this.neededReplications.size() > 0) {
                ArrayList<Block> replicateBlocks = new ArrayList<Block>();
                ArrayList<NumberReplicas> numCurrentReplicas = new ArrayList<NumberReplicas>();
                ArrayList<DatanodeDescriptor[]> replicateTargetSets = new ArrayList<DatanodeDescriptor[]>();
                NumberReplicas[] allReplicas = new NumberReplicas[1];
                Iterator<Block> it = this.neededReplications.iterator();
                while (it.hasNext() && needed > 0) {
                    Block block = it.next();
                    long blockSize = block.getNumBytes();
                    FSDirectory.INode fileINode = this.blocksMap.getINode(block);
                    if (fileINode == null) {
                        it.remove();
                        continue;
                    }
                    ArrayList<DatanodeDescriptor> containingNodes = this.containingNodeList(block, allReplicas);
                    Collection<Block> excessBlocks = this.excessReplicateMap.get(srcNode.getStorageID());
                    if (!containingNodes.contains(srcNode) || excessBlocks != null && excessBlocks.contains(block)) continue;
                    int numCurrentReplica = allReplicas[0].liveReplicas() + this.pendingReplications.getNumReplicas(block);
                    NumberReplicas repl = new NumberReplicas(numCurrentReplica, allReplicas[0].decommissionedReplicas());
                    if (numCurrentReplica >= fileINode.getReplication()) {
                        it.remove();
                        continue;
                    }
                    DatanodeDescriptor[] targets = this.replicator.chooseTarget(Math.min(fileINode.getReplication() - numCurrentReplica, needed), this.datanodeMap.get(srcNode.getStorageID()), containingNodes, null, blockSize);
                    if (targets.length <= 0) continue;
                    replicateBlocks.add(block);
                    numCurrentReplicas.add(repl);
                    replicateTargetSets.add(targets);
                    needed -= targets.length;
                }
                if (replicateBlocks.size() > 0) {
                    int i = 0;
                    for (Block block : replicateBlocks) {
                        short numExpectedReplica;
                        DatanodeDescriptor[] targets = (DatanodeDescriptor[])replicateTargetSets.get(i);
                        int numCurrentReplica = ((NumberReplicas)numCurrentReplicas.get(i)).liveReplicas();
                        if (numCurrentReplica + targets.length >= (numExpectedReplica = this.blocksMap.getINode(block).getReplication())) {
                            this.neededReplications.remove(block, numCurrentReplica, ((NumberReplicas)numCurrentReplicas.get(i)).decommissionedReplicas(), numExpectedReplica);
                            this.pendingReplications.add(block, targets.length);
                            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.pendingTransfer: " + block.getBlockName() + " is removed from neededReplications to pendingReplications"));
                        }
                        if (NameNode.stateChangeLog.isInfoEnabled()) {
                            StringBuffer targetList = new StringBuffer("datanode(s)");
                            for (int k = 0; k < targets.length; ++k) {
                                targetList.append(' ');
                                targetList.append(targets[k].getName());
                            }
                            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.pendingTransfer: ask " + srcNode.getName() + " to replicate " + block.getBlockName() + " to " + targetList));
                            NameNode.stateChangeLog.debug((Object)("BLOCK* neededReplications = " + this.neededReplications.size() + " pendingReplications = " + this.pendingReplications.size()));
                        }
                        ++i;
                    }
                    DatanodeDescriptor[][] targetMatrix = new DatanodeDescriptor[replicateTargetSets.size()][];
                    for (i = 0; i < targetMatrix.length; ++i) {
                        targetMatrix[i] = (DatanodeDescriptor[])replicateTargetSets.get(i);
                    }
                    results = new Object[]{replicateBlocks.toArray(new Block[replicateBlocks.size()]), targetMatrix};
                }
            }
            return results;
        }
    }

    private boolean inHostsList(DatanodeID node) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(node.getName()) || hostsList.contains(node.getHost()) || node instanceof DatanodeInfo && hostsList.contains(((DatanodeInfo)node).getHostName());
    }

    private boolean inExcludedHostsList(DatanodeID node) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(node.getName()) || excludeList.contains(node.getHost()) || node instanceof DatanodeInfo && excludeList.contains(((DatanodeInfo)node).getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNodes() throws IOException {
        this.hostsReader.refresh();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                if (!this.inHostsList(node)) {
                    node.setDecommissioned();
                    continue;
                }
                if (this.inExcludedHostsList(node)) {
                    if (node.isDecommissionInProgress() || node.isDecommissioned()) continue;
                    this.startDecommission(node);
                    continue;
                }
                if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
                this.stopDecommission(node);
            }
        }
    }

    public synchronized boolean verifyNodeRegistration(DatanodeRegistration nodeReg) throws IOException {
        DatanodeDescriptor node;
        if (!this.inHostsList(nodeReg)) {
            return false;
        }
        if (this.inExcludedHostsList(nodeReg) && !this.checkDecommissionStateInternal(node = this.getDatanode(nodeReg))) {
            this.startDecommission(node);
        }
        return true;
    }

    private boolean shouldNodeShutdown(DatanodeDescriptor node) {
        return node.isDecommissioned();
    }

    public synchronized void decommissionedDatanodeCheck() {
        for (DatanodeDescriptor node : this.datanodeMap.values()) {
            this.checkDecommissionStateInternal(node);
        }
    }

    public DatanodeDescriptor getDatanode(DatanodeID nodeID) throws IOException {
        UnregisteredDatanodeException e = null;
        DatanodeDescriptor node = this.datanodeMap.get(nodeID.getStorageID());
        if (node == null) {
            return null;
        }
        if (!node.getName().equals(nodeID.getName())) {
            e = new UnregisteredDatanodeException(nodeID, node);
            NameNode.stateChangeLog.fatal((Object)("BLOCK* NameSystem.getDatanode: " + e.getLocalizedMessage()));
            throw e;
        }
        return node;
    }

    private DatanodeDescriptor getDatanodeByIndex(int index) {
        int i = 0;
        for (DatanodeDescriptor node : this.datanodeMap.values()) {
            if (i == index) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public String randomDataNode() {
        int size = this.datanodeMap.size();
        int index = 0;
        if (size != 0) {
            index = this.r.nextInt(size);
            for (int i = 0; i < size; ++i) {
                DatanodeDescriptor d = this.getDatanodeByIndex(index);
                if (!(d == null || d.isDecommissioned() || this.isDatanodeDead(d) || d.isDecommissionInProgress())) {
                    return d.getHost() + ":" + d.getInfoPort();
                }
                index = (index + 1) % size;
            }
        }
        return null;
    }

    public int getNameNodeInfoPort() {
        return this.infoPort;
    }

    static long now() {
        return System.currentTimeMillis();
    }

    boolean isInSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn();
    }

    void incrementSafeBlockCount(int replication) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.incrementSafeBlockCount((short)replication);
    }

    void decrementSafeBlockCount(Block b) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.decrementSafeBlockCount((short)this.countNodes(b).liveReplicas());
    }

    void setBlockTotal() {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.setBlockTotal(this.blocksMap.size());
    }

    synchronized void enterSafeMode() throws IOException {
        if (this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* FSNamesystem.enterSafeMode: Safe mode is already ON.");
            return;
        }
        this.safeMode = new SafeModeInfo();
    }

    synchronized void leaveSafeMode() throws IOException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* FSNamesystem.leaveSafeMode: Safe mode is already OFF.");
            return;
        }
        this.safeMode.leave();
    }

    String getSafeModeTip() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return this.safeMode.getTurnOffTip();
    }

    long getEditLogSize() throws IOException {
        return this.getEditLog().getEditLogSize();
    }

    synchronized void rollEditLog() throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Checkpoint not created", this.safeMode);
        }
        LOG.info((Object)"Roll Edit Log");
        this.getEditLog().rollEditLog();
    }

    synchronized void rollFSImage() throws IOException {
        LOG.info((Object)"Roll FSImage");
        if (this.isInSafeMode()) {
            throw new SafeModeException("Checkpoint not created", this.safeMode);
        }
        this.dir.fsImage.rollFSImage();
    }

    File getFsEditName() throws IOException {
        return this.getEditLog().getFsEditName();
    }

    public boolean isValidBlock(Block b) {
        return this.blocksMap.getINode(b) != null;
    }

    static {
        randBlockId = new Random();
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            FSNamesystem.this.safeMode.leave();
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int extension;
        private int safeReplication;
        private long reached = -1L;
        int blockTotal;
        private int blockSafe;

        SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.safemode.threshold.pct", 0.95f);
            this.extension = conf.getInt("dfs.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.replication.min", 1);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private SafeModeInfo() {
            this.threshold = 1.5;
            this.extension = 0;
            this.safeReplication = 32768;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.reached = -1L;
            this.enter();
        }

        synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match.";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException(e));
            }
            return this.reached >= 0L;
        }

        void enter() {
            if (this.reached != 0L) {
                NameNode.stateChangeLog.info((Object)("STATE* SafeModeInfo.enter: Safe mode is ON.\n" + this.getTurnOffTip()));
            }
            this.reached = 0L;
        }

        synchronized void leave() {
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* SafeModeInfo.leave: Safe mode is OFF.");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + FSNamesystem.this.clusterMap.getNumOfRacks() + " racks and " + FSNamesystem.this.clusterMap.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.neededReplications.size() + " blocks"));
        }

        synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (FSNamesystem.now() - this.reached < (long)this.extension) {
                return false;
            }
            return !this.needEnter();
        }

        boolean needEnter() {
            return (double)this.getSafeBlockRatio() < this.threshold;
        }

        private float getSafeBlockRatio() {
            return this.blockTotal == 0 ? 1.0f : (float)this.blockSafe / (float)this.blockTotal;
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave();
                return;
            }
            if (this.reached > 0L) {
                return;
            }
            this.reached = FSNamesystem.now();
            FSNamesystem.this.smmthread = new Daemon(new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
        }

        synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.checkMode();
        }

        synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        boolean isManual() {
            return this.blockTotal == -1;
        }

        String getTurnOffTip() {
            return this.isManual() ? "Use \"hadoop dfs -safemode leave\" to turn safe mode off." : "Safe mode will be turned off automatically.";
        }

        public String toString() {
            String resText = "Current safe block ratio = " + this.getSafeBlockRatio() + ". Target threshold = " + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blocksMap.size();
            Iterator it = FSNamesystem.this.recentInvalidateSets.values().iterator();
            while (it.hasNext()) {
                activeBlocks -= ((Collection)it.next()).size();
            }
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    class DecommissionedMonitor
    implements Runnable {
        DecommissionedMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.decommissionedDatanodeCheck();
                }
                catch (Exception e) {
                    LOG.info((Object)StringUtils.stringifyException(e));
                }
                try {
                    Thread.sleep(FSNamesystem.this.decommissionRecheckInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static class NumberReplicas {
        private int liveReplicas;
        private int decommissionedReplicas;

        NumberReplicas(int live, int decommissioned) {
            this.liveReplicas = live;
            this.decommissionedReplicas = decommissioned;
        }

        int liveReplicas() {
            return this.liveReplicas;
        }

        int decommissionedReplicas() {
            return this.decommissionedReplicas;
        }
    }

    class ReplicationMonitor
    implements Runnable {
        ReplicationMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.computeDatanodeWork();
                    FSNamesystem.this.processPendingReplications();
                    Thread.sleep(FSNamesystem.this.replicationRecheckInterval);
                }
                catch (InterruptedException ie) {
                }
                catch (IOException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received exception. " + ie));
                }
            }
        }
    }

    class HeartbeatMonitor
    implements Runnable {
        HeartbeatMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.heartbeatCheck();
                }
                catch (Exception e) {
                    LOG.error((Object)StringUtils.stringifyException(e));
                }
                try {
                    Thread.sleep(FSNamesystem.this.heartbeatRecheckInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class LeaseMonitor
    implements Runnable {
        LeaseMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning) {
                    FSNamesystem fSNamesystem = FSNamesystem.this;
                    synchronized (fSNamesystem) {
                        Map map = FSNamesystem.this.leases;
                        synchronized (map) {
                            Lease top;
                            while (FSNamesystem.this.sortedLeases.size() > 0 && (top = (Lease)FSNamesystem.this.sortedLeases.first()) != null && top.expiredHardLimit()) {
                                top.releaseLocks();
                                FSNamesystem.this.leases.remove(top.holder);
                                LOG.info((Object)("Removing lease " + top + ", leases remaining: " + FSNamesystem.this.sortedLeases.size()));
                                if (FSNamesystem.this.sortedLeases.remove(top)) continue;
                                LOG.info((Object)("Unknown failure trying to remove " + top + " from lease set."));
                            }
                        }
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException(e));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Lease
    implements Comparable<Lease> {
        public UTF8 holder;
        public long lastUpdate;
        private Collection<UTF8> locks = new TreeSet<UTF8>();
        private Collection<UTF8> creates = new TreeSet<UTF8>();

        public Lease(UTF8 holder) {
            this.holder = holder;
            this.renew();
        }

        public void renew() {
            this.lastUpdate = FSNamesystem.now();
        }

        public boolean expiredHardLimit() {
            return FSNamesystem.now() - this.lastUpdate > 3600000L;
        }

        public boolean expiredSoftLimit() {
            return FSNamesystem.now() - this.lastUpdate > 60000L;
        }

        public void obtained(UTF8 src) {
            this.locks.add(src);
        }

        public void released(UTF8 src) {
            this.locks.remove(src);
        }

        public void startedCreate(UTF8 src) {
            this.creates.add(src);
        }

        public boolean completedCreate(UTF8 src) {
            return this.creates.remove(src);
        }

        public boolean hasLocks() {
            return this.locks.size() + this.creates.size() > 0;
        }

        public void releaseLocks() {
            Iterator<UTF8> it = this.locks.iterator();
            while (it.hasNext()) {
                FSNamesystem.this.internalReleaseLock(it.next(), this.holder);
            }
            this.locks.clear();
            it = this.creates.iterator();
            while (it.hasNext()) {
                FSNamesystem.this.internalReleaseCreate(it.next(), this.holder);
            }
            this.creates.clear();
        }

        public String toString() {
            return "[Lease.  Holder: " + this.holder.toString() + ", heldlocks: " + this.locks.size() + ", pendingcreates: " + this.creates.size() + "]";
        }

        @Override
        public int compareTo(Lease o) {
            Lease l1 = this;
            Lease l2 = o;
            long lu1 = l1.lastUpdate;
            long lu2 = l2.lastUpdate;
            if (lu1 < lu2) {
                return -1;
            }
            if (lu1 > lu2) {
                return 1;
            }
            return l1.holder.compareTo(l2.holder);
        }
    }
}

