/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.util.ToolBase;

public class DFSck
extends ToolBase {
    private static final Log LOG = LogFactory.getLog((String)DFSck.class.getName());

    DFSck() {
    }

    public DFSck(Configuration conf) throws Exception {
        this.setConf(conf);
    }

    private String getInfoServer() throws IOException {
        InetSocketAddress addr = DataNode.createSocketAddr(this.conf.get("fs.default.name"));
        int infoPort = this.conf.getInt("dfs.info.port", 50070);
        return addr.getHostName() + ":" + infoPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        int idx;
        String fsName = this.getInfoServer();
        if (args.length == 0) {
            System.err.println("Usage: DFSck <path> [-move | -delete] [-files] [-blocks [-locations]]");
            System.err.println("\t<path>\tstart checking from this path");
            System.err.println("\t-move\tmove corrupted files to /lost+found");
            System.err.println("\t-delete\tdelete corrupted files");
            System.err.println("\t-files\tprint out files being checked");
            System.err.println("\t-blocks\tprint out block report");
            System.err.println("\t-locations\tprint out locations for every block");
            return -1;
        }
        StringBuffer url = new StringBuffer("http://" + fsName + "/fsck?path=");
        String dir = "/";
        for (idx = 0; idx < args.length; ++idx) {
            if (args[idx].startsWith("-")) continue;
            dir = args[idx];
            break;
        }
        url.append(URLEncoder.encode(dir, "UTF-8"));
        for (idx = 0; idx < args.length; ++idx) {
            if (args[idx].equals("-move")) {
                url.append("&move=1");
                continue;
            }
            if (args[idx].equals("-delete")) {
                url.append("&delete=1");
                continue;
            }
            if (args[idx].equals("-files")) {
                url.append("&files=1");
                continue;
            }
            if (args[idx].equals("-blocks")) {
                url.append("&blocks=1");
                continue;
            }
            if (!args[idx].equals("-locations")) continue;
            url.append("&locations=1");
        }
        URL path = new URL(url.toString());
        URLConnection connection = path.openConnection();
        InputStream stream = connection.getInputStream();
        InputStreamReader input = new InputStreamReader(stream, "UTF-8");
        try {
            int c = input.read();
            while (c != -1) {
                System.out.print((char)c);
                c = input.read();
            }
        }
        finally {
            input.close();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = new DFSck().doMain(new Configuration(), args);
        System.exit(res);
    }
}

