/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class DFSFileInfo
implements Writable {
    UTF8 path;
    long len;
    long contentsLen;
    boolean isDir;
    short blockReplication;
    long blockSize;

    public DFSFileInfo() {
    }

    public DFSFileInfo(FSDirectory.INode node) {
        this.path = new UTF8(node.computeName());
        this.isDir = node.isDir();
        if (this.isDir) {
            this.len = 0L;
            this.contentsLen = node.computeContentsLength();
        } else {
            this.len = this.contentsLen = node.computeFileLength();
        }
        this.blockReplication = node.getReplication();
        this.blockSize = node.getBlockSize();
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getName() {
        return new Path(this.path.toString()).getName();
    }

    public String getParent() {
        return new Path(this.path.toString()).getParent().toString();
    }

    public long getLen() {
        return this.len;
    }

    public long getContentsLen() {
        return this.contentsLen;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void write(DataOutput out) throws IOException {
        this.path.write(out);
        out.writeLong(this.len);
        out.writeLong(this.contentsLen);
        out.writeBoolean(this.isDir);
        out.writeShort(this.blockReplication);
        out.writeLong(this.blockSize);
    }

    public void readFields(DataInput in) throws IOException {
        this.path = new UTF8();
        this.path.readFields(in);
        this.len = in.readLong();
        this.contentsLen = in.readLong();
        this.isDir = in.readBoolean();
        this.blockReplication = in.readShort();
        this.blockSize = in.readLong();
    }

    static {
        WritableFactories.setFactory(DFSFileInfo.class, new WritableFactory(){

            public Writable newInstance() {
                return new DFSFileInfo();
            }
        });
    }
}

